/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.message.packaging.EbmsEbxmlMessageException;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.impl.EbxmlMessageFactoryImpl;
import org.kldp.ebmsh.message.packaging.impl.EbxmlMessageImpl;
import org.kldp.ebmsh.message.transport.EbmsSSLProtocolSocketFactory;
import org.kldp.ebmsh.message.transport.EbmsTransportException;
import org.kldp.ebmsh.message.util.MessageUtil;

class HttpTransport {
    private static Log log = LogFactory.getLog(HttpTransport.class);
    private final int HTTP_DEFAULT_PORT = 80;
    private final int HTTPS_DEFAULT_PORT = 443;
    private static HttpClient httpClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpTransport() {
        Class<HttpTransport> clazz = HttpTransport.class;
        synchronized (HttpTransport.class) {
            if (httpClient == null) {
                MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
                connectionManager.getParams().setMaxTotalConnections(50);
                httpClient = new HttpClient((HttpConnectionManager)connectionManager);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private HostConfiguration createHostConfiguration(String urlProtocol, String urlHost, int urlPort) throws EbmsTransportException {
        Protocol protocol = null;
        if (urlProtocol.toLowerCase().equals("http")) {
            if (urlPort == -1) {
                urlPort = 80;
            }
            protocol = new Protocol(urlProtocol, (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), urlPort);
        } else if (urlProtocol.toLowerCase().equals("https")) {
            if (urlPort == -1) {
                urlPort = 443;
            }
            protocol = new Protocol(urlProtocol, (ProtocolSocketFactory)new EbmsSSLProtocolSocketFactory(), urlPort);
        } else {
            throw new EbmsTransportException(1, 0, "\uc54c \uc218 \uc5c6\ub294 \ud504\ub85c\ud1a0\ucf5c \uc785\ub2c8\ub2e4. Protocol -> " + urlProtocol);
        }
        HostConfiguration configuration = new HostConfiguration();
        configuration.setHost(urlHost, urlPort, protocol);
        return configuration;
    }

    public EbxmlMessage sendMessage(EbxmlMessage ebxmlMessage, String url) throws EbmsTransportException {
        log.info((Object)("\ubcf4\ub0b4\ub294 URL : " + url));
        PostMethod postMethod = null;
        URL urlParser = null;
        try {
            urlParser = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new EbmsTransportException(1, 0, "url\uc744 parsing \ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. url -> " + url, e);
        }
        String urlProtocol = urlParser.getProtocol();
        String urlHost = urlParser.getHost();
        int urlPort = urlParser.getPort();
        String urlPath = urlParser.getPath();
        try {
            HostConfiguration hostConfiguration = this.createHostConfiguration(urlProtocol, urlHost, urlPort);
            postMethod = new PostMethod(urlPath);
            if (ebxmlMessage.saveRequired()) {
                ebxmlMessage.saveChanges();
            }
            try {
                this.setMimeHeader(ebxmlMessage);
            }
            catch (EbmsEbxmlMessageException e) {
                throw new EbmsTransportException(1, 0, "Set MimeHeader error", e);
            }
            MimeHeaders mimeHeaders = ebxmlMessage.getMimeHeaders();
            Iterator headerIter = mimeHeaders.getAllHeaders();
            byte[] ebxmlMessageByteArray = ebxmlMessage.getMsgAsBytes();
            ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(ebxmlMessageByteArray);
            postMethod.setRequestEntity((RequestEntity)byteArrayRequestEntity);
            log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
            while (headerIter.hasNext()) {
                MimeHeader header = (MimeHeader)headerIter.next();
                String headerName = header.getName();
                String headerValue = header.getValue();
                if (headerName.equals("Content-Length")) {
                    headerValue = String.valueOf(byteArrayRequestEntity.getContentLength());
                }
                if (headerName.equals("Content-Type")) {
                    headerValue = String.valueOf(headerValue) + "; start=\"MessageContentId\"";
                }
                postMethod.setRequestHeader(headerName, headerValue);
                log.info((Object)(String.valueOf(headerName) + ": " + headerValue));
            }
            log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
            log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0 -------------------");
            ByteArrayRequestEntity sre = (ByteArrayRequestEntity)postMethod.getRequestEntity();
            log.info((Object)new String(sre.getContent()));
            log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0 -------------------");
            int responseCode = httpClient.executeMethod(hostConfiguration, (HttpMethod)postMethod);
            log.info((Object)"---------- \ubc1b\uc740 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
            MimeHeaders responseMimeheaders = this.getMimeHeaders(postMethod.getResponseHeaders());
            Iterator responseHeaderIter = responseMimeheaders.getAllHeaders();
            while (responseHeaderIter.hasNext()) {
                MimeHeader header = (MimeHeader)responseHeaderIter.next();
                String headerName = header.getName();
                String headerValue = header.getValue();
                log.info((Object)(String.valueOf(headerName) + ": " + headerValue));
            }
            log.info((Object)"---------- \ubc1b\uc740 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
            log.info((Object)postMethod.getResponseBodyAsString());
            if (responseCode >= 300 && responseCode <= 500) {
                throw new IOException("\uc11c\ubc84\uc758 \uc751\ub2f5\uc774 \uc774\uc0c1\ud569\ub2c8\ub2e4 -> " + responseCode + "\n \ub0b4\uc6a9 -> " + postMethod.getResponseBodyAsString());
            }
            if (postMethod.getResponseContentLength() <= 0L) {
                return null;
            }
            EbxmlMessageImpl responseEbxmlMessage = null;
            Header[] header = postMethod.getResponseHeaders();
            MimeHeaders headers = this.getMimeHeaders(header);
            EbxmlMessageFactoryImpl ebxmlMessageFactory = new EbxmlMessageFactoryImpl();
            InputStream messageInputStream = postMethod.getResponseBodyAsStream();
            log.info((Object)"SOAPMessage\ub97c \uc0dd\uc131\ud569\ub2c8\ub2e4. ");
            SOAPMessage soapMessage = ebxmlMessageFactory.createMessage(headers, messageInputStream);
            log.info((Object)"SOAPMessage\ub85c\ubd80\ud130 EbxmlMessage\ub97c \uc0dd\uc131\ud569\ub2c8\ub2e4.");
            EbxmlMessageImpl ebxmlMessageImpl = responseEbxmlMessage = new EbxmlMessageImpl(soapMessage, ebxmlMessageFactory);
            return ebxmlMessageImpl;
        }
        catch (SOAPException e) {
            throw new EbmsTransportException(1, 0, e);
        }
        catch (IOException e) {
            throw new EbmsTransportException(1, 0, "HttpClient error -> sendMessage()", e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
    }

    public EbxmlMessage sendMessageForMultipart(EbxmlMessage ebxmlMessage, String url) throws EbmsTransportException {
        if (MessageUtil.isMimepartEbxmlMessage(ebxmlMessage)) {
            return this.sendMessage(ebxmlMessage, url);
        }
        log.info((Object)("\ubcf4\ub0b4\ub294 URL : " + url));
        PostMethod postMethod = null;
        URL urlParser = null;
        try {
            urlParser = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new EbmsTransportException(1, 0, "url\uc744 parsing \ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. url -> " + url, e);
        }
        String urlProtocol = urlParser.getProtocol();
        String urlHost = urlParser.getHost();
        int urlPort = urlParser.getPort();
        String urlPath = urlParser.getPath();
        try {
            HostConfiguration hostConfiguration = this.createHostConfiguration(urlProtocol, urlHost, urlPort);
            postMethod = new PostMethod(urlPath);
            if (ebxmlMessage.saveRequired()) {
                ebxmlMessage.saveChanges();
            }
            try {
                this.setMimeHeader(ebxmlMessage);
            }
            catch (EbmsEbxmlMessageException e) {
                throw new EbmsTransportException(1, 0, "Set MimeHeader error", e);
            }
            MimeHeaders mimeHeaders = ebxmlMessage.getMimeHeaders();
            Iterator headerIter = mimeHeaders.getAllHeaders();
            String transformedEbxmlMessageStr = MessageUtil.buildMimepartEbxmlMessage(ebxmlMessage);
            ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(transformedEbxmlMessageStr.getBytes());
            postMethod.setRequestEntity((RequestEntity)byteArrayRequestEntity);
            log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
            while (headerIter.hasNext()) {
                MimeHeader header = (MimeHeader)headerIter.next();
                String headerName = header.getName();
                String headerValue = header.getValue();
                if (headerName.equals("Content-Length")) {
                    headerValue = String.valueOf(transformedEbxmlMessageStr.getBytes().length);
                }
                if (headerName.equals("Content-Type")) {
                    headerValue = "multipart/related; type=\"text/xml\"; boundary=boundary; start=\"MessageContentId\"";
                }
                postMethod.setRequestHeader(headerName, headerValue);
                log.info((Object)(String.valueOf(headerName) + ": " + headerValue));
            }
            log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
            log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0 -------------------");
            ByteArrayRequestEntity sre = (ByteArrayRequestEntity)postMethod.getRequestEntity();
            log.info((Object)new String(sre.getContent()));
            log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0 -------------------");
            int responseCode = httpClient.executeMethod(hostConfiguration, (HttpMethod)postMethod);
            log.info((Object)"---------- \ubc1b\uc740 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
            MimeHeaders responseMimeheaders = this.getMimeHeaders(postMethod.getResponseHeaders());
            Iterator responseHeaderIter = responseMimeheaders.getAllHeaders();
            while (responseHeaderIter.hasNext()) {
                MimeHeader header = (MimeHeader)responseHeaderIter.next();
                String headerName = header.getName();
                String headerValue = header.getValue();
                log.info((Object)(String.valueOf(headerName) + ": " + headerValue));
            }
            log.info((Object)"---------- \ubc1b\uc740 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
            log.info((Object)postMethod.getResponseBodyAsString());
            if (responseCode >= 300 && responseCode <= 500) {
                throw new IOException("\uc11c\ubc84\uc758 \uc751\ub2f5\uc774 \uc774\uc0c1\ud569\ub2c8\ub2e4 -> " + responseCode + "\n \ub0b4\uc6a9 -> " + postMethod.getResponseBodyAsString());
            }
            if (postMethod.getResponseContentLength() <= 0L) {
                return null;
            }
            EbxmlMessageImpl responseEbxmlMessage = null;
            Header[] header = postMethod.getResponseHeaders();
            MimeHeaders headers = this.getMimeHeaders(header);
            EbxmlMessageFactoryImpl ebxmlMessageFactory = new EbxmlMessageFactoryImpl();
            InputStream messageInputStream = postMethod.getResponseBodyAsStream();
            log.info((Object)"SOAPMessage\ub97c \uc0dd\uc131\ud569\ub2c8\ub2e4. ");
            SOAPMessage soapMessage = ebxmlMessageFactory.createMessage(headers, messageInputStream);
            log.info((Object)"SOAPMessage\ub85c\ubd80\ud130 EbxmlMessage\ub97c \uc0dd\uc131\ud569\ub2c8\ub2e4.");
            EbxmlMessageImpl ebxmlMessageImpl = responseEbxmlMessage = new EbxmlMessageImpl(soapMessage, ebxmlMessageFactory);
            return ebxmlMessageImpl;
        }
        catch (SOAPException e) {
            throw new EbmsTransportException(1, 0, e);
        }
        catch (IOException e) {
            throw new EbmsTransportException(1, 0, "HttpClient error -> sendMessage()", e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
    }

    public void redirect(EbxmlMessage ebxmlMessage, HttpServletResponse response) throws EbmsTransportException {
        try {
            try {
                if (ebxmlMessage.saveRequired()) {
                    ebxmlMessage.saveChanges();
                }
                try {
                    this.setMimeHeader(ebxmlMessage);
                }
                catch (EbmsEbxmlMessageException e) {
                    throw new EbmsTransportException(1, 0, "MimeHeader\ub97c \uc124\uc815\ud560 \ud6c4 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
                }
                byte[] ebxmlMessageByteArray = ebxmlMessage.getMsgAsBytes();
                MimeHeaders mimeHeaders = ebxmlMessage.getMimeHeaders();
                Iterator headerIter = mimeHeaders.getAllHeaders();
                log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
                while (headerIter.hasNext()) {
                    MimeHeader header = (MimeHeader)headerIter.next();
                    String headerName = header.getName();
                    String headerValue = header.getValue();
                    if (headerName.equals("Content-Length")) {
                        int contentLength = ebxmlMessageByteArray.length;
                        headerValue = String.valueOf(contentLength);
                        response.setContentLength(contentLength);
                    } else if (headerName.equals("Content-Type")) {
                        String contentType;
                        headerValue = contentType = String.valueOf(response.getContentType()) + "; start=\"MessageContentId\"";
                        response.setContentType(contentType);
                    } else {
                        response.addHeader(headerName, headerValue);
                    }
                    log.info((Object)(String.valueOf(headerName) + ": " + headerValue));
                }
                log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
                ServletOutputStream sos = response.getOutputStream();
                sos.write(ebxmlMessage.toString().getBytes());
                log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0 -------------------");
                log.info((Object)new String(ebxmlMessageByteArray));
                log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0 -------------------");
                sos.flush();
                sos.close();
            }
            catch (SOAPException e) {
                throw new EbmsTransportException(1, 0, e);
            }
            catch (IOException e) {
                throw new EbmsTransportException(1, 0, "HttpClient error -> redirect()", e);
            }
        }
        finally {
            if (!response.isCommitted()) {
                try {
                    response.setStatus(200);
                    ServletOutputStream sos = response.getOutputStream();
                    sos.flush();
                    sos.close();
                }
                catch (IOException e) {
                    throw new EbmsTransportException(1, 0, "HttpServletResponse\ub97c flush\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
                }
                catch (Exception e) {
                    throw new EbmsTransportException(1, 0, "HttpServletResponse\ub97c flush\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
                }
            }
        }
    }

    public void redirectForMultipart(EbxmlMessage ebxmlMessage, HttpServletResponse response) throws EbmsTransportException {
        if (MessageUtil.isMimepartEbxmlMessage(ebxmlMessage)) {
            this.redirect(ebxmlMessage, response);
        }
        try {
            try {
                if (ebxmlMessage.saveRequired()) {
                    ebxmlMessage.saveChanges();
                }
                try {
                    this.setMimeHeader(ebxmlMessage);
                }
                catch (EbmsEbxmlMessageException e) {
                    throw new EbmsTransportException(1, 0, "MimeHeader\ub97c \uc124\uc815\ud560 \ud6c4 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
                }
                String ebxmlMessageStr = MessageUtil.buildMimepartEbxmlMessage(ebxmlMessage);
                MimeHeaders mimeHeaders = ebxmlMessage.getMimeHeaders();
                Iterator headerIter = mimeHeaders.getAllHeaders();
                log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
                while (headerIter.hasNext()) {
                    MimeHeader header = (MimeHeader)headerIter.next();
                    String headerName = header.getName();
                    String headerValue = header.getValue();
                    if (headerName.equals("Content-Length")) {
                        int contentLength = ebxmlMessageStr.getBytes().length;
                        headerValue = String.valueOf(contentLength);
                        response.setContentLength(contentLength);
                    } else if (headerName.equals("Content-Type")) {
                        String contentType;
                        headerValue = contentType = "multipart/related; type=\"text/xml\"; boundary=boundary; start=\"MessageContentId\"";
                        response.setContentType(contentType);
                    } else {
                        response.addHeader(headerName, headerValue);
                    }
                    log.info((Object)(String.valueOf(headerName) + ": " + headerValue));
                }
                log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0\uc758 \ud5e4\ub354 \uc815\ubcf4 ----------");
                ServletOutputStream sos = response.getOutputStream();
                sos.write(ebxmlMessageStr.getBytes());
                log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0 -------------------");
                log.info((Object)ebxmlMessageStr);
                log.info((Object)"---------- \ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0! -------------------");
                sos.flush();
                sos.close();
                response.flushBuffer();
            }
            catch (SOAPException e) {
                throw new EbmsTransportException(1, 0, e);
            }
            catch (IOException e) {
                throw new EbmsTransportException(1, 0, "HttpClient error -> redirect()", e);
            }
        }
        finally {
            if (!response.isCommitted()) {
                try {
                    response.setStatus(200);
                    ServletOutputStream sos = response.getOutputStream();
                    sos.flush();
                    sos.close();
                }
                catch (IOException e) {
                    throw new EbmsTransportException(1, 0, "HttpServletResponse\ub97c flush\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
                }
                catch (Exception e) {
                    throw new EbmsTransportException(1, 0, "HttpServletResponse\ub97c flush\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
                }
            }
        }
    }

    private void setMimeHeader(EbxmlMessage ebxmlMessage) throws EbmsEbxmlMessageException {
        log.info((Object)"MimeHeader\ub97c Setting \ud569\ub2c8\ub2e4.");
        log.info((Object)"SOAP MimeHeader\ub97c Setting\ud569\ub2c8\ub2e4.");
        ebxmlMessage.getSOAPPart().removeAllMimeHeaders();
        ebxmlMessage.getSOAPPart().addMimeHeader("Content-Type", "text/xml; charset=UTF-8");
        ebxmlMessage.getSOAPPart().setContentId("MessageContentId");
        try {
            ebxmlMessage.saveChanges();
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 0, "Ebxml message\uc758 saveChanges()\ub97c \uc218\ud589\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", e);
        }
    }

    private MimeHeaders getMimeHeaders(Header[] header) throws EbmsEbxmlMessageException {
        MimeHeaders mimeheaders = new MimeHeaders();
        int i = 0;
        while (i < header.length) {
            mimeheaders.addHeader(header[i].getName(), header[i].getValue());
            ++i;
        }
        return mimeheaders;
    }
}

