/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.queue;

import java.util.Hashtable;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.queue.EbmsQueueException;
import org.kldp.ebmsh.queue.QueueHelper;
import org.kldp.util.j2ee.resource.QueueConnectionFactoryServiceLocator;
import org.kldp.util.j2ee.resource.QueueServiceLocator;

public class ToApplicationQueueManager {
    private static final ToApplicationQueueManager instance = new ToApplicationQueueManager();
    private Hashtable toApplicationQueues = new Hashtable();

    private ToApplicationQueueManager() {
    }

    public static ToApplicationQueueManager getInstance() {
        return instance;
    }

    public QueueHelper getToApplicationQueueHelper(String queueDestName) throws EbmsQueueException {
        QueueHelper queue = null;
        if (!this.toApplicationQueues.containsKey(queueDestName)) {
            this.addNewToApplicationQueueManager(queueDestName);
        }
        queue = (QueueHelper)this.toApplicationQueues.get(queueDestName);
        return queue;
    }

    private void addNewToApplicationQueueManager(String queueDestName) throws EbmsQueueException {
        try {
            QueueConnectionFactoryServiceLocator queueConnectionFactoryResource = QueueConnectionFactoryServiceLocator.getInstance();
            QueueServiceLocator queueResource = QueueServiceLocator.getInstance();
            QueueConnectionFactory queueConnectionFactory = queueConnectionFactoryResource.getQueueConnectionFactory(EbmsConstants.queueConnectionFactoryName);
            Queue queue = queueResource.getQueue(queueDestName);
            QueueHelper queueHelper = new QueueHelper(queueConnectionFactory, queue);
            this.toApplicationQueues.put(queueDestName, queueHelper);
        }
        catch (NamingException e) {
            throw new EbmsQueueException(1, 0, e);
        }
    }
}

