/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;

public class Executable
implements Serializable {
    private transient Configuration config;
    private Mode stripperRules;
    private boolean stripsWhitespace;
    private RuleManager ruleManager;
    private KeyManager keyManager;
    private DecimalFormatManager decimalFormatManager;
    private SlotManager globalVariableMap;
    private IntHashMap compiledGlobalVariables = new IntHashMap(32);
    private String defaultCollationName;
    private Properties defaultOutputProperties;
    private IntHashMap namedTemplateTable = new IntHashMap(32);
    private int largestPatternStackFrame = 0;
    private CollationMap collationTable;
    private IntHashMap characterMapIndex;
    private LocationMap locationMap;
    private HashMap queryLibraryModules;
    private boolean stripsInputTypeAnnotations;
    private FunctionLibrary functionLibrary;
    private int hostLanguage = 50;
    private IntHashSet requiredParams = null;
    private IntHashMap outputDeclarations = null;
    private String reasonUnableToCompile = null;

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setHostLanguage(int n) {
        this.hostLanguage = n;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public IntHashMap getNamedTemplateTable() {
        if (this.namedTemplateTable == null) {
            this.namedTemplateTable = new IntHashMap(32);
        }
        return this.namedTemplateTable;
    }

    public Template getNamedTemplate(int n) {
        return (Template)this.namedTemplateTable.get(n);
    }

    public void putNamedTemplate(int n, Template template) {
        this.namedTemplateTable.put(n, template);
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public void setCharacterMapIndex(IntHashMap intHashMap) {
        this.characterMapIndex = intHashMap;
    }

    public IntHashMap getCharacterMapIndex() {
        if (this.characterMapIndex == null) {
            this.characterMapIndex = new IntHashMap(10);
        }
        return this.characterMapIndex;
    }

    public void setStripperRules(Mode mode) {
        this.stripperRules = mode;
    }

    public Mode getStripperRules() {
        return this.stripperRules;
    }

    public void setStripsWhitespace(boolean bl) {
        this.stripsWhitespace = bl;
    }

    public Stripper newStripper() {
        return new Stripper(this.stripperRules);
    }

    public boolean stripsWhitespace() {
        return this.stripsWhitespace;
    }

    public void setStripsInputTypeAnnotations(boolean bl) {
        this.stripsInputTypeAnnotations = bl;
    }

    public boolean stripsInputTypeAnnotations() {
        return this.stripsInputTypeAnnotations;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager(this.getConfiguration());
        }
        return this.keyManager;
    }

    public void setDefaultOutputProperties(Properties properties) {
        this.defaultOutputProperties = properties;
    }

    public Properties getDefaultOutputProperties() {
        if (this.defaultOutputProperties == null) {
            this.defaultOutputProperties = new Properties();
        }
        return this.defaultOutputProperties;
    }

    public void setOutputProperties(int n, Properties properties) {
        if (this.outputDeclarations == null) {
            this.outputDeclarations = new IntHashMap(5);
        }
        this.outputDeclarations.put(n, properties);
    }

    public Properties getOutputProperties(int n) {
        if (this.outputDeclarations == null) {
            return null;
        }
        Properties properties = (Properties)this.outputDeclarations.get(n);
        if (properties == null && n == -1) {
            properties = new Properties();
        }
        return properties;
    }

    public void setDecimalFormatManager(DecimalFormatManager decimalFormatManager) {
        this.decimalFormatManager = decimalFormatManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    public void setDefaultCollationName(String string) {
        this.defaultCollationName = string;
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName == null) {
            return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
        }
        return this.defaultCollationName;
    }

    public Comparator getDefaultCollation() {
        if (this.defaultCollationName == null) {
            return CodepointCollator.getInstance();
        }
        return this.getNamedCollation(this.defaultCollationName);
    }

    public void setCollationTable(CollationMap collationMap) {
        this.collationTable = collationMap;
    }

    public CollationMap getCollationTable() {
        return this.collationTable;
    }

    public Comparator getNamedCollation(String string) {
        if (this.collationTable == null) {
            this.collationTable = new CollationMap(this.config);
        }
        return this.collationTable.getNamedCollation(string);
    }

    public void addQueryLibraryModule(StaticQueryContext staticQueryContext) {
        String string;
        ArrayList<StaticQueryContext> arrayList;
        if (this.queryLibraryModules == null) {
            this.queryLibraryModules = new HashMap(5);
        }
        if ((arrayList = (ArrayList<StaticQueryContext>)this.queryLibraryModules.get(string = staticQueryContext.getModuleNamespace())) == null) {
            arrayList = new ArrayList<StaticQueryContext>(5);
            arrayList.add(staticQueryContext);
            this.queryLibraryModules.put(string, arrayList);
        } else {
            arrayList.add(staticQueryContext);
        }
    }

    public List getQueryLibraryModules(String string) {
        if (this.queryLibraryModules == null) {
            return null;
        }
        return (List)this.queryLibraryModules.get(string);
    }

    public void fixupQueryModules(StaticQueryContext staticQueryContext) throws XPathException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        staticQueryContext.bindUnboundVariables();
        if (this.queryLibraryModules != null) {
            object4 = this.queryLibraryModules.values().iterator();
            while (object4.hasNext()) {
                object3 = (List)object4.next();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (StaticQueryContext)object2.next();
                    ((StaticQueryContext)object).bindUnboundVariables();
                }
            }
        }
        object4 = staticQueryContext.fixupGlobalVariables(staticQueryContext.getGlobalStackFrameMap());
        staticQueryContext.bindUnboundFunctionCalls();
        if (this.queryLibraryModules != null) {
            object3 = this.queryLibraryModules.values().iterator();
            while (object3.hasNext()) {
                object2 = (List)object3.next();
                object = object2.iterator();
                while (object.hasNext()) {
                    StaticQueryContext staticQueryContext2 = (StaticQueryContext)object.next();
                    staticQueryContext2.bindUnboundFunctionCalls();
                }
            }
        }
        staticQueryContext.fixupGlobalFunctions();
        staticQueryContext.typeCheckGlobalVariables((List)object4);
    }

    public void setPatternSlotSpace(int n) {
        this.largestPatternStackFrame = n;
    }

    public SlotManager getGlobalVariableMap() {
        if (this.globalVariableMap == null) {
            this.globalVariableMap = this.config.makeSlotManager();
        }
        return this.globalVariableMap;
    }

    public IntHashMap getCompiledGlobalVariables() {
        return this.compiledGlobalVariables;
    }

    public void registerGlobalVariable(GlobalVariable globalVariable) {
        this.compiledGlobalVariables.put(globalVariable.getVariableFingerprint(), globalVariable);
    }

    public void initialiseBindery(Bindery bindery) {
        bindery.allocateGlobals(this.getGlobalVariableMap());
    }

    public int getLargestPatternStackFrame() {
        return this.largestPatternStackFrame;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void addRequiredParam(int n) {
        if (this.requiredParams == null) {
            this.requiredParams = new IntHashSet(5);
        }
        this.requiredParams.add(n);
    }

    public void checkAllRequiredParamsArePresent(GlobalParameterSet globalParameterSet) throws XPathException {
        if (this.requiredParams == null) {
            return;
        }
        IntIterator intIterator = this.requiredParams.iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (globalParameterSet != null && globalParameterSet.get(n) != null) continue;
            DynamicError dynamicError = new DynamicError("No value supplied for required parameter " + this.config.getNamePool().getDisplayName(n));
            dynamicError.setErrorCode("XTDE0050");
            throw dynamicError;
        }
    }

    public void setReasonUnableToCompile(String string) {
        this.reasonUnableToCompile = string;
    }

    public String getReasonUnableToCompile() {
        return this.reasonUnableToCompile;
    }
}

