/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.bi.queue;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.bi.queue.BiQueueException;
import org.kldp.ebmsh.bi.queue.MessageConverter;
import org.kldp.ebmsh.bi.queue.QueueMessage;
import org.kldp.util.log.LogUtil;

public class QueueHelper {
    protected static Log log = LogFactory.getLog(QueueHelper.class);
    protected Queue queue;
    protected QueueConnectionFactory queueConnectionFactory;

    public QueueHelper(QueueConnectionFactory queueConnectionFactory, Queue queue) {
        this.queue = queue;
        this.queueConnectionFactory = queueConnectionFactory;
    }

    public void sendMessage(QueueMessage queueMessage, MessageConverter messageConverter) throws BiQueueException {
        QueueConnection queueConnection = null;
        QueueSession session = null;
        QueueSender queueSender = null;
        try {
            try {
                queueConnection = this.queueConnectionFactory.createQueueConnection();
                session = queueConnection.createQueueSession(false, 1);
                queueSender = session.createSender(this.queue);
                Message message = messageConverter.convertToJMSMessage(session, queueMessage);
                queueSender.send(message);
            }
            catch (JMSException e) {
                throw new BiQueueException(0, 0, e);
            }
        }
        finally {
            if (queueSender != null) {
                try {
                    queueSender.close();
                }
                catch (JMSException e) {
                    log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
                }
            }
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
                }
            }
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException e) {
                    log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
                }
            }
        }
    }

    public void sendMessage(Message jmsMessage) throws BiQueueException {
        QueueConnection queueConnection = null;
        QueueSession session = null;
        QueueSender queueSender = null;
        try {
            try {
                queueConnection = this.queueConnectionFactory.createQueueConnection();
                session = queueConnection.createQueueSession(false, 1);
                queueSender = session.createSender(this.queue);
                queueSender.send(jmsMessage);
            }
            catch (JMSException e) {
                throw new BiQueueException(0, 0, e);
            }
        }
        finally {
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException e) {
                    log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
                }
            }
        }
    }
}

