/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "types.h"
#include "mpool.h"

#include "thread_mutex.h"
#include "thread_cond.h"

/**
   Thread Condition  Ѵ.

   @param c      condition 
   @param p      ޸ pool
 */
rc_status_t 
rc_thread_cond_create (rc_thread_cond_t **c, rc_pool_t *p)
{
  return apr_thread_cond_create (c, p);
}

/**
   Condtional Waiting

   @param c     Condition 
   @param m      mutex
 */
rc_status_t 
rc_thread_cond_wait (rc_thread_cond_t *c, rc_thread_mutex_t *m)
{
  return apr_thread_cond_wait (c, m);
}

/**
   Condition  signal  .

   @param c     Condition 
 */
rc_status_t 
rc_thread_cond_signal (rc_thread_cond_t *c)
{
  return apr_thread_cond_signal (c);
}

/**
   Condition  broadcast  Ѵ.

   @param c     Condition 
 */
rc_status_t
rc_thread_cond_broadcast (rc_thread_cond_t *c)
{
  return apr_thread_cond_broadcast (c);
}

/**
   Condition  ҸŲ.

   @param c     Ҹų condition 
 */
rc_status_t 
rc_thread_cond_destroy (rc_thread_cond_t *c)
{
  return apr_thread_cond_destroy (c);
}
