/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"

#include "utils.h"
#include "proc_rc.h"
#include "log.h"
#include "ticket.h"

/**
   Request R   S   L ŭ .

   @param r     Reqeust ü
   @param s      S
   @param l      
   @return       
 */
int
request_writen (r, s, l)
     request_rec *r;
     char *s;
     rc_size_t l;
{
  rc_status_t rv;
  int sent = l;

  rv = rc_socket_send (r->conn->sock, (const char *) s, &sent);

  return sent;
}

/**
   Request R   S   L ŭ ޴´.

   @param r     Reqeust ü
   @param s      S
   @param l      
   @return       
 */
int
request_readn (r, s, l)
     request_rec *r;
     char *s;
     rc_size_t l;
{
  rc_status_t rv;
  int recv = l;

  rv = rc_socket_recv (r->conn->sock, s, &recv);

  return recv;
}

/**
   Request Ͽ LEN ̸ŭ о BUF  .

   @param r     Request 
   @param buf    
   @param len    ũ
   @return       ũ
 */
int
request_read_buf (r, buf, len)
     request_rec *r;
     char *buf;
     rc_size_t len;
{
  if (!r || !buf || len < 0)
    return -1;

  return request_readn (r, buf, len);
}


/**
   Request Ͽ uint32_t ŸԸŭ о VAR   ȴ.   ̰
   Ư¡ Ʈũ ordering  ȣƮ ordering  ٲٰ ȴ.

   @param r     Request 
   @param var     
   @return       ũ
 */
int
request_read_uint32 (r, var)
     request_rec *r;
     uint32_t *var;
{
  uint32_t space;
  int recv;

  if (!r || !var)
    return -1;

  recv = request_readn (r, (char *) &space, sizeof (uint32_t));
  if (recv != sizeof (uint32_t))
    return recv;

  *var = ntohl (space);

  return recv;
}

/**
   Request ſ 1 Ʈ char ũ ŭ 濡 .

   @param r	Request ü
   @param c	 char Ʈ.  (TODO: char  type   н
		ũⰡ ٸ  ֱ  ߿ ̰Ϳ    ߻
		   ̴.
 */
void
request_write_char (r, c)
     request_rec *r;
     char c;
{
  int ret;

  if (!r)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "request_write_char: r is NULL.");
      return;
    }

  ret = request_writen (r, &c, sizeof (char));
  if (ret != sizeof (char))
    rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "request_write_char: error.");
}

/**
   Request ſ 2 Ʈ unsigned short ũ ŭ 濡 .

   @param r	Request ü
   @param s	 unsigned short Ʈ.
 */
void
request_write_ushort (r, s)
     request_rec *r;
     uint16_t s;
{
  int ret;

  if (!r)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "request_write_char: r is NULL.");
      return;
    }

  s = htons (s);

  ret = request_writen (r, (char *) &s, sizeof (uint16_t));
  if (ret != sizeof (uint16_t))
    rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "request_write_ushort: error.");
}

/**
   Request ſ ڿ S  濡 .

   @param r	Request ü
   @param s	 ڿ .  ݵ \0   Ѵ.
 */
void
request_write_string (r, s)
     request_rec *r;
     char *s;
{
  int ret, sl;

  if (!r || !s)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "request_write_char: error.");
      return;
    }

  sl = strlen (s);

  ret = request_writen (r, s, sl);
  if (ret != sl)
    rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "request_write_string: error.");
}

/**
   Request ſ  S  SL ũ ŭ 濡 .

   @param r	Request ü
   @param s	  .
   @param sl	  ũ.
 */
void
request_write_buf (r, s, sl)
     request_rec *r;
     char *s;
     int sl;
{
  int ret;

  if (!r || !s || sl < 0)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "request_write_char: error.");
      return;
    }

  ret = request_writen (r, s, sl);
  if (ret != sl)
    rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "request_write_buf: error.");
}

/**
   Request ü R  ϴ  ޼ ũ⸦ Ͽ 濡 Ѵ.
    ޼ ũ 2 Ʈ ũ̸, type  unsigned short ̴.

   @param r	Request Info Structure
 */
void
request_send_errorsize (r)
     request_rec *r;
{
  uint16_t errstrlen = 0;
  struct request_errors *e;

  if (!r)
    {
      rovm_log (NULL, ROVMLOG_ERR, ROVMLOG_MARK, "request_send_errorsize: r is NULL");
      return;
    }

  e = REQUEST_ERRORS (r);

  /* ` ޼ ũ'  Ʒ  ׷  ũ⸦ ǹѴ.
     
       - error level  : char 1 byte 
       - error strlen : unsigned short 2 bytes
       - error string : char * <n> bytes  

     ڿ `\0'  ũ⿡ ܵȴ.  */
  while (e)
    {
      if (!ERRORS_STRING (e))
	{
	  rovm_rlog (r, ROVMLOG_ERR, ROVMLOG_MARK, "request_send_errorsize: str is NULL");
	  break;
	}

      /* ⼭ 1  2   error level  strlen ũ⸦ 
	 ǹѴ.  */
      errstrlen += 1 + 2 + strlen (ERRORS_STRING (e));

      e = ERRORS_NEXT (e);
    }

  request_write_ushort (r, errstrlen);
}

/**
   Request ü R  ִ  ޼  濡 Ѵ.

   @param r	Request Info Structure
 */
void
request_send_eacherror (r)
     request_rec *r;
{
  struct request_errors *e;

  if (!r)
    {
      rovm_rlog (r, ROVMLOG_ERR, ROVMLOG_MARK, "request_send_errorsize: r is NULL");
      return;
    }

  e = REQUEST_ERRORS (r);

  while (e)
    {
      unsigned short sl;

      if (!ERRORS_STRING (e))
	{
	  rovm_rlog (r, ROVMLOG_ERR, ROVMLOG_MARK, "request_send_errorsize: str is NULL");
	  break;
	}

      sl = (unsigned short) strlen (ERRORS_STRING (e));

      request_write_char (r, ERRORS_LEVEL (e));
      request_write_ushort (r, sl);
      request_write_string (r, ERRORS_STRING (e));

      e = ERRORS_NEXT (e);
    }
}

/**
   Error ޼  ȣƮ .    R  ϵǾ 
   ִٰ  Ѵ.

   @param r	Request Info Structure
 */
void
request_send_error (r)
     request_rec *r;
{
  request_write_char (r, COMMAND_ERROR);
  request_send_errorsize (r);
  request_send_eacherror (r);
}

/**
   Connection R  struct connection_errors ü ҴϿ  ޼ Ѵ.
    Լ   .   connection_add_error () Լ Ͻñ
   ٶϴ.

   @param r		Connection  ü
   @param level		  ޼ 赵 
   @param errstr	vprintf  output  Ϸ ޼.
 */
static int
request_add_error_aline (r, level, errstr)
     request_rec *r;
     int level;
     char *errstr;
{
  struct request_errors *e;

  if (!r || level < 0 || !errstr)
    return -1;

  e = (struct request_errors *) mp_alloc (REQUEST_POOL (r), sizeof (struct request_errors));
  if (!e)
    return -1;

  ERRORS_LEVEL (e) = level;
  ERRORS_STRING (e) = mp_strdup (REQUEST_POOL (r), errstr);
  ERRORS_NEXT (e) = REQUEST_ERRORS (r);

  REQUEST_ERRORS (r) = e;

  return 0;
}

/**
   connection_add_error () Լ   Լ.

   @param r	Connection  ü
   @param level   ޼ 赵 
   @param file	޼ ߻  ̸
   @param line	޼ ߻   ȣ
   @param fmt	vprintf  
   @param args	vprintf argument format.
 */
static int 
request_add_error_core (r, level, file, line, fmt, args)
     request_rec *r;
     int level;
     const char *file;
     int line;
     const char *fmt;
     va_list args;
{
  char errstr[MAX_STRING_LEN];
  size_t len;
  int save_errno = errno;
  
  if (r == NULL)
    {
      rovm_rlog (r, ROVMLOG_ERR, ROVMLOG_MARK, "connection_add_error_core: r is NULL");
      return -1;
    }
  
  len = snprintf (errstr, sizeof (errstr), "[%s] ", get_current_timestr ());
  
  if (file && (level & ERRLOG_LEVELMASK) == ERRLOG_DEBUG) 
    len += snprintf (errstr + len, sizeof(errstr) - len, "%s(%d): ", file, line);
  
  if ((level & ERRLOG_WITHERRNO) && (save_errno != 0)) 
    len += snprintf (errstr + len, sizeof(errstr) - len, "(%d)%s: ", save_errno, strerror (save_errno));
  
  len += vsnprintf (errstr + len, sizeof (errstr) - len, fmt, args);
  
  /*    ޼  ߰Ѵ.  */
  if (request_add_error_aline (r, level, errstr))
    return -1;

  return 0;
}

/**
   Connection   ߻  ޼ 濡 ϱ  Ǵ Լ.
    Լ ̿Ͽ 濡  ޼   ִ.

   @param r	Connection  ü
   @param level   ޼ 赵 
   @param file	޼ ߻  ̸
   @param line	޼ ߻   ȣ
   @param fmt	vprintf  
 */
int 
request_add_error (request_rec *r,
		   int level,
		   const char *file, 
		   int line, 
		   const char *fmt, ...)
{
  va_list args;

  va_start (args, fmt);
  if (request_add_error_core (r, level, file, line, fmt, args))
    return -1;
  va_end (args);

  return 0;
}

/**
   ϳ Request  Ѵ.

   @param c     Connection ü.
 */
request_rec *
init_request (c)
     conn_rec *c;
{
  rc_pool_t *p;
  request_rec *r;

  mp_create (&p, c->pool);
  mp_tag (p, "subrequest");
  r = mp_calloc (p, sizeof (request_rec));
  REQUEST_POOL (r) = p;

  r->conn = c;
  
  return r;
}

/**
   Request    ȣ˴ϴ.
 */
void
finish_request (r)
     request_rec *r;
{
  /*    ϴ.  */
}

/**
   Opcode  ó    ӽ ȯ client  Ѵ.
 */
int
request_send_return (r, tk)
     request_rec *r;
     struct ticket *tk;
{
  char type;
  request_write_char (r, COMMAND_RETURN);

  type = STACK_TYPE (TICKET_RET (tk));

  switch (type)
    {
    case STACK_TYPE_VOID:
      request_write_char (r, type);
      break;
    default:
      rovm_rlog (r, ROVMLOG_ERR, ROVMLOG_MARK, "Can't process ROVM's return value = 0x%x", type);
      /* COMMAND_RETURN   ȵǱ , dummy  STACK_TYPE_VOID  
         Ͽ .  */
      request_write_char (r, STACK_TYPE_VOID);
      break;
    }

  return 0;
}

/**
    Connection    ó ̷ κԴϴ.  
      C  ؼ   ֽϴ.  ⼭ а Ǵ
   socket   ùκк а ˴ϴ.

   @param c     Connection  ϵ ü.
 */
int
rc_process_request (c)
     conn_rec *c;
{
  int ret;
  char rc;
  request_rec *r;

  r = init_request (c);
  if (!r)
    return -1;

  ret = request_readn (r, &rc, 1);
  if (ret != 1)
    {
      rovm_rlog (r, ROVMLOG_NOTICE, ROVMLOG_MARK, "Connection hang up.");
      return -1;
    }

  /*  Ʈũ    Լ     ϴ.  ׷  ,
     ҽ Ʈũ κ  ϰ   Ƽ Դϴ.  */
  switch (rc)
    {
    case COMMAND_REQ:
      {
	char *rbuf;

        rbuf = proc_rc_req (r);
        if (!rbuf)
	  {
	    request_send_error (r);
	    goto done;
	  }

	request_write_char (r, COMMAND_TICKET);
	request_write_buf (r, rbuf, TICKETID_SIZE);
	break;
      }
    case COMMAND_REQEND:
      {
        char rbuf[TICKETID_SIZE];

        /* TICKET ID б*/
        ret = request_read_buf (r, rbuf, TICKETID_SIZE);
        if (ret != TICKETID_SIZE)
          return -1;

        if (proc_rc_reqend (r, rbuf))
          {
            request_send_error (r);
	    goto done;
          }

        request_write_char (r, COMMAND_OK);
        break;
      }
    case COMMAND_OPCODE:
      {
        uint32_t oplen;
        char rbuf[TICKETID_SIZE];
        rc_opcode_t *opcode;
        struct ticket *tk;

        /* TICKET ID б*/
        ret = request_read_buf (r, rbuf, TICKETID_SIZE);
        if (ret != TICKETID_SIZE)
          return -1;

        /* OPCODE  б */
        ret = request_read_uint32 (r, &oplen);
        if (ret != sizeof (uint32_t))
          return -1;

        /* OPCODE б */
        opcode = (rc_opcode_t *) mp_alloc (REQUEST_POOL (r), oplen);
        ret = request_read_buf (r, (char *) opcode, oplen);
        if (ret != oplen)
          return -1;

        /* ó */
        tk = proc_rc_opcode (r, rbuf, opcode, (rc_size_t) oplen);
        if (!tk)
          {
            request_send_error (r);
	    goto done;
          }

        request_send_return (r, tk);
        break;
      }
    case COMMAND_GETSTACK:
      {
        char rbuf[TICKETID_SIZE];

        /* TICKET ID б*/
        ret = request_read_buf (r, rbuf, TICKETID_SIZE);
        if (ret != TICKETID_SIZE)
          return -1;

        proc_rc_getstack (r, rbuf);
        request_send_error (r);
        break;
      }
    default:
      /* proc_rc_unknown () Լ ܰ   .  */
      proc_rc_unknown (r, rc);
      request_send_error (r);
      break;
    }

  /* ⸦  ڽ μ ڵ ǰ Ǿ ִ.  */
 done:
  finish_request (r);

  return 0;
}
