#ifndef _ROVM_CLASS_H
#define _ROVM_CLASS_H

/**  Class  ã   ,   ȯϰ ˴ϴ.  */
#define NULL_CLASS              (RvClass *) 0
/**  ã ϴ Class   ROVM  ƴ ݿ ִ Class  ,
      ȯϰ ˴ϴ.  */
#define REMOTE_CLASS            (RvClass *) 1

#define NULL_METHOD             (RvMethod *) 0
#define NULL_OBJECT             (RvObject *) 0

typedef unsigned short u2;
typedef unsigned char u1;
typedef unsigned int u4;
typedef struct eclass RvClass;
typedef struct eclass_method RvMethod;
typedef struct eobject RvObject;

#define MTYPE_STR(NODE)                 ((NODE)->str)
#define MTYPE_ARGC(NODE)                ((NODE)->argc)
#define MTYPE_ARGV(NODE)                ((NODE)->argv)
#define MTYPE_RET(NODE)                 ((NODE)->ret)

/**
   Method  Type  мϿ ׿     ִ üԴϴ.
 */
struct eclass_method_type
{
  /** Method  Type Դϴ.  */
  u1 *str;

  /** Type  Argument    ֽϴ.  */
  u2 argc;
  /** Type   Argument  ġ  offset   ֽϴ.  */
  u2 *argv;
  /** Type  Return   ġ offset   ֽϴ.  */
  u2 ret;
};

#define METHOD_NAME(NODE)               ((NODE)->name)
#define METHOD_TYPE(NODE)               ((NODE)->type)
#define METHOD_OPLEN(NODE)              ((NODE)->oplen)
#define METHOD_OP(NODE)                 ((NODE)->op)
#define METHOD_NEXT(NODE)               ((NODE)->next)

/**
   ϳ Method  Ÿ üԴϴ.
 */
struct eclass_method
{
  u1 *name;
  struct eclass_method_type *type;

  u4 oplen;
  rc_opcode_t *op;

  struct eclass_method *next;
};

#define CLASS_ROVM(NODE)                ((NODE)->r)
#define CLASS_NAME(NODE)                ((NODE)->name)
#define CLASS_METHOD(NODE)              ((NODE)->m)

/**
   ENVLANG File Format  ǵǾ ִ Ŭ C  ǥ ü
   Դϴ.

   (20050206)   ſ ϸ, field, exception    
              ʽϴ.
 */
struct eclass
{
  /** ROVM ü    ؼ, ̿  ͸ Ѵ.  */
  struct rovm *r;

  /**  RvClass  ̸  ֽϴ.  */
  u1 *name;

  /**  RvClass  ǵǾ ִ method 鿡  linked list Դϴ.  */
  struct eclass_method *m;
};

#define OBJECT_TYPE(NODE)               ((NODE)->type)
/**  ObjectRef  local  ŵϴ.  */
#define LOCAL_OBJECT                    0
/**  ObjectRef  remote  ŵϴ.  */
#define REMOTE_OBJECT                   1
#define OBJECT_CTIME(NODE)              ((NODE)->ctime)
#define OBJECTL_CLASS(NODE)             ((NODE)->cls)

/**
   RvObject ü ؼ մϴ.
 */
struct eobject
{
  /**   RvObject  local Ŭ   ObjectRef  remote
      ObjectRef    Ÿ Դϴ.    0  ,
      local  ǹϸ, 1   remote  ǹմϴ.  */
  unsigned type : 1;
  unsigned unused : 31;

  /**  ObjectRef  * ð*    ֽϴ.   
      Garbage Collector  ϰ ϱ ؼ մϴ.  */
  rc_time_t ctime;

  RvClass *cls;
};

extern RvClass *rc_getclassbyhost (request_rec *, int, char *, unsigned short, char *);
extern RvObject *NewRemoteRvObject (request_rec *, int, char *, unsigned short, char *);
extern RvObject *NewRvObject (RvClass *);
extern int rc_callmethod (request_rec *, struct ticket *, char *, char *, u2, u2 *);

#endif

