#include "types.h"
#include "mpool.h"
#include "tktree.h"
#include "clstree.h"
#include "sha1.h"
#include "listen.h"
#include "rovm.h"

#include "thread.h"
#include "thread_mutex.h"
#include "thread_cond.h"

#include "mpm_worker_fdqueue.h"
#include "mpm_worker_pod.h"
#include "mpm_worker.h"

#include "connection.h"
#include "request.h"
#include "proc_rc.h"

#include "log.h"
#include "common.h"
#include "ticket.h"
#include "utils.h"

#include "file.h"
#include "gc.h"

/**
   Class Tree  key  value  (PATH, CLS)  node  մϴ.

   @param r     ROVM ü
   @param path  Class  
   @param cls   ε Class 
   @return       ϵǾ , RC_SUCCESS  ȯϰ Ǹ,
                ׷  , -1  ȯϰ ˴ϴ.
*/
rc_status_t
rc_register_class (r, path, cls)
     struct rovm *r;
     char *path;
     RvClass *cls;
{
  if (!clstree_lookup (ROVM_CLSTREE (r), path))
    {
      char *dupstr = rc_strdup (path);

      /* Insert ̹Ƿ ̿  serialize ( )  ʿϴ.

         ???  tktree  clstree   mutex  Ͽ locking 
             ϰ ִµ, ̵   ٸ mutex  ϵ ִ
             ͵    .    ġ Ҵ 
             ʴ´.  */
      rc_thread_mutex_lock (ROVM_MUTEX (r));

      if (clstree_insert (ROVM_CLSTREE (r), dupstr, (void *) cls))
        {
          rc_thread_mutex_unlock (ROVM_MUTEX (r));
          return -1;
        }

      rc_thread_mutex_unlock (ROVM_MUTEX (r));
    }

  return RC_SUCCESS;
}

/**
   PATH  ϴ class   εϿ Class Tree  մϴ.

   @param r     ROVM ü
   @param path  ã Class 
   @return       εϿ , ش Class ͸ ׷  ,
                NULL_CLASS  ȯմϴ.
*/
RvClass *
rc_load_class (r, path)
     struct rovm *r;
     char *path;
{
  rc_status_t rv;
  RvClass *cls;

  if (!r || !path)
    return NULL_CLASS;

  cls = rc_load_classfile (r, path);
  if (!cls)
    return NULL_CLASS;

  rv = rc_register_class (r, path, cls);
  if (rv != RC_SUCCESS)
    return NULL_CLASS;

  return cls;
}

/**
   ü R  ϴ Class Tree  PATH  شϴ Class  ã, ׿
   ´ RvClass ü ȯմϴ.

    Class Tree  ش Class  ã Ͽٸ, ش path   
   loading  ϰ ˴ϴ.

   @param r     ROVM ü
   @param path  ã Class 
   @return      ش Class  ã εǾٸ ش Ŭ ͸ ȯմϴ.
                ׷  , NULL_CLASS  ȯմϴ.
 */
RvClass *
rc_lookup_class (r, path)
     struct rovm *r;
     char *path;
{
  RvClass *cls;

  if (!r || !path)
    return NULL_CLASS;

  cls = (RvClass *) clstree_lookup (ROVM_CLSTREE (r), path);
  if (cls)
    return cls;

  return rc_load_class (r, path);
}

/**
   IPTYPE  HOSTNAME, PORT, PATH  ̿Ͽ ׿  class  
   ´.   HOSTNAME   ӽ IP (Ȥ hostname)  ,
    ش class  εϿ ׿   ȯѴ.

   @param r             request_rec ü
   @param iptype        IPv4  IPv6  Ų.  IPv6   
                         ʴ´.
   @param hostname      Host ̸
   @param port          Host Ʈ ȣ
   @param path          ãϴ class .
   @return               class    , NULL_CLASS 
                        ȯϰ,  ٸ host  û  , 
                        REMOTE_CLASS  ȯѴ.  ׷   load 
                        class  Ͱ ȯѴ.
*/
RvClass *
rc_getclassbyhost (r, iptype, hostname, port, path)
     request_rec *r;
     int iptype;
     char *hostname, *path;
     unsigned short port;
{
  rc_status_t rv;
  rc_sockaddr_t *sa;

  rv = rv_sockaddr_info_get (&sa, hostname, RC_INET, 
                             port ? port : DEFAULT_ROVM_LISTENING_PORT,
                             0, REQUEST_POOL (r));
  if (rv != RC_SUCCESS)
    return NULL_CLASS;

  if (!rc_sockaddr_equal (CONN_LOCAL_ADDR (REQUEST_CONN (r)), sa))
    return REMOTE_CLASS;

  return rc_lookup_class (REQUEST_ROVM (r), path);
}

/**
   Class CLS  ޽ ̸ Ÿ NAME ̰, TYPE  ޽带 ã
   ׿  ͸ ȯѴ.
 */
RvMethod *
rc_findmethod (cls, name, type)
     RvClass *cls;
     char *name, *type;
{
  RvMethod *m;

  if (!cls || !name || !type)
    return NULL_METHOD;

  m = CLASS_METHOD (cls);

  while (m)
    {
      if (!strcmp (name, METHOD_NAME (m))
          && !strcmp (type, MTYPE_STR (METHOD_TYPE (m))))
        return m;

      m = METHOD_NEXT (m);
    }

  return NULL_METHOD;
}

/**
   Ŭ Method  ȣѴ.

   @return        ߻Ͽ , -1  ׷ ʴٸ 0  ȯѴ.
 */
int
rc_callmethod (r, tk, name, type, argc, argv)
     request_rec *r;
     struct ticket *tk;
     char *name, *type;
     u2 argc, *argv;
{
  RvObject *obj;

  obj = (RvObject *) STACK_V_ADDR (&(TICKET_SP (tk)[-(argc - 1)]));

  if (OBJECT_TYPE (obj) == LOCAL_OBJECT)
    {
      RvClass *cls = OBJECTL_CLASS (obj);
      RvMethod *m;

      m = rc_findmethod (cls, name, type);
      if (!m)
        {
          request_add_error (r, ERRLOG_ERR, ERRLOG_MARK,
                             "Can't find such method.");
          return -1;
        }

      /* ޽带 ȣϱ , ʿ ticket    ֵ Ѵ.  */
      if (ticket_beforecall (tk, m, argc, argv))
        return -1;

      /*  ȣϰ ϴ method  native  , ش Լ ȣ 
         ֵ   Ѵ.  */
      if (METHOD_FLAG (m) & ACCESS_NATIVE)
        {
          if (STACK_TYPE (TICKET_LOCAL (tk)) != STACK_TYPE_OBJREF)
            {
              request_add_error (r, ERRLOG_ERR, ERRLOG_MARK,
                                 "The first argument of native method should be a ObjectRef.");
              return -1;
            }

          if (m->native ((RvObject *) STACK_V_ADDR (TICKET_LOCAL (tk)), TICKET_LOCAL (tk) + 1, TICKET_RET (tk)))
            return -1;
        }
      else
        {
          /* Ϲ method ȣ .  */
          if (rovmcore_main (r, tk, METHOD_OP (m), METHOD_OPLEN (m)))
            return -1;
        }
    }
  else if (OBJECT_TYPE (obj) == REMOTE_OBJECT)
    {
      request_add_error (r, ERRLOG_ERR, ERRLOG_MARK,
                         "Calling remote method is under construction.");
      return -1;
    }
  else
    {
      request_add_error (r, ERRLOG_ERR, ERRLOG_MARK,
                         "Invalid Object Type.");
      return -1;
    }

  return 0;
}

/**
   RvObject ü Ӱ Ҵϸ, Local  Remote  κи
   մϴ.

   @return  ͸  · RvObject ü ͸ ȯմϴ.
 */
RvObject *
init_eobject (r)
     struct rovm *r;
{
  RvObject *o;

  o = (RvObject *) gc_alloc (r, sizeof (RvObject));
  if (!o)
    return NULL_OBJECT;

  memset (o, '\0', sizeof (RvObject));

  OBJECT_CTIME (o) = rc_time_now ();

  return o;
}

/**
   Ŭ C   ObjectRef  Ͽ ȯմϴ.

   @param c     ObjectRef   Ŭ 
   @return       ObjectRef
 */
RvObject *
NewRvObject (c)
     RvClass *c;
{
  RvObject *o;

  o = init_eobject (CLASS_ROVM (c));
  if (!o)
    return NULL_OBJECT;

  OBJECT_TYPE (o) = LOCAL_OBJECT;
  OBJECTL_CLASS (o) = c;

  /* Field   ObjectRef   ȮѴ.  */
  if (CLASS_FIELD_COUNT (c) > 0)
    OBJECTL_FIELD (o) = (RvValue *) gc_calloc (CLASS_ROVM (c), 
                                               CLASS_FIELD_COUNT (c) * sizeof (RvValue));

  return o;
}

/**
   ݿ ϴ Ŭ ؼ ObjectRef  Ͽ ȯմϴ.

   @param r             Request ü
   @param iptype        IPv4  IPv6  մϴ.
   @param hostname       Host Name
   @param port           Host  Ʈ ȣ
   @param path          Ŭ 
   @return              ݿ  ObjectRef    
                         ObjectRef
 */
RvObject *
NewRemoteRvObject (r, iptype, hostname, port, path)
     request_rec *r;
     int iptype;
     char *hostname, *path;
     unsigned short port;
{
  return NULL_OBJECT;
}

extern int rovm_stack_size[MAX_STACK_TYPE];

/**
   ArrayRef  Ӱ Ͽ ׿  ͸ ȯѴ.  GC ޸𸮸
   ϴ  Ư¡̴.

   @param type  ArrayRef  Ÿ (? Ǽ? ?)
   @param nlem  Ҵ ҵ ũ.
 */
RvValue *
NewRvArray (r, type, nelm)
     struct rovm *r;
     char type;
     int nelm;
{
  RvValue *v;

  if (type >= MAX_STACK_TYPE)
    return NULL_VALUE;

  v = (RvValue *) gc_alloc (r, sizeof (RvValue));
  if (!v)
    return NULL_VALUE;

  STACK_TYPE (v) = STACK_TYPE_ARRAYREF;
  STACK_IS_ARRAY (v) = 1;
  STACK_SUBTYPE (v) = (int) type;
  STACK_ARRAYLEN (v) = nelm;
  STACK_V_ADDR (v) = (void *) gc_calloc (r, rovm_stack_size[(int) type] * nelm);
  if (!STACK_V_ADDR (v))
    return NULL_VALUE;

  return v;
}

/**
   ̰ LEN  ڿ STR  ObjectRef  ȯϿ ȯѴ.  STR  NULL
     ʽϴ.

   @param r     Request ü
   @param tk    Ticket ü
   @param str   ڿ 
   @param len   ڿ 
 */
RvObject *
NewRvStringObject (r, str, len)
     struct rovm *r;
     const char *str;
     size_t len;
{
  RvObject *obj;
  RvClass *cls;
  RvField *fld;
  RvValue *v;

  /* String Ŭ ãϴ.  */
  cls = rc_lookup_class (r, "/core/str");
  if (!cls)
    return NULL_OBJECT;

  /* String ObjectRef  Ҵմϴ.  */
  obj = NewRvObject (cls);
  if (!obj)
    return NULL_OBJECT;

  OBJECT_IS_STRING (obj) = TRUE;

  fld = rc_find_efield (cls, "value", "[");
  if (!fld)
    return NULL_OBJECT;

  v = NewRvArray (r, STACK_TYPE_CHAR, len);
  if (!v)
    return NULL_OBJECT;
  memcpy (STACK_V_ADDR (v), str, len);

  /*
    Ʒ   ؾ   ObjectRef  ̹ ش Field   
    ȮǾ ִٴ ̴.  str Ŭ value [  ϱ  NewRvArray () Լ
    ȣϰ Ǹ    Ҵǰ Ǵµ,    ־ Ѵ.

     NewRvArray () ȣ ,    GC ޸𸮸 Ҵϰ Ǵµ, 
     Ʒ   STACK_V_ADDR (v)   ӹ ǰ, v  Ҵ
     ޸𸮴 GC Ǿ .  ( ϸ  .)  */
  *OBJECTL_FIELD_IDX (obj, FIELD_INDEX (fld)) = *v;

  fld = rc_find_efield (cls, "len", "I");
  if (!fld)
    return NULL_OBJECT;

  v = OBJECTL_FIELD_IDX (obj, FIELD_INDEX (fld));
  STACK_TYPE (v) = STACK_TYPE_INT;
  STACK_V_INT (v) = len;

  return obj;
}
