/*
    ROVM  Ȯ  ۼ  ֵ ִ  
  Դϴ.
 */

#ifndef _ROVM_ENVLANG_H
#define _ROVM_ENVLANG_H

/*
  ٸ   typedef  浹 ϱ ؼ Ʒ 
  #ifndef  ϰ Ǿϴ.
*/
#ifndef ROVM_ECLASS_TYPEDEF
typedef struct eclass RvClass;
#endif
#ifndef ROVM_EOBJECT_TYPEDEF
typedef struct eobject RvObject;
#endif
#ifndef ROVM_EVALUE_TYPEDEF
typedef struct rovm_stack RvValue;
#endif

typedef struct emethoddef RvMethodDef;
typedef struct efielddef RvFieldDef;

/**
   Field   üԴϴ.
 */
struct efielddef
{
  const char *name;
  const char *type;
};

/**
   Method    üԴϴ.
 */
struct emethoddef
{
  const char *name;
  const char *type;

  int (*func) (RvObject *cls, RvValue *arg, RvValue *ret);
};

/**
   ObjectRef  ڰ Ÿ   ˴ϴ.

   @param self   ObjectRef
   @param idx     index ȣ (ݵ OBJECT_MAX_USERDATA 
                 ۾ƾ մϴ.
   @param value  .
*/
extern int RvSetUserData (RvObject *, int, void *);

/**
   ObjectRef  ڰ  Ÿ  , Ѵ.

   (ܺ  Լ)

   @param self   ObjectRef
   @param idx    Ÿ index ȣ
   @return      ڰ   ȯմϴ.
*/
extern void *RvGetUserData (RvObject *, int);

/**
   FDS  ǵǾ ִ field  Ŭ CLS   field  Ѵ.

   @param cls    Class   Ŭ  
   @param fds   Field  Ǿ ִ ü .
   @return         ߻ , -1 , ׷   0  ȯϰ
                ȴ.
*/
extern int RvDefineFields (RvClass *cls, RvFieldDef *fds);

/**
   CLS  MD  о ش Method  ǵ CLS ο Ѵ.

   @param cls    Class   Ŭ  
   @param md    Method  Ǿ ִ .
   @return         ߻ , -1 , ׷   0  ȯϰ
                ȴ.
*/
extern int RvDefineMethods (RvClass *, RvMethodDef *);

/**
   ARGS  FMT  Ͽ ش  ùٸ   ִ Ȱ ϴ
   ԼԴϴ.

   @param args  RvValue üԴϴ.  ̰ Stack Slot   ͸
                 ˴ϴ.
   @param fmt   ؼ Դϴ.
   @return        0 , ׷   -1  ȯѴ.
*/
extern int RvParseArg (RvObject *, RvValue *, const char *, ...);

/**
   ڿ ArrayRef  ȯϿ ȯմϴ.  (NewRvArray  Ҵ
   GC ޸𸮴 ڵ delayed slot  ϵǾ ֽϴ.)

   @param self  SELF ObjectRef
   @param str   ڿ  ('\0'     ֽϴ.)
   @param len   ڿ 
   @return      Ӱ  ArrayRef 
*/
extern RvValue *RvStr2ArrayRef (RvObject *, char *, int);

/**
   Field  ϴ ԼԴϴ.

   @param self  SELF ObjectRef
   @param name  Field ̸
   @param type  Field Ÿ
*/
extern int RvSetField (RvObject *self, const char *name, const char *type, ...);

/**
   Field   ԼԴϴ.  Type   ...  Ǵ 
   Ư¡Դϴ.

   @param self  SELF ObjectRef
   @param name  Field ̸
   @param type  Field Ÿ
 */
extern int RvGetField (RvObject *self, const char *name, const char *type, ...);

/**
   RvGetField () Լ  ԼԴϴٸ,  ϴ  RvValue 
   ü ȯϴ  Ư¡Դϴ.

   @param self  SELF ObjectRef
   @param name  Field ̸
   @param type  Field Ÿ
 */
extern RvValue *RvGetFieldValue (RvObject *self, const char *name, const char *type);

/**
   ο 迭 (ArrayRef)  մϴ.

   @param self  SELF ObjectRef
   @return       ArrayRef ͸ ȯմϴ.    
                 ߻Ͽ  NULL_OBJECT  ȯϰ ˴ϴ.
 */
extern RvObject *RvArrayNew (RvObject *self);

/**
   迭 ARRAY  Ÿ TYPE  ׸ Ӱ ߰  ˴ϴ.

   @param array ArraryRef 
   @param type  Ӱ ߰Ǵ ׸ Ÿ ڿ
   @return       0, н -1  ȯմϴ.
 */
extern int RvArrayPush (RvObject *array, const char *type, ...);

/**
   迭 ARRAY    ִ entry  մϴ.

   @param array ArrayRef 
   @return       0, н -1  ȯմϴ.
 */
extern int RvArrayPop (RvObject *array);

extern char * RvArray2Str (RvObject *self, RvObject *array);

/**
   迭 ARRAY   ̸ Ͽ ȯմϴ.

   @param array ArrayRef 
   @return       迭 ũ
 */
extern int RvArrayLength (RvObject *array);

/**
   迭 ARRAY   ()  ִ  Ͽ ׿  RvValue ü
   ȯմϴ.

   @param array ArrayRef 
   @return        ü RvValue ü
 */
extern RvValue *RvArrayLastValue (RvObject *array);

/**
   ڿ STR ̰ ̰ LEN  StringRef  ȯѴ.
 */
extern RvObject *RvStrNew (RvObject *self, char *str, size_t len);

/**
   ڿ STR   OFFSET  ϰ  LEN ŭ ߶ װ
   StringRef  ȯϿ ȯմϴ.

   @param self   SELF ObjectRef
   @param str     Ǵ ڿ
   @param offset ڿ 
   @param len    ڸ 
   @return       Ӱ  StringRef, н NULL_OBJECT
 */
extern RvObject *RvStrSubstr (RvObject *self, char *str, int offset, size_t len);

/**
   StringRef  ڿ ̸  PTR  LEN   ȯմϴ.

   @param str   StringRef 
   @param ptr   ڿ  ڿ 
   @param len   ڿ ̸  int 
   @return       0, н -1  ȯմϴ.
 */
extern int RvStrGetInfo (RvObject *str, char **ptr, int *len);

/**
   ޽ ȯ   Ǵ ԼԴϴ.  TYPE   ...  ˸
   type  ; մϴ.

   @param self  SELF ObjectRef
   @param ret   ޽ °  ret  ͰԴϴ.
   @param type  ȯ Ÿ
   @return       0, н -1  ȯմϴ.
*/
extern int RvSetReturn (RvObject *self, RvValue *ret, const char *type, ...);

/**
    VALUE  StringRef  ȯմϴ.

   @param value   ü
   @return       true   1 , ׷ ʴٸ 0  ȯմϴ.
 */
extern int RvValueIsStringRef (RvValue *value);

/**
    VALUE  StringRef  Ͽ ȯմϴ.

   @return       VALUE  StringRef  , ׿ شϴ ͸ ȯϰ
                ׷ ʴٸ NULL_OBJECT  ȯմϴ.
 */
extern RvObject *RvValueStringRef (RvValue *value);

/**
   RvValue ü ִ  ڿ ȯϿ ȯմϴ.

   @param self  SELF ObjectRef
   @param val   ڿ ȯ val
 */
extern char *RvValue2Str (RvObject *self, RvValue *val);
//extern int RvValue2Int (RvObject *self, RvValue *val);

#endif
