/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_CORE_H
#define _ROVM_CORE_H

/**
   @file core.h
   @breif ROVM   virtual machine  õ ƾ .
*/

typedef struct rovm_stack RvValue;
typedef struct rovm_stack rovm_stack_t;

#define ROVM_EVALUE_TYPEDEF     /**< el.h  浹  .  */

/** Value    ̸ ȯϰ ȴ.  */
#define NULL_VALUE              (RvValue *) 0

/**
   @defgroup ROVM  ӽ
   @{
*/

enum rovm_stack_type
  {
#define DEF_TYPE(ENUM, NAME, TYPE, SIZE)   ENUM ,
#include "type.def"
#undef DEF_TYPE
    /**  ROVM Server 󿡼 Stack Type    ǹѴ.   
    type.def Ͽ ǵǾ ִ DEF_TYPE  ̴.  */
    MAX_STACK_TYPE
  };

#define STACK_TYPE(NODE)                ((NODE)->type)
#define SET_STACK_TYPE(NODE, TYPE)      (NODE)->type = TYPE
#define STACK_IS_STRINGVALUE(NODE)      ((NODE)->is_stringvalue)
#define STACK_IS_ARRAYVALUE(NODE)       ((NODE)->is_arrayvalue)
#define SET_STACK_V_BOOLEAN(NODE)       ((NODE)->v._uchar)
#define SET_STACK_V_CHAR(NODE)          ((NODE)->v._char)
#define SET_STACK_V_SHORT(NODE)         ((NODE)->v._short)
#define SET_STACK_V_INT(NODE)           ((NODE)->v._int)
#define SET_STACK_V_FLOAT(NODE)         ((NODE)->v._float)
#define SET_STACK_V_DOUBLE(NODE)        ((NODE)->v._double)
#define SET_STACK_V_ADDR(NODE)          ((NODE)->v._addr)
#define SET_STACK_V_OBJREF(NODE)        (SET_STACK_V_ADDR (NODE))
#define SET_STACK_V_STRINGREF(NODE)     (SET_STACK_V_ADDR (NODE))
#define SET_STACK_V_ARRAYREF(NODE)      (SET_STACK_V_ADDR (NODE))
#define SET_STACK_VALUE(NODE, TYPE, VAL)        \
  SET_STACK_V_##TYPE (NODE) = VAL;              \
  SET_STACK_TYPE (NODE, STACK_TYPE_##TYPE);

#define GET_STACK_V_BOOLEAN(NODE)       ((NODE)->v._uchar)
#define GET_STACK_V_CHAR(NODE)          ((NODE)->v._char)
#define GET_STACK_V_SHORT(NODE)         ((NODE)->v._short)
#define GET_STACK_V_INT(NODE)           ((NODE)->v._int)
#define GET_STACK_V_FLOAT(NODE)         ((NODE)->v._float)
#define GET_STACK_V_DOUBLE(NODE)        ((NODE)->v._double)
#define GET_STACK_V_ADDR(NODE)          ((NODE)->v._addr)
#define GET_STACK_V_OBJREF(NODE)        ((RvObject *) GET_STACK_V_ADDR (NODE))
#define GET_STACK_V_STRINGREF(NODE)     ((RvObject *) GET_STACK_V_ADDR (NODE))
#define GET_STACK_V_ARRAYREF(NODE)      ((RvObject *) GET_STACK_V_ADDR (NODE))

#define GET_STACK_VALUE(TYPE, NODE)             GET_STACK_V_##TYPE (NODE)


/**
    ӽ ϴ  ǥϴ üν  ϳ ϳ  slot 
   Ÿ.

   @note  2005 1 29 δ ROVM  õ  ޸  κе
         struct ticket ü  ִ  谡 Ǿ ִ.   ROVM
          ϴ  ޸ ü ticket ü    ̸
         ؼ  ǵ 谡 Ǿ ִٴ ̴.

         ̷ ϴ  VM  ϴٺ     ִ ޸
          κ   ϱ ؼ̴.
 */
struct rovm_stack
{
  /**
      type  Ÿ ؼ Ǵ ̴.    type δ
     Ʒ   ǵǾ ִ.

       - STACK_TYPE_NUMBER
       - STACK_TYPE_OBJREF

     ̰ ǵ   ߻  ִ objref + number  
      Ͽ  exception  ߻Ű ؼ̴.
   */
  unsigned type : 8;

  /* Ʒ  flag  TYPE  STACK_TYPE_ARRAYREF     Ư
     Ǵ  Ʒ  _addr  Ưϰ ٷ ʿ䰡  ŵϴ.  */
  unsigned is_stringvalue : 1;
  unsigned is_arrayvalue : 1;

  /**   ,  bit.  */
  unsigned unused : 24;

  /**
        Ǵ union ü.

     @note (20060129)  Ȯ   ʱ ,  ټ 
            ִ.   Ʒ  type  , ӽŸ Ϸ 
           ũⰡ ٸ  ̿  ϵ    ʾ, ٸ
           ӽ Ȥ Ϸ   α׷ ȵư  ٺϴ.
   */
  union
  {
    unsigned char _uchar;       /**< 1 Ʈ boolean  .  */
    char _char;                 /**< 1 Ʈ char  .  */
    short _short;               /**< 2 Ʈ short  .  */
    int _int;                   /**< 4 Ʈ integer  .  */
    float _float;               /**< 4 Ʈ float  .  */
    double _double;             /**< 8 Ʈ double  .  */
    void *_addr;                /**< ּ   .  */
  } v;
};

struct ticket;
extern int rovmcore_main (request_rec *, struct ticket *, rc_opcode_t *, rc_size_t);

/**
   @}
*/

#endif
