/* clstree.h - Class Tree    tree  header
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_CLSTREE_H
#define _ROVM_CLSTREE_H

#include "ext/tktree-splaytree.h"

typedef struct splay_tree_s clstree_t;
typedef splay_tree_key clstree_key;
typedef splay_tree_value clstree_value;
typedef splay_tree_compare_fn clstree_compare_fn;
typedef splay_tree_delete_key_fn clstree_delete_key_fn;
typedef splay_tree_delete_value_fn clstree_delete_value_fn;

struct rovm;
extern int init_rovm_clstree (struct rovm *);
extern void *clstree_lookup (clstree_t *, char *);
extern int clstree_insert (clstree_t *, char *, void *);
extern void clstree_remove (clstree_t *, char *);

#endif
