/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVM_UTILS_H
#define _ROVM_UTILS_H

extern char *get_current_timestr (void);
extern rc_time_t rc_time_now (void);
extern void rc_sleep (rc_interval_time_t);

extern void *rc_malloc (size_t);
extern void *rc_calloc (size_t, size_t);
extern void *rc_realloc (void *, size_t);
extern void rc_free (void *);

extern char *rc_strndup (char *, int);
extern char *rc_strdup (char *);
extern int rv_strcmp_match (const char *str, const char *expected);
extern char *rv_make_dirstr_parent (apr_pool_t *p, const char *s);
extern void rc_str_tolower (char *str);

#endif
