<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: config.php,v 1.9.2.1 2004/01/23 20:05:34 lseeker Exp $
 */

header('Content-Type: text/html; charset=UTF-8');
require 'lib/admin.inc'; // 관리자 환경설정

if(!$admin['login']) {
    die('ERROR: 관리자 쿠키를 찾을 수 없습니다.');
}

$db['version'] = &DB::result(DB::query('SELECT version()', $dbconn), 0, 0);
DB::close($dbconn);

if($admin_data['html_tag'] == 't') {
    $html_tag['on']  = 'checked="checked"';
    $html_tag['off'] = '';
} else {
    $html_tag['on']  = '';
    $html_tag['off'] = 'checked="checked"';
}

if($admin_data['autolink'] == 't') {
    $autolink['on']  = 'checked="checked"';
    $autolink['off'] = '';
} else {
    $autolink['on'] = '';
    $autolink['off'] = 'checked="checked"';
}

if($admin_data['backdrum'] == 't') {
    $backdrum['on']  = 'checked="checked"';
    $backdrum['off'] = '';
} else {
    $backdrum['on']  = '';
    $backdrum['off'] = 'checked="checked"';
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
 <title>EtchiBBS 환경 설정</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="internal.css" rel="stylesheet" type="text/css">
 <script type="text/javascript">
<!--
function checkform(form) {
    if (form.admin_pass.value != form.admin_pass_confirm.value) {
        alert("입력된 관리자 비밀번호 두 개가 일치하지 않습니다.");
        form.admin_pass_confirm.focus();
        return false;
    }
    
    if (form.fileup_max.value == '') {
        alert("최대 업로드 크기를 적어주세요.");
        form.fileup_max.focus();
        return false;
    }

    return true;
}
function show_sysinfo() {
<?php
echo "alert('Server: {$_SERVER['SERVER_SOFTWARE']}\\n" .
    "Hostname: {$_SERVER['HTTP_HOST']}\\n" .
    "PHP Version: " . phpversion() . '\n' .
    "DB Interface: {$db['dbms']}\\n" .
    "DB Version: {$db['version']}');\n";
?>
}
//-->
 </script>
</head>

<body>
<form method="post" action="config_ok.php" onsubmit="return checkform(this);">
 <div id="config">
  <input type="hidden" name="from" value="<?php if (isset($_GET['from'])) echo htmlspecialchars($_GET['from']); ?>">
  <div id="confhead">
   <h1>EtchiBBS 환경 설정</h1>
   <div id="confclose">
    [ <a href="uninstall.php"><span class="red">설치 제거</span></a> ]
    [ <a href="javascript: window.close();">창 닫기</a> ]
   </div>
  </div>
  <table width="100%" cellspacing="1" cellpadding="2">
   <tr>
    <th>관리자 비밀번호</th>
    <td>
     - 관리자 비밀번호는 게시물 수정/변경/삭제, 관리자 모드, 아이콘 업로드에 사용됩니다.<br />
     - 분실되거나 노출되지 않도록 주의해주세요.<br />
     <span class="black">마스터 비밀번호)
      <input type="password" maxlength="30" size="10" name="admin_pass" />
      확인 입력) <input type="password" maxlength="30" size="10" name="admin_pass_confirm" />
     </span>
     <span class="red">(변경시에만 입력)</span>
    </td>
   </tr>
   <tr>
    <th>페이지 상단 글씨<br /><span class="nobold">(HTML 태그로 입력)</span></th>
    <td>
     - 아무것도 넣지 않을 경우 페이지 상단에는 글씨가 뜨지 않습니다.<br />
     <textarea name="title_text" rows="7" cols="63"><?php echo $admin_data['title_text']; ?></textarea>
    </td>
   </tr>
   <tr>
    <th>배경 그림</th>
    <td>
     - 페이지 배경 그림의 주소를 적어주세요. (바둑판식 적용)<br />
     <input type="text" name="bgimage" size="64" value="<?php echo $admin_data['bgimage']; ?>" maxlength="255">
    </td>
   </tr>
   <tr>
    <th>페이지당 게시물 수</th>
    <td>
     <select name="article_per_page">
      <option value="<?php echo $admin_data['app']; ?>" selected="selected">현재 설정: <?php echo $admin_data['app']; ?></option>
      <option value="1">1</option>
      <option value="3">3</option>
      <option value="5">5</option>
      <option value="7">7</option>
      <option value="9">9</option>
      <option value="11">11</option>
     </select>
    </td>
   </tr>
   <tr>
    <th>게시판 스킨</th>
    <td>
     - 게시판의 모양을 사용자 정의할 수 있습니다.<br />
     <select name="board_skin">
      <option value="<?php echo $admin_data['skin']; ?>" selected="selected">현재 설정: <?php echo $admin_data['skin']; ?></option>
<?php
if ($handle = opendir('skin/')) {
    while (false !== ($file = readdir($handle))) { 
        if (is_dir('skin/' . $file) && $file != '.' && $file != '..') { 
            echo "<option value=\"{$file}\">{$file}</option>\n"; 
        }
    }
    closedir($handle); 
}
?>
     </select>
    </td>
   </tr>
   <tr>
    <th>최대 업로드 크기</th>
    <td>
     - 업로드되는 그림의 크기가 너무 클 경우를 대비하여, 제한을 두는 기능입니다.<br />
     - 0은 PHP 업로드 크기 제한입니다. (<span class="red"><?php echo ini_get('upload_max_filesize'); ?></span>)<br />
     - 바이트 단위로 기재하여 주십시오.<br />
     <span class="black">
      <input type="text" name="fileup_max" size="14" value="<?php echo $admin_data['fileup_max']; ?>" class="center" />
      byte(s)
     </span>
    </td>
   </tr>
   <tr>
    <th>HTML 태그 허용</th>
    <td>
     - 목록에 게시물 내용이나 의견글을 표시할 때, HTML 태그의 허용 여부를 결정합니다.<br />
     <span class="black">
      <input type="radio" name="use_html" value="t" <?php echo $html_tag['on']; ?> />게시물/의견글에 HTML 태그 허용
      <input type="radio" name="use_html" value="f" <?php echo $html_tag['off']; ?> />HTML 태그 허용하지 않음
     </span>
    </td>
   </tr>
   <tr>
    <th>게시판 상단 파일</th>
    <td>
     - 게시판의 상단에 포함할 (include) HTML 파일을 지정합니다.<br />
     - body, head 등의 태그는 여기에 지정한 파일의 값을 우선으로 처리합니다.<br />
     <input type="text" name="include_up" size="64" value="<?php echo $admin_data['include_top']; ?>" maxlength="255" />
    </td>
   </tr>
   <tr>
    <th>게시판 하단 파일</th>
    <td>
     - 게시판의 하단에 포함할 (include) HTML 파일을 지정합니다.<br />
     <input type="text" name="include_bt" size="64" value="<?php echo $admin_data['include_bottom']; ?>" maxlength="255" />
    </td>
   </tr>
   <tr>
    <th>게시판 타이틀</th>
    <td>
     - 웹브라우저의 제목 표시줄에 표시할 텍스트입니다.<br />
     - 아무것도 입력하지 않으시면 기본값을 사용합니다. (EtchiBBS <?php echo $bbs['version']; ?> [경로])<br />
     <input type="text" name="titlebar" size="32" value="<?php echo $admin_data['titlebar']; ?>" maxlength="255" />
    </td>
   </tr>
   <tr>
    <th>그림 크기 조절</th>
    <td>
     - 그림의 가로(width)크기가 아래 수치를 넘으면 자동으로 아래 크기로 리사이징합니다.<br />
     - 0은 리사이징을 하지 않습니다. (권장 - 리사이징시 그림이 깨질 수 있습니다)<br />
     <span class="black">
      <input type="text" name="width_max" size="14" value="<?php echo $admin_data['width_max']; ?>" class="center" />
      픽셀 이상의 가로 크기는 현재 수치로 재조절 (가로/세로 비율 고정)
     </span>
    </td>
   </tr>
   <tr>
    <th>자동 링크 기능</th>
    <td>
     - 게시물 내부에 있는 웹사이트 주소를 자동으로 링크로 처리해주는 기능입니다.<br />
     <span class="black">
      <input type="radio" name="autolink" value="t" <?php echo $autolink['on']?> />사용함
      <input type="radio" name="autolink" value="f" <?php echo $autolink['off']?> />사용하지 않음
     </span>
    </td>
   </tr>
   <tr>
    <th>파일 중복 체크</th>
    <td>
     - 첨부된 그림의 md5값을 추출하여 이미 올라온 적이 있는 그림인지를 검사해 줍니다.<br />
     - 게시판에 약간의 성능 저하가 있을 수 있습니다. (글 작성시)<br />
     <span class="black">
      <input type="radio" name="backdrum" value="t" <?php echo $backdrum['on']?> />사용함
      <input type="radio" name="backdrum" value="f" <?php echo $backdrum['off']?> />사용하지 않음
     </span>
    </td>
   </tr>
   <tr>
    <th>시스템 정보</th>
    <td>
     [ <a href="javascript: show_sysinfo();">여기를 클릭하시면 서버 시스템 정보를 표시합니다.</a> ]
    </td>
   </tr>
  </table>
 </div>
 <p class="center">
 <input accesskey="s" type="submit" value="설정 저장(Alt+S)" />
 <input accesskey="r" type="reset" value="다시 작성(Alt+R)" />
 </p>
</form>
</body>
</html>
<?php
/* {{{ TODO list?
   <TR><TD width="146" height=58 bgcolor="#F4F4F4">
   <P align=center><FONT color=black><SPAN style="FONT-SIZE: 9pt">게시물 숨기기</SPAN></FONT></P></TD>
   <TD width="501" height=58 bgcolor="#FAFAFA">
   <P><FONT color="#003399"><SPAN style="FONT-SIZE: 9pt">- 사용자들의 투표에 의해 혐오감을 주는 등의 게시물을 목록에서 숨길 수 있습니다.<BR>
   - 0은 사용하지 않음을 나타냅니다.<br>
   </SPAN></FONT><FONT color=black><SPAN style="FONT-SIZE: 9pt"><INPUT style="TEXT-ALIGN: center" size="10" name="vote_max" value="<?php echo $admin_data[vote_max]?>" maxlength="10">개 이상의 비추천을 받았을 때 게시물 숨김</SPAN></FONT></P></TD></TR>

   <TR><TD width="146" height=58 bgcolor="#F4F4F4">
   <P align=center><FONT color=black><SPAN style="FONT-SIZE: 9pt">게시물 저장 한계치</SPAN></FONT></P></TD>
   <TD width="501" height=58 bgcolor="#FAFAFA">
   <P><FONT color="#003399"><SPAN style="FONT-SIZE: 9pt">- 다음 수치를 넘으면 오래된 게시물 순서대로 글을 삭제합니다.<BR>
   - 0은 무제한입니다 (게시물을 제한 없이 저장합니다)</SPAN></FONT><FONT color=blue><SPAN style="FONT-SIZE: 9pt">
   <br>
   <INPUT style="TEXT-ALIGN: center" size=14 value="0" name="article_max" value="<?php echo $admin_data[article_max]?>" readonly><font color=black>개까지 저장</font></SPAN></FONT></P></TD></TR>
   }}} */
?>
