<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 Yun-young Lee
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: db.pgsql.sql,v 1.5 2004/01/23 02:57:58 lseeker Exp $
 */

$db_admin_t = <<<DB_ADMIN
CREATE TABLE hboard_db_admin (
	passwd	varchar(30) NOT NULL,
	skin	varchar(100),
	app	integer DEFAULT 0 NOT NULL,
	fileup_max	integer DEFAULT 0 NOT NULL,
	html_tag	char(1) DEFAULT 'f' NOT NULL,
	include_top	varchar(255),
	include_bottom	varchar(255),
	title_text	text,
	bgimage	varchar(255),
	width_max	integer DEFAULT 0 NOT NULL,
	lang	varchar(50),
	article_max	integer,
	titlebar	varchar(255),
	autolink	char(1) DEFAULT 'f' NOT NULL,
	backdrum	char(1) DEFAULT 't' NOT NULL
);
DB_ADMIN;

$db_article_t = <<<DB_ARTICLE
CREATE TABLE hboard_db_article (
	idx	serial,
	name	varchar(30) DEFAULT 'unknown' NOT NULL,
	email	varchar(100),
	home	varchar(255),
	ipaddr	varchar(50) NOT NULL,
	passwd	varchar(30) NOT NULL,
	date	varchar(50) NOT NULL,
	cfile	varchar(50),
	subject	varchar(255),
	ment	text,
	deleted	char(1) DEFAULT 'f' NOT NULL,
	reply	integer DEFAULT 0 NOT NULL,
	agent	varchar(255),
	md5	char(32) NOT NULL,
    CONSTRAINT hboard_db_article_pkey PRIMARY KEY (idx)
);
CREATE INDEX hboard_db_article_md5 ON hboard_db_article (md5)
DB_ARTICLE;


$db_comment_t = <<<DB_COMMENT
CREATE TABLE hboard_db_comment (
	idx	integer NOT NULL,
	article	integer NOT NULL,
	name	varchar(30) DEFAULT 'unknown' NOT NULL,
	email	varchar(100),
	home	varchar(255),
	icon	varchar(255),
	ipaddr	varchar(50),
	passwd	varchar(30) NOT NULL,
	date	varchar(50) NOT NULL,
	ment	text,
	deleted	char(1) DEFAULT 'f' NOT NULL,
	agent	varchar(255),
    CONSTRAINT hboard_db_comment_pkey PRIMARY KEY (article, idx)
);
DB_COMMENT;
?>
