<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: install.php,v 1.18.2.1 2004/04/01 01:06:59 lseeker Exp $
 */

/* FOR RELEASE */
error_reporting(E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR);

session_start();
header('Content-Type: text/html; charset=UTF-8');

$step = empty($_REQUEST['step']) ? 0 : (int) $_REQUEST['step'];

/* {{{ HEAD */
echo <<<HEAD
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
 <title>EtchiBBS Installation Wizard - Step {$step}</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="internal.css" rel="stylesheet" type="text/css">
 <script type="text/javascript">
<!--
function checkform_db(form) {
    if (form.user.value == '') {
        alert('사용자명을 입력하세요. (Fill username)');
        form.user.focus();
        return false;
    }

    if (form.dbname.value == '') {
        alert('데이터베이스명을 입력하세요. (Fill database)');
        form.dbname.focus();
        return false;
    }

    return true;
}

function checkform_pw(form) {
    if(form.password.value == "") {
        alert("비밀번호를 입력하세요. (Fill password)");
        form.password.focus();
        return false;
    }

    if(form.pwconfirm.value == "") {
        alert("비밀번호 확인을 입력하세요. (Fill confirm)");
        form.pwconfirm.focus();
        return false;
    }

    if(form.password.value != form.pwconfirm.value) {
        alert("입력된 비밀번호 두 개가 일치하지 않습니다. (Not match)");
        return false;
    }

    return true;
}
//-->
 </script>
</head>
<body>
HEAD;
/* }}} */

if (file_exists('db/dbconn.php')) {
    echo '<p><span class="blue">ERROR :: 이미 설치가 완료된 상태입니다. (Already installed)</span><br />다시 설치하시려면 db디렉토리의 dbconn.php 파일을 삭제하신 후 시도하세요.</p>';
} elseif ($step && (!isset($_SESSION['install_step']) || $step != $_SESSION['install_step'])) {
    echo '<p><span class="red">정상적인 순서로 설치를 진행해 주십시오. (Follow installration step)</span><br />[ <a href="install.php">설치 처음으로 (Step 0)</a> ]</p>';
} else {
    switch ($step) {
        case 0:
            /* {{{ STEP 0 */
            echo <<<STEP0T
 <div id="install"><h1>EtchiBBS 설치 - System check</h1>
  <div id="insthead">
   <p>EtchiBBS 설치를 시작하기 전에, 먼저 문제가 발생할 수 있는 시스템 환경을 진단합니다. 아래에서 문제점을 확인하신 후, 해당 환경을 수정하여 주십시오.</p>
  </div>
STEP0T;
            $noerror = TRUE;

            if (file_exists('dbconn.php')) {
                echo '<p><span color="blue">ERROR :: EtchiBoard 1.0.x를 검출했습니다. (Use converter for old version)</span><br />EtchiBBS Spiral을 사용하시려면 DB 변환 작업을 해주세요.</p>';
                $noerror = FALSE;
            }

            if (substr(phpversion(), 0, 3) < 4.2 || version_compare(phpversion(), '4.2.0', '<')) {
                echo '<p><span class="red">ERROR :: PHP 4.2 이상에서만 작동합니다.(You need PHP &gt;= 4.2)</span><br />PHP를 업그레이드 해 주십시오.</p>';
                $noerror = FALSE;
            }

            if (!extension_loaded('mysql') && !extension_loaded('pgsql')) {
                echo '<p><span class="red">ERROR :: 사용할 수 있는 DBMS가 없습니다. (PHP DBMS interface not found)<br />PHP에서 MySQL이나 PostgreSQL을 사용할 수 있어야 합니다.</p>';
                $noerror = FALSE;
            }

            umask(0111);
            if (!is_dir('db') || (fileperms('db') & 03 != 03 && fileperms('db') & 030 != 030) || !touch('db/index.html')) {
                echo '<p><span class="red">ERROR :: 디렉토리 퍼미션이 올바르지 않습니다. (Permission denied on DB directory)</span><br />chmod 명령을 사용하여 db 디렉토리의 권한을 703 이상으로 부여해 주세요.</p>';
                $noerror = FALSE;
            }

            if ($noerror) {
                echo '<p><span class="green">SUCCESS :: 자가 진단결과 오류가 없습니다. (OK)</span><br />아래 링크를 클릭하시면 설치를 시작합니다.</p><p class="center">[ <a href="install.php?step=1">설치 마법사 시작 (Next)</a> ]</p>';
                $_SESSION['install_step'] = 1;
            }
            /* }}} */
            break;
        case 1:
            /* {{{ STEP 1 */
            $_SESSION['install_step'] = 2;

            echo <<<STEP1T
 <div id="install"><h1>EtchiBBS 설치 - Enter DB connect info.</h1>
  <div id="insthead">
   <p>EtchiBBS 설치 마법사에 오신 것을 환영합니다!<br />이 마법사는 여러분이 홈 페이지에 쉽고 빠르게 EtchiBBS를 설치하실 수 있도록도와주는 역할을 합니다.</p>
   <p>아래에 관리자에서 안내받거나, 혹은 여러분이 설정하신 데이터베이스 연결에 관한 정보를 기입해 주십시오.<br />(Fill the database connect information)</p>
  </div>
STEP1T;

            $dbs = '';
            if (extension_loaded('mysql')) $dbs .= '<option value="mysql">MySQL</option>';
            if (extension_loaded('pgsql')) $dbs .= '<option value="pgsql">PostgreSQL</option>';

            echo <<<STEP1B
  <form method="post" action="install.php" onsubmit="return checkform_db(this);">
   <div>
    <input type="hidden" name="step" value="2" />
    <table id="instable" cellpadding="2" cellspacing="1">
     <tr>
      <td>데이터베이스 종류 (DBMS)</td>
      <td><select name="dbms">{$dbs}</select></td>
     </tr>
     <tr>
      <td>데이터베이스 서버 (hostname)</td>
      <td><input type="text" name="host" value="localhost" /></td>
     </tr>
     <tr>
      <td>사용자 ID (username)</td>
      <td><input type="text" name="user" /></td>
     </tr>
     <tr>
      <td>비밀번호 (password)</td>
      <td><input type="password" name="pass" /></td>
     </tr>
     <tr>
      <td>데이터베이스 이름 (database)</td>
      <td><input type="text" name="dbname" /></td>
     </tr>
     <tr>
      <td colspan="2">
       <button type="submit"><img src="img/install_ok.jpg" width="85" height="35"
        alt="OK" title="OK" /></button>
       <button type="reset"><img src="img/install_reset.jpg" width="85" height="35"
        alt="Reset" title="Reset" /></button>
      </td>
     </tr>
    </table>
   </div>
  </form>
STEP1B;
            /* }}} */
            break;
        case 2:
            /* {{{ STEP 2 */
            echo <<<STEP2T
 <div id="install"><h1>EtchiBBS 설치 - Enter Administrator Password</h1>
  <div id="insthead">
   <p>게시판의 관리를 위해 필요한 관리자 비밀번호를 입력해 주세요. (관리자 비밀번호는 별도의 관리자모드로 접근 및 게시물 수정, 삭제 등에 사용됩니다)</p>
   <p>주의 - 이 단계를 거치지 않고 게시판에 엑세스할 경우, 게시판이 정상 작동하지 않습니다.</p>
  </div>
STEP2T;
            require "lib/db.{$_POST['dbms']}.php";
            set_error_handler('error_dbconn');

            $DB = new DB($_POST['host'], $_POST['user'], $_POST['pass'], $_POST['dbname']);
            if ($DB->query('SELECT count(*) FROM hboard_db_admin') !== FALSE) {
                echo('<span class="red">DB에 이미 테이블이 존재합니다. (Already exists DB tables)</span>');
                $DB->close();
            } else {
                $DB->close();

                $_SESSION['db_dbms'] = $_POST['dbms'];
                $_SESSION['db_host'] = $_POST['host'];
                $_SESSION['db_user'] = $_POST['user'];
                $_SESSION['db_pass'] = $_POST['pass'];
                $_SESSION['db_name'] = $_POST['dbname'];

                echo <<<STEP2
  <form method="post" action="install.php" onsubmit="return checkform_pw(this);">
   <div>
    <input type="hidden" name="step" value="3" />
    <table id="instable" cellpadding="2" cellspacing="1">
     <tr>
      <td>비밀번호 (password)</td>
      <td><input type="password" name="password" /></td>
     </tr>
     <tr>
      <td>확인 입력 (confirm)</td>
      <td><input type="password" name="pwconfirm" /></td>
     </tr>
     <tr>
      <td colspan="2">
       <button type="submit"><img src="img/install_ok.jpg" width="85" height="35"
        alt="OK" title="OK" /></button>
       <button type="reset"><img src="img/install_reset.jpg" width="85" height="35"
        alt="Reset" title="Reset" /></button>
      </td>
     </tr>
    </table>
   </div>
  </form>
STEP2;
                $_SESSION['install_step'] = 3;
            }
            /* }}} */
            break;
        case 3:
            /* {{{ STEP 3 */
            require "lib/db.{$_SESSION['db_dbms']}.php";
            $DB = new DB($_SESSION['db_host'], $_SESSION['db_user'], $_SESSION['db_pass'], $_SESSION['db_name']);

            /* 테이블 만들기 */
            require "lib/db.{$_SESSION['db_dbms']}.sql";
            $DB->query($db_admin_t);
            $DB->query($db_article_t);
            $DB->query($db_comment_t);

            /* 데이터베이스 설정파일 (dbconn.php) 쓰기 */
            umask(0111);
            $fp = fopen('db/dbconn.php', 'w');
            fwrite($fp, "<?php\n");
            fwrite($fp, $_SESSION['db_dbms'] . "\n");
            fwrite($fp, $_SESSION['db_host'] . "\n");
            fwrite($fp, $_SESSION['db_user'] . "\n");
            fwrite($fp, $_SESSION['db_pass'] . "\n");
            fwrite($fp, $_SESSION['db_name'] . "\n");
            fwrite($fp, '?>');
            fclose($fp);

            mt_srand(microtime() * 1e6);
            $admin_passwd = addslashes(crypt($_POST['password'], chr(mt_rand(0x21, 0x7E)) . chr(mt_rand(0x21, 0x7E))));
            $now_date = date('Y/m/d H:i:s');

            $DB->query("INSERT INTO hboard_db_admin VALUES ('{$admin_passwd}', 'frog_yellow', 5, 512000, 'f', '', '', '<h1 style=\"text-align: center\">Welcome to EtchiBBS!</h1>', '', '0', 'ko', '0', '', 't', 't')");
            $DB->close();

            // 디렉토리/파일 구조 만들기
            umask(0); /* 디렉토리용 umask */
            mkdir("db/ico");
            mkdir("db/img");

            // 빈 index.html 로 디렉토리 목록 차단
            umask(0111); /* 파일용 umask */
            copy('db/index.html', 'db/ico/index.html');
            copy('db/index.html', 'db/img/index.html');
            echo <<<STEP3
 <div id="install"><h1>EtchiBBS 설치 - Setup Complete</h1>
  <div id="insthead">
   <p>축하합니다, 게시판 설치가 완료되었습니다.<br />원활한 게시판 관리를 위해, 아래 정보를 참고하여 주세요.</p>
   <p>EtchiBBS를 선택하여 주셔서 감사합니다.<br />(Thanks for using EtchiBBS)</p>
  </div>
  <div>
   <p class="small">다음과 같은 DB 테이블이 데이터베이스에 생성되었습니다:<br />
   <ul>
    <li>hboard_db_article (게시물 데이터)</li>
    <li>hboard_db_comment (의견글 데이터)</li>
    <li>hboard_db_admin (관리자 설정 데이터)</li>
   </ul></p>
   <p class="small">아래 <em>설치 완료</em> 버튼을 누르시면 게시판으로 이동합니다.
   게시판으로 이동한 후, 주소 입력줄에 표시되는 주소를 그대로 홈 페이지에
   링크하시면 됩니다. (Click next link image)</p>
   <p class="center"><a href="list.php"><img src="img/install_complete.jpg"
    width="85" height="35" alt="Complete" title="Complete"></a></p>
  </div>
STEP3;
            /* }}} */
            break;
    }
    /* {{{ FOOT */
    echo <<<FOOT
  <hr />
  <address>
   EtchiBBS Spiral-2 &copy; 2004 <a href="http://etchibbs.kldp.net">EtchiBoard Project</a>
  </address>
 </div>
 <div id="instimg">
  <img src="img/install_char.jpg" width="279" height="480" alt="Welcome to EtchiBBS~" />
 </div>
FOOT;
    /* }}} */
}

echo '</body></html>';

function error_dbconn($errno, $errstr, $errfile, $errline) {
    if ($errno == E_USER_ERROR) {
        echo '<p><span color="red">DB 접속에 실패했습니다. 입력이 정확한지 다시 확인해보세요.<br />[ <a href="javascript: history.back(1);">돌아가기 (Back)</a> ]</p>';
        $_SESSION['install_step'] = 1;
        exit;
    }
}
?>
