<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: rename_icon_ok.php,v 1.16 2004/03/16 02:25:55 lseeker Exp $
 */

require 'common.php';

if(isset($_POST['rename_to'])) {
    // 파일명으로 부적절한 부분은 변경.. (1.0.5)
    $rename_to = get_magic_quotes_gpc() ? stripslashes($_POST['rename_to']) : $_POST['rename_to'];
    $rename_to = str_replace("\\", "_", $rename_to);
    $rename_to = str_replace("?", "_", $rename_to);
    $rename_to = str_replace("\"", "_", $rename_to);
    $rename_to = str_replace("/", "_", $rename_to);
    $rename_to = str_replace(":", "_", $rename_to);
    $rename_to = str_replace("*", "_", $rename_to);
    $rename_to = str_replace("<", "_", $rename_to);
    $rename_to = str_replace(">", "_", $rename_to);
    $rename_to = str_replace("|", "_", $rename_to);
    $rename_to = str_replace("#", "_", $rename_to); // ?
    $rename_to = str_replace("%", "_", $rename_to); // ??
}

/* {{{ 오류 처리 */
if (!$admin['login']) error_exit('관리자 쿠키를 찾을 수 없습니다.', FALSE);

if (empty($_POST['file'])) error_exit('변경할 아이콘의 이름을 전달받지 못하였습니다.', FALSE);

if (empty($rename_to)) error_exit('바꿀 아이콘의 이름을 전달받지 못하였습니다.', FALSE);

if (file_exists("db/ico/" .$rename_to) || !strcmp($rename_to, 'none.jpg')) error_exit('이미 같은 이름의 아이콘이 존재합니다.<br />중복을 막기 위해, 다른 이름으로 변경하여 주십시오.', FALSE);
/* }}} */

$file = get_magic_quotes_gpc() ? stripslashes($_POST['file']) : $_POST['file'];

// 파일명 바꾸기..
rename("db/ico/{$file}", "db/ico/{$rename_to}") or die("<br>오류 발생: 파일의 이름을 바꿀 수 없습니다.<br>해당 파일의 권한이 올바르게 설정되었는지 확인해 주세요.<br><a href=\"javascript:history.back(1)\">[되돌아가기]</a>");;

// db의 파일명 업데이트..
$file      = addslashes($file);
$rename_to = addslashes($rename_to);
$DB->query("UPDATE hboard_db_comment SET icon='{$rename_to}' WHERE icon='{$file}'") or die('Query Error!');
$DB->close();

header('HTTP/1.1 303 See Other');
$redirect_to = 'iconman.php';
include 'lib/redirect.php';
?>
