<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: rss.php,v 1.4.2.4 2004/04/01 02:32:39 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/article.php';

// HEADER OUTPUT
header('Content-Type: application/rdf+xml; charset=UTF-8');

$sitetitle = empty($admin_data['titlebar']) ? 'EtchiBBS Spiral :: RSS' : htmlspecialchars($admin_data['titlebar']);
$listlink = $_SERVER['SERVER_NAME'] . str_replace('rss.php', 'list.php', $_SERVER['PHP_SELF']);
$viewlink = $_SERVER['SERVER_NAME'] . str_replace('rss.php', 'view.php?no=', $_SERVER['PHP_SELF']);

echo <<<RSSHEAD
<?xml version="1.0" encoding="UTF-8"?>
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://purl.org/rss/1.0/">
 <channel rdf:about="http://{$_SERVER['SERVER_NAME']}{$_SERVER['PHP_SELF']}">
  <title>{$sitetitle}</title>
  <link>http://{$listlink}</link>
  <description>
   EtchiBBS Spiral recent articles.
  </description>
 </channel>

RSSHEAD;

// GET RECENT ARTICLES INFO
$Result = new DBResult($DB->query("SELECT * FROM hboard_db_article ORDER BY idx DESC LIMIT 20"));
$DB->close();
$Article = new Article;

// PRINT TO RSS
while ($Article->readDB($Result->fetch())) {
    if ($Article->deleted) {
        $title = '삭제된 게시물입니다.';
        $content = '삭제된 게시물입니다.';
    } else {
        $title   = empty($Article->subject) ? '(제목 없음)' : htmlspecialchars($Article->subject);
        $content = htmlspecialchars(nl2br(htmlspecialchars($Article->content)));
    }

    echo <<<REPEAT
 <item rdf:about="http://{$viewlink}{$Article->no}">
  <title>{$title}</title>
  <link>http://{$viewlink}{$Article->no}</link>
  <description>
   {$content}
  </description>
 </item>

REPEAT;
}

// FOOT OUTPUT
?>

</rdf:RDF>

