<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: post_modify.php,v 1.31 2004/03/23 16:41:36 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/layout.php';
include 'lib/article.php';

/* 오류 처리 */
if (!empty($_FILES['picture']['tmp_name']) && $_FILES['picture']['error']) error_exit("<b>PHP 업로드 처리중에 오류가 발생했습니다.</b><br />PHP Upload Error Code: {$_FILES['picture']['error']}", TRUE);

/* 그림 크기가 관리자가 제한한 크기보다 클 경우 (0은 무제한 의미이므로 생략..) */
if (!empty($_FILES['picture']['tmp_name']) && $admin_data['fileup_max'] && $_FILES['picture']['size'] > $admin_data['fileup_max']) {
    $fileup_max_in_kb = (int)(($admin_data['fileup_max']/1024+0.5));
    error_exit("<b>파일의 크기가 너무 큽니다!</b><br>※ 파일의 크기는 최대 {$fileup_max_in_kb}KB로 제한됩니다.", TRUE);
}

if (!$admin['login'] && !strcmp($_POST['passwd'], '')) error_exit('비밀번호가 비어있습니다.');

$NewArticle = new Article;
$NewArticle->readPost();

/* 이름, 타이틀, 내용, 비밀번호 등이 등록되지 않았을 때.. */
if (!strcmp($NewArticle->name, '') || empty($_POST['ne']) || empty($_POST['article_no'])) error_exit('<b>데이터가 모두 전송되지 않았습니다.</b><br>폼에 필요한 데이터를 모두 채워주세요.', TRUE);

if (!$admin['login']) $NewArticle->writeCookie();

$Result = new DBResult($DB->query("SELECT passwd, deleted, cfile, date FROM hboard_db_article WHERE idx=" . intval($_POST['article_no'])));

if (!$Result->numrows()) error_exit('존재하지 않는 게시물입니다');

$article =& $Result->fetch();
$Result->free();

if ($article['deleted'] == 't') error_exit('삭제된 게시물입니다.');

$NewArticle->registerDate($article['date']);

if (!$admin['login'] && strcmp($article['passwd'], crypt($NewArticle->password, $article['passwd']))) error_exit('비밀번호가 올바르지 않습니다.');

ignore_user_abort(TRUE);

if ($NewArticle->image) {
    $NewImage = new Image($NewArticle->image);

    if ($admin_data['backdrum'] == 't') $NewImage->checkMD5();
    if ($admin_data['allow_filetype'] & FILETYPE_CHECK) $NewImage->checkFileType($admin_data['allow_filetype']);

    $OldImage = new Image('db/img/' . $article['cfile']);
    $OldImage->remove();

    $NewImage->upload($NewArticle->no);
}

$NewArticle->writeDB();
$DB->close();

// 메시지 출력
$Layout = new Layout($admin_data);
$Layout->hideInclude();

$MessageBox = new MessageBox;
$MessageBox->setTypeList((int) $_POST['page'], $NewArticle->no);
$MessageBox->registerTitle('안내');
$MessageBox->registerMessage("{$NewArticle->no}번 게시물의 수정 작업을 완료했습니다.");

$Layout->printHeader();
$MessageBox->printOut();
$Layout->printFooter();

?>
