<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: list.inc,v 1.42.2.7 2004/03/15 11:23:59 lseeker Exp $
 */

function AutoLink($ment) {
    // 주소 자동링크 function
    /* FIXME UTF-8 코드에 맞게 처리해야;; */
    /* URL reference: RFC 1738 */
    $ment = eregi_replace("([[:alnum:]]+)://([a-z0-9\200-\377\\_\./#~@:?=%&\-]+)", "<a href=\"\\1://\\2\" target=\"_blank\">\\1://\\2</a>", $ment);
    return $ment;
}

function PrintArticle(&$article, $print_button) {
    // 글 목록 출력 function
    /* {{{ global,s */
    global $admin_data; // 관리자 설정
    global $admin;
    global $skin; // 스킨 처박질
    global $page; // 페이지 처박질
    global $search_word, $search_type; // 검색어 처박질 (검색모드일때만..)
    /* }}} */

    /* html 태그 없애기 (..) */
    $article['name']    = htmlspecialchars($article['name']);
    $article['email']   = htmlspecialchars($article['email']);
    $article['home']    = htmlspecialchars($article['home']);
    $article['subject'] = htmlspecialchars($article['subject']);
    /* 멘트 내용은 설정이 있는 상태에만.. */
    if ($admin_data['html_tag']{0} == 'f') $article['ment'] = htmlspecialchars($article['ment']);

    $article['ment'] = nl2br($article['ment']);

    /* 검색모드일 경우 검색어 강조처리 (...삽질) */
    if($search_word && $search_type) {
        // 검색어랑 타잎이 있을 경우..
        if($search_type == 'name') $article['name'] = str_replace($search_word, "<font color=\"{$skin['sfont1_color']}\"><b>{$search_word}</b></font>", $article['name']);
        elseif($search_type == 'subject') $article['subject'] = str_replace($search_word, "<font color=\"{$skin['sfont1_color']}\"><b>{$search_word}</b></font>", $article['subject']);
        elseif($search_type == 'ment') $article['ment'] = str_replace($search_word, "<font color=\"{$skin['sfont1_color']}\"><b>{$search_word}</b></font>", $article['ment']);
    }

    /* 메인 출력부 시작 */
    /** 게시물이 삭제되었을 경우, 타이틀 바꾸기 **/
    if ($article['deleted']{0} == 't') $article['subject'] = "삭제된 게시물입니다.";

    /** 게시물 제목이 없을 경우 자동으로 [제목없음] 처리 **/
    if (!isset($article['subject']{0})) $article['subject'] = '(제목 없음)';

    /** 계속 진행.. **/
    echo <<<ARTICLEHEAD
<a name="{$article['idx']}"></a>
<form action="post_comment.php" method="post" onsubmit="return checkform_comment(this);">
<div style="padding: 0px 5%">
 <div style="border: 2px outset; background-image: url('skin/{$admin_data['skin']}/title_bg.gif'); color: {$skin['sfont2_color']}; padding: 5px">No.
   {$article['idx']} - <b>{$article['subject']}</b>
   <span style="color: {$skin['sfont1_color']}">[by&nbsp;
ARTICLEHEAD;

    echo isset($article['email']{0}) ? "<a href=\"mailto:{$article['email']}.NOSPAM\"><font color=\"{$skin['sfont1_color']}\">{$article['name']}</font></a>" : $article['name'];

    if (isset($article['home']{0})) echo " <a href=\"{$article['home']}\" target=\"_blank\" title=\"홈 페이지\"><img src=\"skin/{$admin_data['skin']}/home.gif\" border=\"0\" alt=\"홈 페이지\" /></a>";

    if($admin['login']) echo " (from {$article['ipaddr']})";

    echo <<<ARTICLEMIDDLE
   - {$article['date']}]</span>
 </div>
 <div style="border-style: outset; border-width: 0px 1px 1px 1px; background-color: {$skin['image_table_bgcolor']}; padding: 5px">
  <div style="overflow: auto; margin-bottom: 4px">
ARTICLEMIDDLE;

    if($article['deleted']{0} == 't') {
        echo <<<ARTICLEDELETED
<p style="text-align: center"><img src="skin/{$admin_data['skin']}/deleted.jpg" border="0" alt="deleted.jpg" /></p>
</div>
<p style="text-align: center"><strong>이 게시물은 작성자 혹은 관리자에 의해 삭제되었습니다.</strong></p>
ARTICLEDELETED;
    } else {
        /* {{{ 게시물 표시 */

        /* 그림 가로/세로 크기 긁어오기 */
        $image = getimagesize('db/img/' . $article['cfile']);
        if($admin_data['width_max'] != 0 && $image[0] > $admin_data['width_max']) {
            /* 그림크기가 제한되고 그 크기가 지정된 가로크기보다 클 경우 (?) */
            $imagewidth  = $admin_data['width_max'];
            $imageheight = (int) ($image[1] / $image[0] * $admin_data['width_max']);
            $resized = TRUE;
        } else {
            /* 말짱하다면 -3- */
            $imagewidth  = $image[0];
            $imageheight = $image[1];
            $resized = FALSE;
        }

        /* URL 자동링크 */
        if ($admin_data['autolink']{0} == 't') $article['ment'] = AutoLink($article['ment']);

        /* 파일 크기 구하기.. */
        $cfilesize['b']  = filesize("db/img/" .$article['cfile']);
        $cfilesize['kb'] = sprintf('%.2f', $cfilesize['b'] / 1024);

        $cfile_encoded = rawurlencode($article['cfile']);

        if ($resized) {
            // ... alt만 쓰자니 모질라가 울고-_- title만 쓰자니 익스가 울고 -_-;;;;;
            echo <<<ARTICLEIMAGERESIZED
 <a href="db/img/{$cfile_encoded}" target="_blank"
   title="{$article['cfile']}: {$imagewidth}x{$imageheight}(으)로 크기 조정 (원래크기 {$image[0]}x{$image[1]}) - 클릭하시면 새 창으로 원래 크기의 그림을 표시합니다."><img
   src="db/img/{$cfile_encoded}" width="{$imagewidth}" height="{$imageheight}"
   alt="{$article['cfile']}: {$imagewidth}x{$imageheight}(으)로 크기 조정 (원래크기 {$image[0]}x{$image[1]}) - 클릭하시면 새 창으로 원래 크기의 그림을 표시합니다."
   style="border: 0px; margin-bottom: 2px" /></a>
ARTICLEIMAGERESIZED;
        } else {
            echo <<<ARTICLEIMAGENORESIZE
 <a href="db/img/{$cfile_encoded}" target="_blank"
   title="{$article['cfile']} ({$image[0]}x{$image[1]}) - 클릭하시면 새 창으로 그림을 표시합니다."><img
   src="db/img/{$cfile_encoded}" width="{$imagewidth}" height="{$imageheight}"
   alt="{$article['cfile']} ({$image[0]}x{$image[1]}) - 클릭하시면 새 창으로 그림을 표시합니다."
   style="border: 0px; margin-bottom: 2px" /></a>
ARTICLEIMAGENORESIZE;
        }

        echo <<<ARTICLEMAIN
</div>
<div style="background-color: {$skin['text_table_bgcolor']}; padding: 5px">
 <p style="color: {$skin['ment_fontcolor']}">{$article['ment']}</p>
</div>
<small>* <b>User-agent:</b> {$article['agent']}<br />
<span style="color: {$skin['text_table_bgcolor']}">*&nbsp;</span><b>File Size:</b>
{$cfilesize['b']} Byte(s) ({$cfilesize['kb']} KB)
<b>[<a href="downadd.php?file={$article['cfile']}">DOWNLOAD</a>]</b></small><br>
ARTICLEMAIN;
        /* }}} */
    }

    /* {{{ 답글 표시 */
    if ($article['reply']) {
        $result = &DB::query("SELECT idx, name, email, home, icon, ipaddr, date, ment FROM hboard_db_comment WHERE article={$article['idx']} AND deleted<>'t' ORDER BY article, idx", $GLOBALS['dbconn']);
        /* {{{ 커멘트 출력부분 */
        while ($comment = &DB::fetch($result)) {
            /* html 태그 없애기 (..) */
            $comment['name']  = htmlspecialchars($comment['name']);
            $comment['home']  = htmlspecialchars($comment['home']);
            $comment['email'] = htmlspecialchars($comment['email']); 
            /* 멘트 내용은 설정이 있는 상태에만.. */
            if($admin_data['html_tag']{0} == 'f') $comment['ment'] = htmlspecialchars($comment['ment']);
            /* 개행부분 <br>로 바꿔주기 =_= */
            $comment['ment'] = nl2br($comment['ment']);

            /* URL 자동링크 */
            if($admin_data['autolink']{0} == 't') $comment['ment'] = AutoLink($comment['ment']); 

            echo <<<COMMENTHEAD
<div style="padding: 1px 5%">
 <hr style="color: {$skin['hr_color']}; height:1px; border-color: {$skin['hr_color']}; border-style: solid; border-width: 1px 0px 0px 0px" />
 <div style="background-color: {$skin['image_table_bgcolor']}">No. {$comment['idx']} [by&nbsp;
COMMENTHEAD;

            echo isset($comment['email']{0}) ? "<a href=\"mailto:{$comment['email']}.NOSPAM\" title=\"클릭하시면 작성자에게 메일을 전송합니다.\">{$comment['name']}</a>\n" : $comment['name'];
            if (isset($comment['home']{0})) echo " <a href=\"{$comment['home']}\" target=\"_blank\" title=\"홈 페이지\"><img src=\"skin/{$admin_data['skin']}/home.gif\" border=\"0\" alt=\"홈 페이지\"></a>";
            if ($admin['login']) echo " (from {$comment['ipaddr']})";

            echo <<<COMMENTMAIN
] {$comment['date']}
 <a href="del_comment.php?confirm=true&amp;article={$article['idx']}&amp;num={$comment['idx']}&amp;page={$page}" title="의견글 삭제"><img src="skin/{$admin_data['skin']}/del_cmt.gif" border="0" alt="의견글 삭제" style="vertical-align: middle" /></a></div>
 <table cellpadding="1" cellspacing="0">
  <tr><td valign="top">
COMMENTMAIN;

            if (!strcmp($comment['icon'], 'none.jpg') || !file_exists('db/ico/' . $comment['icon'])) {
                echo "<img src=\"skin/{$admin_data['skin']}/none.jpg\" alt=\"No Icon\" border=\"0\">";
            } else { 
                echo '<img src="db/ico/' . rawurlencode($comment['icon']) . "\" alt=\"{$comment['icon']}\" style=\"border: 0px\">";
            }

            echo "</td><td valign=\"top\" style=\"color: {$skin['ment_fontcolor']}\">{$comment['ment']}</td></tr></table></div>";
        }
        /* }}} */
        DB::free($result); /* 반복 실행이므로 처리하는 편이 좋음 */
    }
    /* }}} */

    // 하단부 명령버튼 (Modify, Del, ...) 출력 (있을시만)
    if($print_button == true && $article['deleted'] != "t") {
        echo <<<BUTTONS
<div>
 <a href="modify.php?article_no={$article['idx']}&amp;page={$page}" title="글 수정"><img
   src="skin/{$admin_data['skin']}/modify.gif" border="0" alt="글 수정" /></a>
 <a href="del_article.php?article={$article['idx']}&amp;confirm=true&amp;page={$page}" title="글 삭제"><img
   src="skin/{$admin_data['skin']}/delete.gif" border="0" alt="글 삭제" /></a>
 <a href="comment.php?article={$article['idx']}&amp;page={$page}" title="의견 달기" onclick="return show_comment_form({$article['idx']});" ondblclick="window.location.href='comment.php?article={$article['idx']}&amp;page={$page}';"><img
   src="skin/{$admin_data['skin']}/reply.gif" alt="의견 달기" style="border: 0px"></a>
</div>
<div id="comment_form{$article['idx']}" style="padding: 1px 5%"></div>
BUTTONS;
    }

    echo '</div></div></form><br />';
}
?>
