<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: del_comment.php,v 1.18 2004/03/23 16:41:36 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/layout.php';

$Layout = new Layout($admin_data);
$Layout->hideInclude();

if(isset($_GET['confirm'])) {
    include 'lib/confirmbox.php';

    if (empty($_GET['article']) || empty($_GET['num'])) error_exit('삭제할 의견글을 입력해주세요.', TRUE);

    $ConfirmBox = new ConfirmBox;
    $ConfirmBox->registerAction('del_comment.php');
    $ConfirmBox->registerValues($_GET['page'], $_GET['article'], $_GET['num']);

    if ($admin['login']) {
        $ConfirmBox->hidePasswordInput();
        $ConfirmBox->registerMessage('선택하신 의견글을 정말로 삭제하시겠습니까?');
    } else {
        $ConfirmBox->registerMessage('의견글 작성시 넣으셨던 비밀번호를 입력하세요.');
    }

    $Layout->printHeader();
    $ConfirmBox->printOut();
    $Layout->printFooter();
    exit;
}

if (!$admin['login'] && empty($_POST['password'])) error_exit('비밀번호가 비어 있습니다.', TRUE);

if (empty($_POST['article'])) error_exit('삭제될 게시물이 지정되지 않았습니다.', TRUE);

if (empty($_POST['num'])) error_exit('삭제될 의견글이 지정되지 않았습니다.', TRUE);

$article_no = (int) $_POST['article']; // 메시지 function에서 쓰는.. article_no로 넣어주기;
$num  = (int) $_POST['num'];

// db 읽어들이기
$Result = new DBResult($DB->query("SELECT deleted, passwd FROM hboard_db_comment WHERE article={$article_no} and idx={$num}"));

if (!$Result->numrows()) error_exit('해당하는 의견글이 없습니다.', TRUE);

$reply =& $Result->fetch();
$Result->free();

if ($reply['deleted'] == 't') error_exit('이미 삭제된 의견글입니다.', TRUE);

if(!$admin['login'] && $reply['passwd'] != crypt($_POST['password'], $reply['passwd'])) error_exit('비밀번호가 올바르지 않습니다.', TRUE);

// 비밀번호가 올바르고 게시물/의견글 번호가 지정되었다면... db 처리 *-_-*
$DB->query("UPDATE hboard_db_comment set deleted='t' WHERE article={$article_no} and idx={$num}");
$DB->close();

/* completed */
$MessageBox = new MessageBox;
$MessageBox->setTypeList((int) $_POST['page'], $article_no);
$MessageBox->registerTitle('안내');
$MessageBox->registerMessage("{$article_no}번 게시물의 {$num}번째 의견글을 삭제했습니다.");

$Layout->printHeader();
$MessageBox->printOut();
$Layout->printFooter();

?>
