<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: iconman.php,v 1.13 2004/03/16 02:25:55 lseeker Exp $
 */

require 'lib/common.php';
$DB->close();

header('Content-Type: text/html; charset=UTF-8');

if(!$admin['login']) error_exit('관리자 쿠키를 찾을 수 없습니다.', FALSE);
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
 <title>EtchiBBS 아이콘 관리자</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="internal.css" rel="stylesheet" type="text/css">
</head>

<body>
<div id="config">
 <div id="confhead">
  <h1>EtchiBBS 아이콘 관리자</h1>
  <div id="confclose">[ <a href="javascript: window.close();">창 닫기</a> ]</div>
 </div>
 <p>
 <em>설치된 아이콘의 목록</em>을 표시하고 있습니다.<br />
 아이콘은 50x50 크기로 조절하여 표시하므로, 실제와 다르게 보일 수 있습니다.
 </p>
 <form name="iconup" method="post" action="upload_icon.php" enctype="multipart/form-data">
  <table cellpadding="2" cellspacing="1" width="100%" class="icon">
   <tr>
    <th><label for="file">새 아이콘 추가</label></th>
    <td align="center">
     <input type="file" name="iconfile" size="31" />
     <input type="submit" value="업로드" />
    </td>
   </tr>
  </table>
 </form>
 <ul id="iconlist">
<?php
if ( ($handle = opendir('db/ico/'))) {
    while (FALSE !== ($file = readdir($handle))) { 
	   if ($file != '.' && $file != '..' && $file != 'none.jpg' && $file != 'index.html') {
           $file_encoded = rawurlencode($file);
           $file_size    = sprintf('%.2f', filesize('db/ico/' . $file) / 1024);
           echo <<<VIEW_ICON
  <li>
   <img src="db/ico/{$file_encoded}" width="50" height="50" alt="{$file}" />
   <span class="black">
    <span class="red"><b>|</b></span>아이콘 파일명: {$file}<br />
    <span class="blue"><b>|</b></span>파일 크기: {$file_size} KB<br />
    [<a href="delete_icon.php?file={$file_encoded}"><span class="red">아이콘 삭제</span></a>]
    [<a href="rename_icon.php?file={$file_encoded}">파일명 변경</a>]
   </span>
  </li>
VIEW_ICON;
        }
    }
    closedir($handle);
}
?>
 </ul>
</div>
</body>
</html>
