<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: list.inc,v 1.75 2004/03/17 06:01:21 lseeker Exp $
 */

function &AutoLink(&$ment) {
    // 주소 자동링크 function
    /* URL reference: RFC 1738 */
    return ereg_replace("[a-z0-9+.-]+:(//)?([a-z0-9&-.!\$;=?\\\\_]+(:[a-z0-9&-.!\\\$;=?\\\\_]+)?@)?[[:alnum:]\200-\377.%-]+(:[[:digit:]]+)?(/[^[:space:]&#?]+)*(\\?[^[:space:]#]+)?(#[^[:space:]<>\"])?", '<a href="\\0" target="_blank">\\0</a>', $ment);
}

/* {{{ ArticleBox class */
class ArticleBox {
    var $article;
    var $reply = NULL;

    var $page = NULL;

    var $show_buttons = TRUE;
    var $show_ip      = FALSE;

    var $autolink = TRUE;
    var $usehtml  = FALSE;
    var $maxwidth = 0;

    function registerArticle(&$article) {
        $article->name     = htmlspecialchars($article->name);
        $article->email    = htmlspecialchars($article->email);
        $article->homepage = htmlspecialchars($article->homepage);
        $article->subject  = htmlspecialchars($article->subject);
        if (!$this->usehtml) $article->content = htmlspecialchars($article->content);

        $this->article =& $article;
    }

    function registerReply(&$reply) {
        $this->reply =& $reply;
    }

    function readConfig(&$config) {
        $this->autolink = $config['autolink'] == 't' ? TRUE : FALSE;
        $this->usehtml  = $config['html_tag'] == 't' ? TRUE : FALSE;
        $this->maxwidth = (int) $config['width_max'];
    }

    function hideButtons() {
        $this->show_buttons = FALSE;
    }

    function registerPage($page) {
        $this->page = (int) $page;
    }

    function showIPAddress() {
        $this->show_ip = TRUE;
    }

    function highlight(&$type, &$word) {
        if (!isset($this->article->$type)) trigger_error("Invalid ArticleBox::highlight type {$type}", E_USER_ERROR);
        if (!strcmp($type, 'image')) return;

        $this->article->$type = str_replace($word, "<span class=\"fgSpc1 fontBold\">{$word}</span>", $this->article->$type);
    }

    function printOut() {
        $skin_path = 'skin/' . __SKIN__;

        if ($this->article->deleted) $this->article->subject = '삭제된 게시물입니다.';

        if (!empty($this->article->email)) $this->article->name = "<a href=\"mailto:{$this->article->email}.NOSPAM\" class=\"fgSpc1\">{$this->article->name}</a>";
        if (!empty($this->article->homepage)) $this->article->homepage = "<a href=\"{$this->article->homepage}\" target=\"_blank\" title=\"홈페이지\"><img src=\"{$skin_path}/home.gif\" alt=\"홈페이지\" /></a>";

        if (empty($this->article->subject)) $this->article->subject = '(제목 없음)';

        $ipout = $this->show_ip ? "(from {$this->article->ip})" : '';

        echo <<<ARTICLEHEAD
<form action="post_comment.php" method="post" onsubmit="return checkform_comment(this);">
 <div id="{$this->article->no}" class="hbArticle">
  <div class="bgTitle hbTitle">No. {$this->article->no} - <b>{$this->article->subject}</b>
   <span class="fgSpc1">[by {$this->article->name} {$this->article->homepage} {$ipout} - {$this->article->date}]</span>
  </div>
  <div class="bgImage hbBody">
ARTICLEHEAD;

        /* {{{ 몸통 */
        if ($this->article->deleted) {
            echo <<<ARTICLEDELETED
   <p class="center"><img src="{$skin_path}/deleted.jpg" alt="deleted" /></p>
   <p class="center"><strong>이 게시물은 작성자 혹은 관리자에 의해 삭제되었습니다.</strong></p>
ARTICLEDELETED;
        } else {
            if ($this->autolink) $this->article->content =& AutoLink($this->article->content);
            $content = nl2br($this->article->content);

            $Image = new Image($this->article->image);

            if ($this->maxwidth && $Image->width > $this->maxwidth) {
                $width  = $this->maxwidth;
                $height = (int) ($Image->height / $Image->width * $this->maxwidth);
                $alt    = "{$Image->name}: {$width}x{$height}(으)로 크기 조정 (원래 크기 {$Image->width}x{$Image->height}) - 클릭하시면 새 창으로 원래 크기의 그림을 표시합니다.";
            } else {
                $width  = $Image->width;
                $height = $Image->height;
                $alt    = "{$Image->name}: ({$width}x{$height}) - 클릭하시면 새 창으로 그림을 표시합니다.";
            }

            $size_k = sprintf('%.2f', $Image->size / 1024);

            echo <<<ARTICLEBODY
  <div class="hbImage"><a href="{$Image->file}" target="_blank" title="{$alt}"><img src="{$Image->file}" width="{$width}" height="{$height}" alt="{$alt}" /></a></div>
  <div class="bgText hbContent"><p class="fgMent">{$content}</p></div>
  <div class="fontXSmall">
   * <b>User-agent:</b> {$this->article->useragent}<br />
   * <b>File Size:</b> {$Image->size} Byte(s) ({$size_k} KB) <b>[<a href="downadd.php?file={$Image->name}">DOWNLOAD</a>]</b>
  </div>
ARTICLEBODY;
        }
        /* }}} */

        /* {{{ 덧글 */
        if ($this->article->reply_count && $this->reply) {
            do {
                if ($this->reply->articleNo != $this->article->no) break;
                $reply = $this->usehtml ? $this->reply->content : htmlspecialchars($this->reply->content);
                if ($this->autolink) $reply =& AutoLink($reply);
                $reply = nl2br($reply);

                echo "<div class=\"hbComment\"><hr />No. {$this->reply->no} [by ";

                echo empty($this->reply->email) ? $this->reply->name : "<a href=\"mailto:{$this->reply->email}.NOSPAM\" title=\"클릭하시면 작성자에게 메일을 전송합니다.\">{$this->reply->name}</a>";
                if (!empty($this->reply->homepage)) echo " <a href=\"{$this->reply->homepage}\" target=\"_blank\" title=\"홈페이지\"><img src=\"{$skin_path}/home.gif\" alt=\"홈페이지\"></a>";
                if ($this->show_ip) echo " (from {$this->reply->userip})";

                echo <<<ReplyHTML
] {$this->reply->date}
 <a href="del_comment.php?confirm=true&amp;article={$this->reply->articleNo}&amp;num={$this->reply->no}&amp;page={$this->page}" title="의견글 삭제"><img src="{$skin_path}/del_cmt.gif" alt="의견글 삭제" class="middle" /></a>
 <table cellpadding="1" cellspacing="1">
  <tr><td align="center" valign="top">
ReplyHTML;

                if (!strcmp($this->reply->icon, 'none.jpg') || !file_exists('db/ico/' . $this->reply->icon)) {
                    echo "<img src=\"skin/{$GLOBALS['admin_data']['skin']}/none.jpg\" alt=\"No Icon\" />";
                } else { 
                    echo '<img src="db/ico/' . rawurlencode($this->reply->icon) . "\" alt=\"{$this->reply->icon}\" />";
                }

                echo "</td><td valign=\"top\" class=\"fgMent\">{$reply}</td></tr></table></div>";
            } while ($this->reply->prepareNext());
        }
        /* }}} */

        /* {{{ 버튼 */
        if($this->show_buttons && !$this->article->deleted) {
            echo <<<BUTTONS
<div class="hbButton">
 <a href="modify.php?article_no={$this->article->no}&amp;page={$this->page}" title="글 수정"><img
   src="{$skin_path}/modify.gif" alt="글 수정" /></a>
 <a href="del_article.php?article={$this->article->no}&amp;confirm=true&amp;page={$this->page}" title="글 삭제"><img
   src="{$skin_path}/delete.gif" alt="글 삭제" /></a>
 <a href="comment.php?article={$this->article->no}&amp;page={$this->page}" title="의견 달기" onclick="return show_comment_form({$this->article->no});" ondblclick="window.location.href='comment.php?article={$this->article->no}&amp;page={$this->page}';"><img
   src="{$skin_path}/reply.gif" alt="의견 달기" /></a>
</div>
<div id="comment_form{$this->article->no}" class="hbCForm"></div>
BUTTONS;
        }
        /* }}} */

        echo '</div></div></form>';
    }
}
/* }}} */

/* {{{ Reply class */
class Reply extends DBResult {
    /* public */
    var $articleNo = 0;
    var $isDeleted = FALSE;

    /* private */
    var $no;
    var $name;
    var $email;
    var $homepage;
    var $icon;
    var $content;

    var $userip;
    var $useragent;
    var $password;

    var $date;

    var $autolink;
    var $usehtml;
    var $show_ip = FALSE;
    var $page    = NULL;

    function Reply(&$result) {
        if ($result === NULL) {
            /* READ FROM POST */
        } else {
            $this->DBResult($result);
        }
    }

    function prepareNext() {
        if ($this->fetchNext()) {
            $this->no         = (int) $this->fetched->idx;
            $this->articleNo = (int) $this->fetched->article;

            $this->name     = htmlspecialchars($this->fetched->name);
            $this->email    = htmlspecialchars($this->fetched->email); 
            $this->homepage = htmlspecialchars($this->fetched->home);

            $this->icon      =& $this->fetched->icon;
            $this->content   =& $this->fetched->ment;
            $this->userip    =& $this->fetched->ipaddr;
            $this->useragent =& $this->fetched->agent;
            $this->password  =& $this->fetched->password;
            $this->date      =& $this->fetched->date;

            $this->isDeleted = $this->fetched->deleted == 't' ? TRUE : FALSE;

            return TRUE;
        } else return FALSE;
    }
}
/* }}} */

?>
