// MmanagerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Mmanager.h"
#include "MmanagerDlg.h"

#include <winioctl.h>
#include <winsvc.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define DEVICE_NAME "ffs"

/*
 * FFS_BSD_PARTITION
 */
typedef struct _FFS_BSD_PARTITION
{
	ULONG Number;
} FFS_BSD_PARTITION, *PFFS_BSD_PARTITION;

#define IOCTL_SELECT_BSD_PARTITION \
	CTL_CODE(FILE_DEVICE_UNKNOWN, 2049, METHOD_BUFFERED, FILE_WRITE_ACCESS)

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CMmanagerDlg dialog



CMmanagerDlg::CMmanagerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMmanagerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMmanagerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_DISK_COMBO, m_DiskCombo);
	DDX_Control(pDX, IDC_PARTITION_COMBO, m_PartitionCombo);
	DDX_Control(pDX, IDC_DISKLABEL_COMBO, m_DisklabelCombo);
	DDX_Control(pDX, IDC_DRIVE_COMBO, m_DriveCombo);
	DDX_Control(pDX, IDC_LOADDRIVER, m_btnLoadDriver);
	DDX_Control(pDX, IDC_MOUNT, m_btnMount);
	DDX_Control(pDX, IDC_UNMOUNT, m_btnUnmount);
	DDX_Control(pDX, IDC_AUTOMOUNTCHECK, m_AutoMountCheck);
}

BEGIN_MESSAGE_MAP(CMmanagerDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_LOADDRIVER, OnBnClickedLoaddriver)
	ON_BN_CLICKED(IDC_MOUNT, OnBnClickedMount)
	ON_BN_CLICKED(IDC_UNMOUNT, OnBnClickedUnmount)
	ON_BN_CLICKED(IDC_AUTOMOUNTCHECK, OnBnClickedAutomountcheck)
END_MESSAGE_MAP()


// CMmanagerDlg message handlers

BOOL CMmanagerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	/* Init */
	char *Diskitem[] = { "0", "1", "2", "3", "4", "5", "6", "7" };
	for (int i = 0; i < sizeof(Diskitem) / sizeof(*Diskitem); i++)
	{
		m_DiskCombo.AddString(Diskitem[i]);
	}
	m_DiskCombo.SetCurSel(0);

    char *Partitem[] = { "1", "2", "3", "4", "5", "6", "7", "8" };
	for (int i = 0; i < sizeof(Partitem) / sizeof(*Partitem); i++)
	{
		m_PartitionCombo.AddString(Partitem[i]);
	}
	m_PartitionCombo.SetCurSel(0);
	
	char *Disklabelitem[] = { "0", "1", "2", "3", "4", "5", "6", "7",
		"8", "9", "10", "11", "12", "13", "14", "15" };
	for (int i = 0; i < sizeof(Disklabelitem) / sizeof(*Disklabelitem); i++)
	{
		m_DisklabelCombo.AddString(Disklabelitem[i]);
	}
	m_DisklabelCombo.SetCurSel(0);

	char *Driveitem[] = {"X:\\"};
	for (int i = 0; i < sizeof(Driveitem) / sizeof(*Driveitem); i++)
	{
		m_DriveCombo.AddString(Driveitem[i]);
	}
	m_DriveCombo.SetCurSel(0);

	/* Detect Loaded Driver */
	hDriver = CreateFile("\\\\.\\" DEVICE_NAME, GENERIC_READ | GENERIC_WRITE, 0, 
		NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if (hDriver == INVALID_HANDLE_VALUE)
	{
		hDriver = NULL;
		m_btnMount.EnableWindow(FALSE);
		m_btnUnmount.EnableWindow(FALSE);
	}
	else
	{
		m_btnLoadDriver.EnableWindow(FALSE);
	}

	CloseHandle(hDriver);

	/* ڵ Ʈ  Ǿ  üũ ڽ üũ */
	if (AfxGetApp()->GetProfileInt("Settings", "AutoMount", 0))
	{
		/* Ʈ  ũ, Ƽ, ̺  оͼ ޺ڽ ڵ  */
		m_DiskCombo.SetCurSel(AfxGetApp()->GetProfileInt("Settings", "Disk", 0));
		m_PartitionCombo.SetCurSel(AfxGetApp()->GetProfileInt("Settings", "Partition", 0) - 1);
		m_DisklabelCombo.SetCurSel(AfxGetApp()->GetProfileInt("Settings", "Disklabel", 0));
		m_DriveCombo.SetCurSel(AfxGetApp()->GetProfileInt("Settings", "Drive", 0));

		m_DriveCombo.EnableWindow(FALSE);
		m_PartitionCombo.EnableWindow(FALSE);
		m_DisklabelCombo.EnableWindow(FALSE);
		m_DiskCombo.EnableWindow(FALSE);
		m_AutoMountCheck.SetCheck(TRUE);
	}
	else
	{
		int temp;
		/* Ʈ  ũ, Ƽ, ̺  оͼ ޺ڽ ڵ  */
		m_DiskCombo.SetCurSel((temp = AfxGetApp()->GetProfileInt("Settings", "Disk", 0)) ? temp : 0);
		m_PartitionCombo.SetCurSel((temp = AfxGetApp()->GetProfileInt("Settings", "Partition", 0)) ? temp - 1 : 0);
		m_DisklabelCombo.SetCurSel((temp = AfxGetApp()->GetProfileInt("Settings", "Disklabel", 0)) ? temp : 0);
		m_DriveCombo.SetCurSel((temp = AfxGetApp()->GetProfileInt("Settings", "Drive", 0)) ? temp : 0);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMmanagerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMmanagerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMmanagerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CMmanagerDlg::OnBnClickedLoaddriver()
{
	/* Load driver */
	if (!LoadDriver(DEVICE_NAME, NULL))
	{
		MessageBox("Driver install failed.", "Mount Manager");
		return;
	}


	/* ̹  ġ ٲ  */
	if (WinExec("ffs.sys", SW_HIDE) == ERROR_FILE_NOT_FOUND)
	{
		CString TempFilePath;
		char FilePath[MAX_PATH];
		static char BASED_CODE szFilter[] = "ffs.sys (*.sys)|ffs.sys|";
		CFileDialog FileDialog(TRUE, NULL, "ffs.sys", OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
			szFilter, NULL, 0);

		if (FileDialog.DoModal() == IDOK)
		{
			TempFilePath = FileDialog.GetPathName();
			lstrcpy((LPSTR)FilePath, (LPSTR)TempFilePath.operator const char*());

			/* ̹ θ ٲ۴. */
			SC_HANDLE hManager, hService;

			hManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
			hService = OpenService(hManager, DEVICE_NAME, SC_MANAGER_ALL_ACCESS);
			if (!ChangeServiceConfig(hService, SERVICE_KERNEL_DRIVER, SERVICE_NO_CHANGE, SERVICE_NO_CHANGE,
				FilePath, NULL, NULL, NULL, NULL, NULL, NULL))
			{
				return;
			}
			else
			{
				if (!hService)
				{
					hService = OpenService(hManager, DEVICE_NAME, SERVICE_ALL_ACCESS);
					if (!hService)
					{
						CloseServiceHandle(hManager);
						return;
					}
				}
			}

			StartService(hService, 0, NULL);
			CloseServiceHandle(hService);
			CloseServiceHandle(hManager);
		}
		else
		{
			MessageBox("Driver open error!", "Mount Manager");
			hDriver = NULL;
			return;
		}
	}


	MessageBox("Driver Load Complete.", "Mount Manager");
	m_btnLoadDriver.EnableWindow(FALSE);
	m_btnMount.EnableWindow(TRUE);
	m_btnUnmount.EnableWindow(TRUE);
}

void CMmanagerDlg::OnBnClickedMount()
{
	BOOL bMount = FALSE;
	BOOL bUmount = FALSE;
	int nDisk = 0;
	int nPart = 0;
	int nDrive = 0;
	int nDisklabel = 0;
	char DevName[256];
	char temp[4];
	char volume_name[] = " :";
	char volume[256];
	char msg[256];
	DWORD BytesReturned;
	HANDLE hdrive;
	FFS_BSD_PARTITION BSDPartition;

	m_DiskCombo.GetLBText(m_DiskCombo.GetCurSel(), temp);
	nDisk = atoi(&temp[0]);

	m_PartitionCombo.GetLBText(m_PartitionCombo.GetCurSel(), temp);
	nPart = atoi(&temp[0]);

	m_DisklabelCombo.GetLBText(m_DisklabelCombo.GetCurSel(), temp);
	nDisklabel = atoi(&temp[0]);

	m_DriveCombo.GetLBText(m_DriveCombo.GetCurSel(), temp);
	volume_name[0] = temp[0];
	nDrive = m_DriveCombo.GetCurSel();

	AfxGetApp()->WriteProfileInt("Settings", "Disk", nDisk);
	AfxGetApp()->WriteProfileInt("Settings", "Partition", nPart);
	AfxGetApp()->WriteProfileInt("Settings", "Disklabel", nDisklabel);
	AfxGetApp()->WriteProfileInt("Settings", "Drive", nDrive);

	sprintf(DevName, "\\Device\\Harddisk%d\\Partition%d", nDisk, nPart);

	/* open */
	hdrive = CreateFile("\\\\.\\" DEVICE_NAME, GENERIC_READ | GENERIC_WRITE, 0, 
		NULL, OPEN_EXISTING, FILE_FLAG_NO_BUFFERING, NULL);

	BSDPartition.Number = nDisklabel;

	if (!DeviceIoControl(
		hdrive,
		IOCTL_SELECT_BSD_PARTITION,
		&BSDPartition,
		sizeof(FFS_BSD_PARTITION),
		NULL,
		0,
		&BytesReturned,
		NULL))
	{
		wsprintf(msg, "Mount: Select BSD Partition %s error.\n", volume_name);
		MessageBox(msg, "Mount Manager");

		CloseHandle(hdrive);
		return;
	}

	CloseHandle(hdrive);

	/* 
	 * NTFS ߸ Ʈ   ״ FFS Ʈ
	 * FFS Ʈ   FFS 𸶿Ʈ ѵ ٽ Ʈ
	 */
	DWORD FileSystemFlag;
	char FileSystemName[64];
	volume[0] = volume_name[0];
	volume[1] = volume_name[1];
	volume[2] = '\\';
	GetVolumeInformation(volume, NULL, 0, NULL, NULL, &FileSystemFlag, FileSystemName, 63);

	if (strcmp("FFS", FileSystemName) == 0)
	{
		if (Unmount(volume_name) == FALSE)
			return;
	}
	
	if (Mount(DevName, volume_name) == TRUE)
	{
		wsprintf(msg, "Mount Complete. Drive %s", volume_name);
		MessageBox(msg, "Mount Manager");
	}
	else
	{
		wsprintf(msg, "Mount Failed. Drive %s", volume_name);
		MessageBox(msg, "Mount Manager");
	}
}

void CMmanagerDlg::OnBnClickedUnmount()
{
	char msg[256];
	char temp[4];
	char volume_name[] = " :";

	m_DriveCombo.GetLBText(m_DriveCombo.GetCurSel(), temp);
	volume_name[0] = temp[0];

	if(Unmount(volume_name) == TRUE)
	{
		wsprintf(msg, "Unmount Complete. Drive %s", volume_name);
		MessageBox(msg, "Mount Manager");
	}
}


/* Driver Functions */

BOOL CMmanagerDlg::LoadDriver(char *pDeviceName, char FullPath[MAX_PATH])
{
	SC_HANDLE hManager, hService;
	DWORD LastError;
	char strPath[MAX_PATH], temp[MAX_PATH];

	GetCurrentDirectory(MAX_PATH, strPath);
	sprintf(temp, "\\%s.sys", pDeviceName);
	strcpy(strPath + strlen(strPath), temp);


	hManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);

	if (FullPath != NULL)
		strcpy(strPath, FullPath);

	hService = CreateService(hManager, pDeviceName, pDeviceName, SERVICE_ALL_ACCESS, 
		SERVICE_KERNEL_DRIVER, SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL, strPath, 
		NULL, NULL, NULL, NULL, NULL);

	LastError = GetLastError();

	if (LastError = ERROR_SERVICE_EXISTS)
	{
		hService = OpenService(hManager, pDeviceName, SC_MANAGER_ALL_ACCESS);
		if (!ChangeServiceConfig(hService, SERVICE_KERNEL_DRIVER, SERVICE_NO_CHANGE, SERVICE_NO_CHANGE,
			strPath, NULL, NULL, NULL, NULL, NULL, NULL))
		{
			return FALSE;
		}
	}

	if (!hService)
	{
		hService = OpenService(hManager, pDeviceName, SERVICE_ALL_ACCESS);
		if (!hService)
		{
			CloseServiceHandle(hManager);
			return FALSE;
		}
	}

	StartService(hService, 0, NULL);
	CloseServiceHandle(hService);
	CloseServiceHandle(hManager);


	return TRUE;
}

/* Volume Mount & Unmount Functions */
BOOL CMmanagerDlg::Mount(char *pDeviceName, char *drive)
{

	if (!DefineDosDevice(
		DDD_RAW_TARGET_PATH,
		drive,
		pDeviceName))
	{
		return FALSE;
	}

	return TRUE;
}

BOOL CMmanagerDlg::Unmount(char *drive)
{
	char DosDevName[256];
	HANDLE hdevice;
	ULONG dwBytes;
	char msg[256];

	wsprintf(DosDevName, "\\\\.\\%s", drive);

	hdevice = CreateFile(
		DosDevName,
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		NULL);

	if (hdevice == INVALID_HANDLE_VALUE)
	{
		wsprintf(msg, "Unmount: open %s error.\n", drive);
		MessageBox(msg, "Mount Manager");
		return FALSE;
	}

	if (!DeviceIoControl(
		hdevice,
		FSCTL_LOCK_VOLUME,
		NULL,
		0,
		NULL,
		0,
		&dwBytes,
		NULL))
	{
		wsprintf(msg, "Unmount: Drive %s is mounted, LockVolume error.\n", drive);
		MessageBox(msg, "Mount Manager");

		CloseHandle(hdevice);
		return FALSE;
	}

	if (!DeviceIoControl(
		hdevice,
		FSCTL_DISMOUNT_VOLUME,
		NULL,
		0,
		NULL,
		0,
		&dwBytes,
		NULL))
	{
		wsprintf(msg, "Unmount: DisMount %s error.\n", drive);
		MessageBox(msg, "Mount Manager");
		CloseHandle(hdevice);
		return TRUE;
	}

	CloseHandle(hdevice);

	if (!DefineDosDevice(
		DDD_REMOVE_DEFINITION,
		drive,
		NULL))
	{
		wsprintf(msg, "Unmount: Remove %s error.\n", drive);
		MessageBox(msg, "Mount Manager");
		return FALSE;
	}

	return TRUE;
}

void CMmanagerDlg::OnBnClickedAutomountcheck()
{
	if (m_AutoMountCheck.GetCheck())
	{
		if (WinExec("ffs.sys", SW_HIDE) == ERROR_FILE_NOT_FOUND)
		{
			CString TempFilePath;
			char FilePath[MAX_PATH];
			static char BASED_CODE szFilter[] = "ffs.sys (*.sys)|ffs.sys|";
			CFileDialog FileDialog(TRUE, NULL, "ffs.sys", OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
				szFilter, NULL, 0);

			if (FileDialog.DoModal() == IDOK)
			{
				TempFilePath = FileDialog.GetPathName();
				lstrcpy((LPSTR)FilePath, (LPSTR)TempFilePath.operator const char*());

				if (!RegisterAutoMount(DEVICE_NAME, FilePath))
				{
					MessageBox("Driver install failed.", "Mount Manager");
					return;
				}
			}
			else
			{
				m_AutoMountCheck.SetCheck(FALSE);
				MessageBox("Driver open error!", "Mount Manager");
				hDriver = NULL;
				return;
			}
		}
		else
		{
			if (!RegisterAutoMount(DEVICE_NAME, NULL))
			{
				MessageBox("Driver install failed.", "Mount Manager");
				return;
			}
		}

		RegisterDriveLetter();
		m_DiskCombo.EnableWindow(FALSE);
		m_PartitionCombo.EnableWindow(FALSE);
		m_DisklabelCombo.EnableWindow(FALSE);
		m_DriveCombo.EnableWindow(FALSE);

	}
	else
	{
		UnregisterAutoMount(DEVICE_NAME);
		
		UnregisterDriveLetter();
		m_DiskCombo.EnableWindow(TRUE);
		m_PartitionCombo.EnableWindow(TRUE);
		m_DisklabelCombo.EnableWindow(TRUE);
		m_DriveCombo.EnableWindow(TRUE);
	}
}

BOOL CMmanagerDlg::RegisterAutoMount(char *pDeviceName, char FullPath[MAX_PATH])
{
	SC_HANDLE hManager, hService;
	DWORD LastError;
	char strPath[MAX_PATH], temp[MAX_PATH];

	GetCurrentDirectory(MAX_PATH, strPath);
	sprintf(temp, "\\%s.sys", pDeviceName);
	strcpy(strPath + strlen(strPath), temp);


	hManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);

	if (!hManager)
		return FALSE;


	if (FullPath != NULL)
		strcpy(strPath, FullPath);

	hService = CreateService(hManager, pDeviceName, pDeviceName, SERVICE_ALL_ACCESS, 
		SERVICE_KERNEL_DRIVER, SERVICE_SYSTEM_START, SERVICE_ERROR_NORMAL, strPath, 
		NULL, NULL, NULL, NULL, NULL);

	LastError = GetLastError();

	if (LastError = ERROR_SERVICE_EXISTS)
	{
		hService = OpenService(hManager, pDeviceName, SC_MANAGER_ALL_ACCESS);
		if (!ChangeServiceConfig(hService, SERVICE_KERNEL_DRIVER, SERVICE_SYSTEM_START, SERVICE_NO_CHANGE,
			strPath, NULL, NULL, NULL, NULL, NULL, NULL))
		{
			return FALSE;
		}
	}

	CloseServiceHandle(hService);
	CloseServiceHandle(hManager);


	return TRUE;
}

BOOL CMmanagerDlg::UnregisterAutoMount(char *pDeviceName)
{
	SC_HANDLE hManager, hService;

	hManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	hService = OpenService(hManager, pDeviceName, SC_MANAGER_ALL_ACCESS);
	if (!ChangeServiceConfig(hService, SERVICE_NO_CHANGE, SERVICE_DEMAND_START, SERVICE_NO_CHANGE,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL))
	{
		return FALSE;
	}

	CloseServiceHandle(hService);
	CloseServiceHandle(hManager);

	return TRUE;
}

BOOL CMmanagerDlg::RegisterDriveLetter()
{
	HKEY Key;
	int nDisk = 0;
	int nPart = 0;
	int nDisklabel = 0;
	int nDrive = 0;
	char DevName[MAX_PATH];
	char temp[4];
	char volume_name[] = " :";

	m_DiskCombo.GetLBText(m_DiskCombo.GetCurSel(), temp);
	nDisk = atoi(&temp[0]);

	m_PartitionCombo.GetLBText(m_PartitionCombo.GetCurSel(), temp);
	nPart = atoi(&temp[0]);

	m_DisklabelCombo.GetLBText(m_DisklabelCombo.GetCurSel(), temp);
	nDisklabel = atoi(&temp[0]);

	m_DriveCombo.GetLBText(m_DriveCombo.GetCurSel(), temp);
	volume_name[0] = temp[0];
	nDrive = m_DriveCombo.GetCurSel();

	sprintf(DevName,"\\Device\\Harddisk%d\\Partition%d", nDisk, nPart);

	/* ڵ   (). */
	AfxGetApp()->WriteProfileInt("Settings", "AutoMount", 1);

	/* ũ, Ƽ, ̺  . */
	AfxGetApp()->WriteProfileInt("Settings", "Disk", nDisk);
	AfxGetApp()->WriteProfileInt("Settings", "Partition", nPart);
	AfxGetApp()->WriteProfileInt("Settings", "Disklabel", nDisklabel);
	AfxGetApp()->WriteProfileInt("Settings", "Drive", nDrive);

	/*  α׷  */
	RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\DOS Devices", 
		0, KEY_ALL_ACCESS, &Key);
	RegSetValueEx(Key, volume_name, 0, REG_SZ, (BYTE *)DevName, strlen(DevName));

	/*  Parameters BSD Ƽ ȣ  */
	RegCreateKeyEx(HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Services\\ffs\\Parameters",
		0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &Key, NULL);

	//RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Services\\ffs\\Parameters", 
	//	0, KEY_ALL_ACCESS, &Key);
	RegSetValueEx(Key, "PartitionNumber", 0, REG_DWORD, (unsigned char *)&nDisklabel, sizeof(nDisklabel));

	RegCloseKey(Key);

	return TRUE;
}

BOOL CMmanagerDlg::UnregisterDriveLetter()
{
	HKEY Key;
	char temp[4];
	char volume_name[] = " :";

	m_DriveCombo.GetLBText(m_DriveCombo.GetCurSel(), temp);
	volume_name[0] = temp[0];

	/* ڵ   (). */
	AfxGetApp()->WriteProfileInt("Settings", "AutoMount", 0);

	/*  α׷  */
	RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\DOS Devices", 
		0, KEY_ALL_ACCESS, &Key);
	RegDeleteValue(Key, volume_name);

	/*  Parameters BSD Ƽ ȣ  */
	RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Services\\ffs\\Parameters", 
		0, KEY_ALL_ACCESS, &Key);
	RegDeleteValue(Key, "PartitionNumber");

	RegCloseKey(Key);

	return TRUE;
}
