/* foo_me2day : title_grabber class definition/implementation header.

Never contain any obfuscated/encrypted strings. :-)

Licensed under zlib/libpng license.

Copyright (c) 2007 Shin Jong hun (LunApapa, http://me2day.net/lunapapa)

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.

3. This notice may not be removed or altered from any source
distribution.

*/

#include <process.h>

#include "../SDK/foobar2000.h"
#include "../helpers/helpers.h"

#include "foo_me2day_me2api_supportor.h"
#include "foo_me2day_preferences.h"
#include "foo_me2day_webconn.h"

#ifndef _FOO_ME2DAY_TITLE_GRABBER_H_
#define _FOO_ME2DAY_TITLE_GRABBER_H_

class Title_grabber : private play_callback {

private:
	pfc::string8 Title_grabber::get_trackinfo () {
		static_api_ptr_t <play_control> pc;
		static_api_ptr_t<titleformat_compiler> tf_compiler;
		metadb_handle_ptr handle;
		pfc::string8 text;
		int selection = get_trackformat_radio_num ();

		if (pc->get_now_playing (handle)) {
			service_ptr_t <titleformat_object> script;
			switch (selection) {
				case 4:
					if (tf_compiler->compile (script, (const char *) get_trackinfo_custom_format())) {
						pc->playback_format_title_ex (handle, NULL, text, script, NULL, play_control::display_level_titles);
					}
					break;
				case 3:
					if (titleformat_config::g_compile (titleformat_config::config_systray, script)) {
						pc->playback_format_title_ex (handle, NULL, text, script, NULL, play_control::display_level_titles);
					}
					break;
				case 2:
					if (titleformat_config::g_compile (titleformat_config::config_statusbar, script)) {
						pc->playback_format_title_ex (handle, NULL, text, script, NULL, play_control::display_level_titles);
					}
					break;
				default:
					if (titleformat_config::g_compile (titleformat_config::config_windowtitle, script)) {
						pc->playback_format_title_ex (handle, NULL, text, script, NULL, play_control::display_level_titles);
					}
			}
		}

		return text;
	}

	// sender. see foo_me2day_supportor.h
	me2api_supportor me2day_sender;

public:
	/* TODO: ŸƲ ũ  ,  ̽ ߰ ʿ */

	Title_grabber () {
		/* Registering Callbacks! */
		static_api_ptr_t <play_callback_manager> pcb_manager;
		pcb_manager->register_callback (this, flag_on_playback_new_track, false);
	}
	~Title_grabber () {
		/* Do nothing. */
	}

	/* play_callback methods */
	virtual void on_playback_new_track (metadb_handle_ptr p_track) {
		if (false == get_bp_ti_send_func_enable() || true == get_cooldown_status())
			return;

		pfc::string8 track_string;

		track_string = get_trackinfo ();
		me2day_sender.call_me (track_string, track_string.length());
		HANDLE handle;
		handle = (HANDLE) _beginthread (Cooling_down, 0, NULL);
	}

	//  play_callback ޼
	virtual void on_playback_stop (play_control::t_stop_reason reason) {}
	virtual void on_playback_dynamic_info_track (const file_info &p_info) {}
	virtual void on_playback_starting (play_control::t_track_command p_command, bool p_paused) {}
	virtual void on_playback_seek (double p_time) {}
	virtual void on_playback_pause (bool p_state) {}
	virtual void on_playback_edited (metadb_handle_ptr p_track) {}
	virtual void on_playback_dynamic_info (const file_info &p_info) {}
	virtual void on_playback_time (double p_time) {}
	virtual void on_volume_change (float p_new_val) {}
};

#endif // _FOO_ME2DAY_TITLE_GRABBER_H_