/* foo_me2day : Webconnect/Cooling down thread function

Never contain any obfuscated/encrypted strings. :-)

Licensed under zlib/libpng license.

Copyright (c) 2007 Shin Jong hun (LunApapa, http://me2day.net/lunapapa)

Feel free to email me: luna.jetch _at_ gmail.com

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.

2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.

3. This notice may not be removed or altered from any source
distribution.

*/

#include <process.h>
#include <winsock2.h>
#include <tchar.h>
#include <time.h>
#include <stdio.h>

#include "foo_me2day_webconn.h"
#include "foo_me2day_preferences.h"
#include "foo_me2day.h"

/*	SendThread() Calling Examples : Create Handle - call "_beginthread()", - WaitForSingleObject (Optional.)

	HANDLE handle;
	handle = (HANDLE) _beginthread (SendThread, 0, buff);
	WaitForSingleObject (handle, INFINITE);		// Optional.
*/
void SendThread (void *msg) {
	char *send_msg = (char *) msg;
	
	WSADATA wsData;
	WSAEVENT wsEvent;
	WSANETWORKEVENTS wsa_nevents;

	sockaddr_in server;
	hostent *host = 0;
	int addrsize = 0;
	SOCKET s;

	if (0 != WSAStartup (MAKEWORD (2,2), &wsData)) {
		free (send_msg);
		if (true == get_warn_send_failure()) {
			if (true == get_turnoff_plugin_automatically()) {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ : WSA ʱȭ . ÷ մϴ."), 0);
				set_plugin_enabled (false);
			}
			else {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ : WSA ʱȭ ."), 0);
			}
		}
		_endthread ();
	}

	s = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (s == SOCKET_ERROR || s == INVALID_SOCKET) {
		WSACleanup ();

		free (send_msg);
		if (true == get_warn_send_failure()) {
			if (true == get_turnoff_plugin_automatically()) {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ :   . ÷ մϴ."), 0);
				set_plugin_enabled (false);
			}
			else {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ :   ."), 0);
			}
		}
		_endthread ();
	}

	// Event Initialization
	wsEvent = WSACreateEvent ();

	host = gethostbyname ("me2day.net");

	if (NULL == host) {
		WSACloseEvent (wsEvent);
		closesocket (s);
		WSACleanup ();
		free (send_msg);
		if (true == get_warn_send_failure()) {
			if (true == get_turnoff_plugin_automatically()) {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ : ȣƮ ã  . ÷ մϴ."), 0);
				set_plugin_enabled (false);
			}
			else {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ : ȣƮ ã  ."), 0);
			}
		}
		_endthread ();
	}

	memset (&server, 0, sizeof (server));
	memcpy ((char *) &server.sin_addr, host->h_addr, host->h_length);

	server.sin_family = AF_INET;
	server.sin_port = htons(80);

	if (SOCKET_ERROR == connect(s, (sockaddr *) &server, sizeof (server))) {
		WSACloseEvent (wsEvent);
		closesocket (s);
		WSACleanup ();

		free (send_msg);
		if (true == get_warn_send_failure()) {
			if (true == get_turnoff_plugin_automatically()) {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ :  . ÷ մϴ."), 0);
				set_plugin_enabled (false);
			}
			else {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ :  ."), 0);
			}
		}			
		_endthread ();
	}

	if(SOCKET_ERROR == WSAEventSelect (s, wsEvent, FD_CLOSE | FD_WRITE | FD_READ)) {
		WSACloseEvent (wsEvent);
		closesocket (s);
		WSACleanup ();

		free (send_msg);
		if (true == get_warn_send_failure()) {
			if (true == get_turnoff_plugin_automatically()) {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ : ̺Ʈ    . ÷ մϴ."), 0);
				set_plugin_enabled (false);
			}
			else {
				MessageBoxW (NULL, _T(" "), _T(" ߽ϴ : ̺Ʈ    ."), 0);
			}
		}
		_endthread ();
	}

	// no-operation api calling : Debug / Testing Purposes.

	//	_snprintf (buff, 1024, "POST /api/noop.xml HTTP/1.0\r\n"
	//	"Host: me2day.net\r\n"
	//	"Authorization: Basic %s\r\n"
	//	"me2_application_key: 7953ab6b5824a031e1e199ebbb37648c\r\n\r\n",
	//	m_b64ed_auth);

	while (true) {
		// Event Waiting(Block) time : Max. 3 seconds (3000msec)
		if (WAIT_TIMEOUT == WaitForSingleObject (wsEvent, 3000)) {
			break;
		}
		WSAEnumNetworkEvents (s, wsEvent, &wsa_nevents);

		// Promise me you won't go hell.
		if (wsa_nevents.lNetworkEvents & FD_WRITE) {
			if (SOCKET_ERROR == send (s, send_msg, (int) strlen (send_msg), 0)) {
				if (true == get_warn_send_failure()) {
					if (true == get_turnoff_plugin_automatically()) {
						MessageBoxW (NULL, _T(" "), _T(" ߽ϴ :  . ÷ մϴ."), 0);
						set_plugin_enabled (false);
					}
					else {
						MessageBoxW (NULL, _T(" "), _T(" ߽ϴ :  ."), 0);
					}
				}			
			}
			if (true == get_extra_debug_mode_enable()) {
				dbg_print (send_msg);
			}
		}
		else if (wsa_nevents.lNetworkEvents & FD_READ) {
			if (true == get_extra_debug_mode_enable()) {
				memset (send_msg, 0, sizeof (char) * 1280);
				recv (s, send_msg, 1270, 0);
				dbg_print (send_msg);
			}
			// don't recv(). for now at least.
			break;
		}
		else if (wsa_nevents.lNetworkEvents & FD_CLOSE) {
			break;
		}
	}

	WSACloseEvent (wsEvent);
	closesocket (s);
	WSACleanup ();

	free (send_msg);
	_endthread ();
}

static bool cooldown_now = false;

bool get_cooldown_status () {
	return cooldown_now;
}

static void set_cooldown_status (bool status) {
	cooldown_now = status;
}

/*	cooling_down() Calling Examples : Create Handle - call "_beginthread()", - WaitForSingleObject (Optional.)

HANDLE handle;
handle = (HANDLE) _beginthread (Cooling_down, 0, buff);
WaitForSingleObject (handle, INFINITE);		// Optional.
*/

// Really Stupid, But efficient code.
void Cooling_down (void *param) {
	set_cooldown_status (true);
	Sleep (get_cool_down_time() * 1000L);
	set_cooldown_status (false);
	_endthread ();
}

void dbg_print (const char *msg) {
	FILE *dbg_file = NULL;
	time_t time_n;
	struct tm dbg_time;
	errno_t err;

	time (&time_n);
	localtime_s (&dbg_time, &time_n);

	if (0 == (err = fopen_s (&dbg_file, "C:\\dbg_me2.log", "a+"))) {
		fprintf (dbg_file, "[%04d-%02d-%02d %02d:%02d:%02d] Debug String\n----\n%s\n----\n",
			dbg_time.tm_year+1900, dbg_time.tm_mon+1, dbg_time.tm_mday,
			dbg_time.tm_hour, dbg_time.tm_min, dbg_time.tm_sec, msg);
		fclose (dbg_file);
	}

	return;
}