#-*- coding:euc-kr -*-
# 
# Web Gallery Viewer Class 
# 
# Copyright (c) 2004 Jeong-Ho Eun <94eun@naver.com>. All rights reserved. 
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions 
# are met: 
# 1. Redistributions of source code must retain the above copyright 
#    notice, this list of conditions and the following disclaimer. 
# 2. Redistributions in binary form must reproduce the above copyright 
#    notice, this list of conditions and the following disclaimer in the 
#    documentation and/or other materials provided with the distribution. 
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND 
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE 
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
# SUCH DAMAGE. 
#
import sys
if hasattr(sys,"setdefaultencoding"):
    sys.setdefaultencoding("euc-kr")

import os
import threading
import wx
import wx.html as html
import wx.lib.newevent


if wx.Platform == '__WXMSW__':
    import wx.lib.iewin as iewin

__version__ = "0.6.0"

RESOURCES = {"Nate" : {
                 wx.NewId() :
                    {"title" : "- ҽ/ҹ",
                     "urls" : {"start_page" : 1,
                        "page_url": "http://bbs.nate.com/BBS?p_bbs_id=bbs008&p_pagenum=##value##",
                        "article_re": "javascript:bbs_qry\('[a-zA-Z0-9]+','([0-9]+)'",
                        "title_re": "color='*[a-zA-Z0-9]+'* +>([^<]*)<",
                        "article_url": "http://bbs.nate.com/BBS?p_bbs_id=bbs008&p_action=qry&p_num=##value##",
                        "image_re": "src=\"([^\"]+)\" onload"}},
                 wx.NewId() :
                    {"title" : "-Ÿ",
                     "urls" : {"start_page" : 1,
                        "page_url": "http://bbs.nate.com/BBS?p_bbs_id=starstyle&p_pagenum=##value##",
                        "article_re": "javascript:bbs_qry\('[a-zA-Z0-9]+','([0-9]+)'",
                        "title_re": "color='*[a-zA-Z0-9]+'* +>([^<]*)<",
                        "article_url": "http://bbs.nate.com/BBS?p_bbs_id=starstyle&p_action=qry&p_num=##value##",
                        "image_re": "src=\"([^\"]+)\" onload"}}
                        },
             "DCInside" : {
                wx.NewId() :
                    {"title" : "ģ",
                     "urls" : {"start_page" : 1,
                        "page_url": "http://kr.dcinside1.imagesearch.yahoo.com/zb40/zboard.php?id=girl&banner=&page=##value##&select_arrange=headnum&desc=asc&category=&sn=off&ss=on&sc=on&keyword=&sn1=&divpage=1",
                        "article_re": "zboard.php\\?id=girl&page=[0-9]+&sn1=&divpage=[0-9]+&banner=&sn=off&ss=on&sc=on&select_arrange=headnum&desc=asc&no=([0-9]+)",
                        "title_re": "zboard.php\\?id=girl&page=[0-9]+&sn1=&divpage=[0-9]+&banner=&sn=off&ss=on&sc=on&select_arrange=headnum&desc=asc&no=[0-9]+\" *>([^<]*)<",
                        "article_url": "http://kr.dcinside1.imagesearch.yahoo.com/zb40/zboard.php?id=girl&page=1&sn1=&divpage=1&banner=&sn=off&ss=on&sc=on&select_arrange=headnum&desc=asc&no=##value##",
                        "image_re": "<img src=([^ ]+) border=0 name=zb_target_resize style=\"cursor:hand\""}},
                 wx.NewId() :
                    {"title" : "̰̽",
                     "urls" : {"start_page" : 1,
                        "page_url": "http://kr.dcinside3.imagesearch.yahoo.com/zb40/zboard.php?id=racinggirl&banner=&page=##value##&select_arrange=headnum&desc=asc&category=&sn=off&ss=on&sc=on&keyword=&sn1=&divpage=2",
                        "article_re": "zboard.php\\?id=racinggirl&page=[0-9]+&sn1=&divpage=[0-9]+&banner=&sn=off&ss=on&sc=on&select_arrange=headnum&desc=asc&no=([0-9]+)",
                        "title_re": "zboard.php\\?id=racinggirl&page=[0-9]+&sn1=&divpage=[0-9]+&banner=&sn=off&ss=on&sc=on&select_arrange=headnum&desc=asc&no=[0-9]+\" *>([^<]*)<",
                        "article_url": "http://kr.dcinside3.imagesearch.yahoo.com/zb40/zboard.php?id=racinggirl&page=2&sn1=&divpage=2&banner=&sn=off&ss=on&sc=on&select_arrange=headnum&desc=asc&no=##value##",
                        "image_re": "<img src=([^ ]+) border=0 name=zb_target_resize style=\"cursor:hand\""}},
                 wx.NewId() :
                    {"title" : "Ƴ",
                     "urls" : {"start_page" : 1,
                        "page_url": "http://kr.dcinside2.imagesearch.yahoo.com/zb40/zboard.php?id=announcer&banner=&page=##value##&select_arrange=headnum&desc=asc&category=&sn=off&ss=on&sc=on&keyword=&sn1=&divpage=1",
                        "article_re": "zboard.php\\?id=announcer&page=[0-9]+&sn1=&divpage=[0-9]+&banner=&sn=off&ss=on&sc=on&select_arrange=headnum&desc=asc&no=([0-9]+)",
                        "title_re": "zboard.php\\?id=announcer&page=[0-9]+&sn1=&divpage=[0-9]+&banner=&sn=off&ss=on&sc=on&select_arrange=headnum&desc=asc&no=[0-9]+\" *>([^<]*)<",
                        "article_url": "http://kr.dcinside2.imagesearch.yahoo.com/zb40/zboard.php?id=announcer&page=1&sn1=&divpage=1&banner=&sn=off&ss=on&sc=on&select_arrange=headnum&desc=asc&no=##value##",
                        "image_re": "<img src=([^ ]+) border=0 name=zb_target_resize style=\"cursor:hand\""}}
                        },
             "̹" : {
                 wx.NewId() :
                    {"title" : "ģ",
                     "urls" : {"start_page" : 1,
                        "page_url": "http://new.photo.naver.com/ArticleList.nhn?mid=1&did=11&orderbyType=W&boardType=L&page=##value##",
                        "article_re": "http://new.photo.naver.com/ArticleRead.nhn\?mid=[0-9]+&did=[0-9]+&orderbyType=W&boardType=L&page=[0-9]+&articleNum=([0-9]+)\"><",
                        "title_re": "http://new.photo.naver.com/ArticleRead.nhn\?mid=[0-9]+&did=[0-9]+&orderbyType=W&boardType=L&page=[0-9]+&articleNum=[0-9]+\">([^<]*)</a>",
                        "article_url": "http://new.photo.naver.com/ArticleRead.nhn?mid=1&did=11&orderbyType=W&boardType=L&page=&articleNum=##value##",
                        "image_re": "onclick='popview\(\"([^\"]+)\"\)"}},
                 wx.NewId() :
                    {"title" : ",Ÿ",
                     "urls" : {"start_page" : 1,
                        "page_url": "http://new.photo.naver.com/ArticleList.nhn?mid=1&did=13&orderbyType=W&boardType=L&page=##value##",
                        "article_re": "http://new.photo.naver.com/ArticleRead.nhn\?mid=[0-9]+&did=[0-9]+&orderbyType=W&boardType=L&page=[0-9]+&articleNum=([0-9]+)\"><",
                        "title_re": "http://new.photo.naver.com/ArticleRead.nhn\?mid=[0-9]+&did=[0-9]+&orderbyType=W&boardType=L&page=[0-9]+&articleNum=[0-9]+\">([^<]*)</a>",
                        "article_url": "http://new.photo.naver.com/ArticleRead.nhn?mid=1&did=13&orderbyType=W&boardType=L&page=&articleNum=##value##",
                        "image_re": "onclick='popview\(\"([^\"]+)\"\)"}},
                 wx.NewId() :
                    {"title" : ",ռ",
                     "urls" : {"start_page" : 1,
                        "page_url": "http://new.photo.naver.com/ArticleList.nhn?mid=1&did=23&orderbyType=W&boardType=L&page=##value##",
                        "article_re": "http://new.photo.naver.com/ArticleRead.nhn\?mid=[0-9]+&did=[0-9]+&orderbyType=W&boardType=L&page=[0-9]+&articleNum=([0-9]+)\"><",
                        "title_re": "http://new.photo.naver.com/ArticleRead.nhn\?mid=[0-9]+&did=[0-9]+&orderbyType=W&boardType=L&page=[0-9]+&articleNum=[0-9]+\">([^<]*)<img",
                        "article_url": "http://new.photo.naver.com/ArticleRead.nhn?mid=1&did=23&orderbyType=W&boardType=L&page=&articleNum=##value##",
                        "image_re": "onclick='popview\(\"([^\"]+)\"\)"}},
                 wx.NewId() :
                    {"title" : "",
                     "urls" : {"start_page" : 1, 
                        "login" : {"url" : "http://id.naver.com/nidlogin.login?", "id_name" :"id", "pw_name" : "pw"},
                        "page_url": "http://new.photo.naver.com/ArticleList.nhn?mid=1&did=100014&orderbyType=W&boardType=L&page=##value##",
                        "article_re": "http://new.photo.naver.com/ArticleRead.nhn\?mid=[0-9]+&did=[0-9]+&orderbyType=W&boardType=L&page=[0-9]+&articleNum=([0-9]+)\"><",
                        "title_re": "http://new.photo.naver.com/ArticleRead.nhn\?mid=[0-9]+&did=[0-9]+&orderbyType=W&boardType=L&page=[0-9]+&articleNum=[0-9]+\">([^<]*)<img",
                        "article_url": "http://new.photo.naver.com/ArticleRead.nhn?mid=1&did=100014&orderbyType=W&boardType=L&page=&articleNum=##value##",
                        "image_re": "onclick='popview\(\"([^\"]+)\"\)"}}
                        },
             "RaySoda" : {
                 wx.NewId() :
                    {"title" : "RaySoda",
                     "urls" : {"start_page" : 0,
                        "page_url": "http://www.raysoda.com/Com/Photo/List.aspx?f=A&pg=##value##",
                        "article_re": "phtLI\(([0-9]+)",
                        "title_re": "phtLI\([0-9]+\,\"([^\"]*)",
                        "article_url": "http://www.raysoda.com/Com/Photo/View.aspx?f=A&p=##value##",
                        "image_re": "lpRP\(\"([^\"]+)\","}}
                        }
    };

ID_SAVE = wx.NewId()
ID_EXIT = wx.NewId()
ID_HELP = wx.NewId()
ID_KEY_HELP = wx.NewId()
ID_NEXT = wx.NewId()
ID_PREVIOUS = wx.NewId()
ID_RELOAD = wx.NewId()
ID_HOTKEY = wx.NewId()

(UpdateEvent, EVT_UPDATE) = wx.lib.newevent.NewEvent()

class MainFrame(wx.Frame):
    title = "Web Gallery Viewer"
    
    def __init__(self, parent, ID):
        wx.Frame.__init__(self, parent, ID, self.title, wx.DefaultPosition, wx.Size(600,750))
        
        # set Icon
        #icon = wx.Icon("py.ico", wx.BITMAP_TYPE_ICO)
        #self.SetIcon(icon)
        
        # Menu Bar
        self.mainMenuBar = wx.MenuBar()
        self.SetMenuBar(self.mainMenuBar)
        self.SetMenuBar(self.mainMenuBar)
        muGallery = wx.Menu()

        for sitename, site in RESOURCES.items():
            muSite = wx.Menu()
            muGallery.AppendMenu(wx.NewId(), sitename, muSite)
            items = site.items()
            items.sort()
            for id, res in items:
                muSite.Append(id, res["title"], "", wx.ITEM_NORMAL)
            
        muGallery.AppendSeparator()
        muGallery.Append(ID_SAVE, "", "", wx.ITEM_NORMAL)
        muGallery.AppendSeparator()
        muGallery.Append(ID_EXIT, "", "", wx.ITEM_NORMAL)
        self.mainMenuBar.Append(muGallery, "")
        muHelp = wx.Menu()
        muProgram = wx.MenuItem(muHelp, ID_KEY_HELP, "Ű", "", wx.ITEM_NORMAL)
        muHelp.AppendItem(muProgram)
        muHelp.AppendSeparator()
        muProgram = wx.MenuItem(muHelp, ID_HELP, " α׷", "", wx.ITEM_NORMAL)
        muHelp.AppendItem(muProgram)
        self.mainMenuBar.Append(muHelp, "")
        # ޴ ̺Ʈ 
        wx.EVT_MENU(self, ID_SAVE, self.OnSave) # 
        wx.EVT_MENU(self, ID_EXIT, self.OnExit) # 

        sites = RESOURCES.items()
        for sitename, site in sites:
            items = site.items()
            items.sort()
            for key, res in items:
                wx.EVT_MENU(self, key, self.OnConnect)

        wx.EVT_MENU(self, ID_KEY_HELP, self.OnKeyHelp) # Ű...
        wx.EVT_MENU(self, ID_HELP, self.OnHelp) #  α׷...
        # Menu Bar end
        self.MainStatusBar = self.CreateStatusBar(2, 0)
        
        # Tool Bar
        self.mainToolBar = wx.ToolBar(self, -1)
        self.SetToolBar(self.mainToolBar)
        self.mainToolBar.AddSimpleTool(ID_NEXT, wx.ArtProvider_GetBitmap(wx.ART_GO_BACK, wx.ART_OTHER, (16,16)), "")
        self.mainToolBar.AddSimpleTool(ID_PREVIOUS, wx.ArtProvider_GetBitmap(wx.ART_GO_FORWARD, wx.ART_OTHER, (16,16)), "ڷ")
        self.mainToolBar.AddSeparator()
        self.mainToolBar.AddSimpleTool(ID_RELOAD, wx.ArtProvider_GetBitmap(wx.ART_EXECUTABLE_FILE, wx.ART_OTHER, (16,16)), " ΰħ")
        self.mainToolBar.AddSeparator()
        self.mainToolBar.AddSimpleTool(ID_SAVE, wx.ArtProvider_GetBitmap(wx.ART_FOLDER, wx.ART_OTHER, (16,16)), "̹ ")
        # Tool Bar event 
        wx.EVT_TOOL(self,ID_SAVE, self.OnSave)
        wx.EVT_TOOL(self,ID_NEXT, self.OnNext)
        wx.EVT_TOOL(self,ID_PREVIOUS, self.OnPrevious)
        wx.EVT_TOOL(self,ID_RELOAD, self.OnReload)
        # Tool Bar end
        
        # Panel
        self.panel = MainImagePanel(self, -1)
        #self.panel = MainIEHtmlPanel(self, -1)
        #self.panel = MainHtmlPanel(self, -1)
        
        # Key Event Regist
        wx.EVT_KEY_DOWN(self.panel.window, self.OnKeyDown)
        
        # Focus Event Regist
        wx.EVT_SET_FOCUS(self.panel.window, self.OnSetFocus)
        
        self.__set_properties()
        self.__do_layout()
        # end wxGlade
        
        # Ľ ̺Ʈ 
        self.Bind(EVT_UPDATE, self.OnUpdate)
        
        # ȭ  ׷ ȣ
        self.Bind(wx.EVT_SHOW, self.OnShow)
        # close box ȣ
        self.Bind(wx.EVT_CLOSE, self.OnExit)
    
    def __del__(self):
        if self.handler != None:
            self.handler.stop()
            self.handler = None
    
    def __set_properties(self):
        # begin wxGlade: MainFrame.__set_properties
        self.MainStatusBar.SetStatusWidths([-2, -1])
        # statusbar fields
        MainStatusBar_fields = ["Ready", "0"]
        for i in range(len(MainStatusBar_fields)):
            self.MainStatusBar.SetStatusText(MainStatusBar_fields[i], i)
        self.mainToolBar.Realize()
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: MainFrame.__do_layout
        pass
        # end wxGlade
    
    def OnSetFocus(self, event):
        pass
    
    def OnKeyDown(self, event):
        code = event.GetKeyCode();
        if not event.AltDown() and not event.ControlDown() and not event.ShiftDown():
            if code == wx.WXK_LEFT:
                self.OnNext(self)
            elif code == wx.WXK_RIGHT:
                self.OnPrevious(self)
            elif code == wx.WXK_F5:  # Reload(R)
                self.OnReload(self)
            elif code == wx.WXK_F4:  # Save(S)
                self.OnSave(self)
            elif code == wx.WXK_DOWN:
                self.panel.ScrollDown()
            elif code == wx.WXK_UP:
                self.panel.ScrollUp()
            elif code == wx.WXK_ADD or code == wx.WXK_NUMPAD_ADD: # (+) Ȯ
                self.panel.ScaleUp()
            elif code == wx.WXK_SUBTRACT or code == wx.WXK_NUMPAD_SUBTRACT: # (-) 
                self.panel.ScaleDown()
            elif code == wx.WXK_RETURN or code == wx.WXK_NUMPAD_ENTER: # (*) 
                self.panel.ScaleDefault()
            
    def setStatusText(self, text, idx = 0):
        self.MainStatusBar.SetStatusText(text, idx) 
    
    init = False
    def OnShow(self, event):
        if self.init == False:
            #  ѹ 
            self.type = RESOURCES.values()[0].keys()[0]
            self.handler = ImageHandler(self, self.getUrls(self.type))
            self.init = True

    def getUrls(self, type):
        for sitename, site in RESOURCES.items():
            for key, item in site.items():
                if key == type:
                    return item["urls"]
        return []
        
    def OnUpdate(self, event):
        self.SetTitle(self.title + " : " + 
            "[" + str(event.index + 1) + "/" + str(event.total) + "] - " + event.title)
        
    def OnConnect(self, event):
        if event.GetId() != self.type:
            self.type = event.GetId()
            self.handler.stop()
            self.handler = ImageHandler(self, self.getUrls(self.type))
    
    lock = False
    def OnNext(self, event):
        if self.lock:
            return
        self.lock = True
        try:
            try:
                title, image = self.handler.getNext()
                self.panel.setPageByImage(image)
            except Exception, why:
                self.showDialog("", why[0])
        finally:
            self.lock = False
    
    def OnPrevious(self, event):
        if self.lock:
            return
        self.lock = True
        try:
            #try:
            title, image = self.handler.getPrevious()
            self.panel.setPageByImage(image)
            #except Exception, why:
            #    self.showDialog("", why[0])
        finally:
            self.lock = False
            
    def OnReload(self, event):
        self.handler = ImageHandler(self, self.getUrls(self.type))

    def OnSave(self, event):
        imgurl = self.handler.getImageURL()
        filename = imgurl[imgurl.rfind("/")+1:imgurl.rfind(".")]
        if filename is not None and filename != "":
            strWildcard = "JPEG (*.jpg)|*.jpg|All files (*.*)|*.*"
            self.defaultDir=os.getcwd()
            dlg = wx.FileDialog(self, message="Save file as ...", defaultDir="", 
                defaultFile=filename, wildcard = strWildcard, style=wx.SAVE)
            dlg.SetFilterIndex(0)

            if dlg.ShowModal() == wx.ID_OK:
                path = dlg.GetPath()
                self.handler.saveImage(path)
            dlg.Destroy()
        else:
            self.showDialog("", " ̹ غ ʾҽϴ. :(")
        
    def OnExit(self, event):
        self.handler.stop()
        self.handler = None
        self.Destroy()
    
    def OnHelp(self, event):
        msg = '''<font size=-1>
<center><font color=red size=+1><b>Web Gallery Viewer</b></font> Դϴ.</center><br>
: '''+__version__+'''<br>
: <a href="http://blog.naver.com/94eun.do"><font color=blue>ȣ(94eun@naver.com)</font></a><br>
<br>
 α׷ Ʈ  <br>
̹ ִ α׷Դϴ.<br>
<br>
History<br>
- '''+__version__+'''<br>
 * ø <br>
 * ̹  RaySoda ߰<br>
 * Ű <br>
<br>
- 0.5.0<br>
 * Ȯ(+), (-)  ߰<br>
 * ̹ URL <br>
<br>
- 0.4.3<br>
 * Ű Ϻ <br>
<br>
- 0.4.2<br>
 * Ű ߰<br>
<br>
- 0.4.1<br>
 * 򸻳 ũ <br>
 *  ̹ ߰<br>
<br>
- 0.4.0<br>
 * ѱURL ̹ ֱ <br>
 * Ϻ JPEG  <br>
<br> 
- 0.3.0<br>
 *  Խù  ̹  ֱ<br>
 *  ̹ ũ ߰<br>
 *  <br>
<br>
- 0.2.0<br>
 * Viewer GUI  <br>
 <br>
- 0.1.0<br>
 * ̹ ٿε ܼ α׷<br>
</font>
'''

        dlg = HtmlDialog(self, -1, ' α׷...', msg)
        dlg.SetSizeWH(350, 300)
        dlg.CenterOnScreen()
        dlg.ShowModal()
    
    def OnKeyHelp(self, event):
        msg = '''<font size=-1>
<center><font color=red size=+1><b>Ű</b></font>  Դϴ.</center><br>
<br>
<center>
<table border=1>
<tr>
  <td width=70 align=center><font color=red></font></td>
  <td width=200></td>
</tr>
<tr>
  <td width=70 align=center><font color=red></font></td>
  <td width=200>ڷ</td>
</tr>
<tr>
  <td width=70 align=center><font color=red>+</font></td>
  <td width=200>Ȯ</td>
</tr>
<tr>
  <td width=70 align=center><font color=red>-</font></td>
  <td width=200></td>
</tr>
<tr>
  <td width=70 align=center><font color=red>Enter</font></td>
  <td width=200>ũ</td>
</tr>
<tr>
  <td width=70 align=center><font color=red>F5</font></td>
  <td width=200>ΰħ</td>
</tr>
<tr>
  <td width=70 align=center><font color=red>F4</font></td>
  <td width=200></td>
</tr>
</table>
</center>
</font>
'''

        dlg = HtmlDialog(self, -1, 'Ű', msg)
        dlg.SetSizeWH(350, 300)
        dlg.CenterOnScreen()
        dlg.ShowModal()
        
    def showDialog(self, title, content):
        dlg = wx.MessageDialog(self, content,
                               title,
                               wx.OK | wx.ICON_INFORMATION
                               #wx.YES_NO | wx.NO_DEFAULT | wx.CANCEL | wx.ICON_INFORMATION
                               ) 
        dlg.ShowModal()
        dlg.Destroy()
# end of class MainFrame

class PageNotFoundError(Exception): pass

class DataNotFoundError(Exception): pass

provider = wx.SimpleHelpProvider()
wx.HelpProvider_Set(provider)

class HtmlDialog(wx.Dialog):
    def __init__(self, parent, ID, title, body,
        size=wx.DefaultSize, pos=wx.DefaultPosition, style=wx.DEFAULT_DIALOG_STYLE):
        
        pre = wx.PreDialog()
        pre.SetExtraStyle(wx.DIALOG_EX_CONTEXTHELP)
        pre.Create(parent, ID, title, pos, size, style)
        self.PostCreate(pre)
        
        sizer = wx.BoxSizer(wx.VERTICAL)
        self.panel = MainHtmlPanel(self, -1)
        self.panel.setPage(body)
        self.panel.SetHelpText(" ݴϴ.")
        sizer.Add(self.panel, 1, wx.GROW|wx.ALIGN_CENTER|wx.ALL, 5)
        
        box = wx.BoxSizer(wx.HORIZONTAL)
        
        btn = wx.Button(self, wx.ID_OK, " OK ")
        btn.SetDefault()
        btn.SetHelpText("â ݽϴ.")
        box.Add(btn, 1, wx.GROW|wx.ALIGN_CENTER|wx.ALL, 5)

        sizer.Add(box, 0, wx.GROW|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)

        self.SetSizer(sizer)
        self.SetAutoLayout(True)
        sizer.Fit(self)


class LoginDialog(wx.Dialog):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self, id=-1, name='', parent=prnt,
              pos=wx.Point(529, 454), size=wx.Size(244, 126),
              style=wx.DEFAULT_DIALOG_STYLE, title='α')
        self.SetClientSize(wx.Size(236, 99))
        self.SetToolTipString('α')

        self.staticText1 = wx.StaticText(id=-1,
              label='̵', name='staticText1', parent=self,
              pos=wx.Point(9, 9), size=wx.Size(47, 14), style=0)

        self.staticText2 = wx.StaticText(id=-1,
              label='н', name='staticText2',
              parent=self, pos=wx.Point(8, 42), size=wx.Size(48, 14), style=0)

        self.txtId = wx.TextCtrl(id=-1, name='txtId',
              parent=self, pos=wx.Point(63, 5), size=wx.Size(168, 22), style=0,
              value='')

        self.txtPw = wx.TextCtrl(id=-1, name='txtPw',
              parent=self, pos=wx.Point(63, 37), size=wx.Size(168, 22), style=wx.TE_PASSWORD,
              value='')

        self.btnCancel = wx.Button(id=wx.ID_CANCEL, label='',
              name='btnCancel', parent=self, pos=wx.Point(74, 69),
              size=wx.Size(75, 24), style=0)

        self.btnOk = wx.Button(id=wx.ID_OK, label='Ȯ',
              name='btnOk', parent=self, pos=wx.Point(155, 69),
              size=wx.Size(75, 24), style=0)
        self.btnOk.SetDefault()
    
    def getInfo(self):
        return {'id' : self.txtId.GetValue(), 'pw' : self.txtPw.GetValue()}

    def __init__(self, parent):
        self._init_ctrls(parent)

class MainImagePanel(wx.ScrolledWindow):
    def __init__(self, parent, id):
        wx.Panel.__init__(self, parent, -1, style=wx.TAB_TRAVERSAL | wx.NO_FULL_REPAINT_ON_RESIZE | wx.SUNKEN_BORDER)
        self.parent = parent
        
        self.window = wx.ScrolledWindow(self, -1, style=wx.HSCROLL | wx.VSCROLL)
        
        self.box = wx.BoxSizer(wx.VERTICAL)
        self.box.Add(self.window, 1, wx.GROW)
        self.SetSizer(self.box)
        self.SetAutoLayout(True)
        
        self.window.SetBackgroundColour(wx.WHITE)
        self.image = None  # wxPython image
        wx.EVT_PAINT(self.window, self.OnPaint)
        #wx.EVT_EVT_LEFT_DOWN(self.window, self.OnLeftClicked)
        
        self.scales = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0]
        self.scaleIdx = 9
        self.bmp = None

    def setPageByImage(self, image):
        self.image = self.parent.handler.getImage(image)
        self.height = self.image.GetHeight()
        self.width = self.image.GetWidth()
        self.scaleIdx = 9
        self.setImage()
    
    def setImage(self):
        if self.image:
            img = self.image.Scale(self.width * self.scales[self.scaleIdx], 
                                    self.height * self.scales[self.scaleIdx])  # Ȯ  
            bmp = img.ConvertToBitmap()
            
            h = bmp.GetHeight()
            w = bmp.GetWidth()
            self.bmp = bmp
            self.window.SetScrollbars(1, 1, w + 10 * 2, h + 10 * 2)
            self.window.Refresh()
        
    def OnPaint(self, evt):
        dc = wx.PaintDC(self.window)
        self.window.PrepareDC(dc)
        if self.bmp:
            dc.DrawBitmap(self.bmp, 10, 10)
    
    def ScrollUp(self):
        self.window.ScrollLines(-20)
        
    def ScrollDown(self):
        self.window.ScrollLines(20)
        
    def ScaleUp(self):
        self.scaleIdx += 1
        # 8.0ٴ ũ  ʴ´.
        if self.scaleIdx >= len(self.scales):
            self.scaleIdx = len(self.scales) - 1
        self.parent.setStatusText(str(self.scales[self.scaleIdx]) + " Ȯ");
        self.setImage()
        
    def ScaleDown(self):
        self.scaleIdx -= 1
        # 0.125ٴ ۰  ʴ´.
        if self.scaleIdx  < 0:
            self.scaleIdx = 0
        self.parent.setStatusText(str(self.scales[self.scaleIdx]) + " ");
        self.setImage()
    
    def ScaleDefault(self):
        self.scaleIdx = 9
        self.parent.setStatusText(str(self.scales[self.scaleIdx]) + " ");
        self.setImage()

class MainHtmlPanel(wx.Panel):
    def __init__(self, parent, id):
        wx.Panel.__init__(self, parent, -1)

        self.window = MainHtmlWindow(self, -1)

        self.box = wx.BoxSizer(wx.VERTICAL)
        self.box.Add(self.window, 1, wx.GROW)
        self.SetSizer(self.box)
        self.SetAutoLayout(True)

    def setPageByImages(self, images):
        htm = "<html><body>"
        if len(images) > 0:
            for img in images:
                htm += "<b><a href='"+img+"'>Go Image >>></a></b><br><br>"
                htm += "<img src='"+img+"'><br><br>"
        else:
            htm += "This Article have not image. :)"
        htm += "</body></html>"
        self.window.SetPage(htm)

    def setPageByImage(self, image):
        #self.window.LoadPage(image)
        self.setPageByImages([image]);
    
    def setPage(self, body):
        htm = "<html><body>%s</body></html>" % body
        self.window.SetPage(htm)
    
    def ScrollUp(self):
        self.window.ScrollLines(-3)
        
    def ScrollDown(self):
        self.window.ScrollLines(3)

class MainIEHtmlPanel(wx.Panel):
    def __init__(self, parent, id):
        wx.Panel.__init__(self, parent, -1)

        self.window = iewin.IEHtmlWindow(self, -1, style = wx.NO_FULL_REPAINT_ON_RESIZE)
        self.box = wx.BoxSizer(wx.VERTICAL)
        self.box.Add(self.window, 1, wx.GROW)
        self.SetSizer(self.box)
        self.SetAutoLayout(True)
        print self.window
    
    def setPageByImage(self, image):
        self.window.Navigate(image)
    
    def ScrollUp(self):
        self.window.ScrollLines(-3)
        
    def ScrollDown(self):
        self.window.ScrollLines(3)

import win32com.client

class MainHtmlWindow(html.HtmlWindow):
    def __init__(self, parent, id):
        wx.InitAllImageHandlers()
        html.HtmlWindow.__init__(self, parent, id, style=wx.NO_FULL_REPAINT_ON_RESIZE | wx.SUNKEN_BORDER)
        
    def OnLinkClicked(self, link):
        ref = link.GetHref()
        ie = win32com.client.Dispatch("InternetExplorer.Application")
        ie.navigate(ref)
        ie.Visible = True

import re
import httplib
import cStringIO
import urllib

class ImageHandler:
    def __init__(self, frame, urls):
        self.frame = frame
        self.urls = urls
        self.page = urls["start_page"]
        self.currentImage = None
        self.images = []
        self.titles = []
        self.thread = None
        self.keepGoing = True
        self.isLoginSuccess = False
        self.connect()
        
    def connect(self):
        if self.isLoginSuccess == False and self.urls.has_key("login"):
            dlg = LoginDialog(self.frame)
            
            if dlg.ShowModal() == wx.ID_OK:
                info = dlg.getInfo()
                form = {self.urls["login"]["id_name"] : info["id"], self.urls["login"]["pw_name"] : info["pw"]}
                url = self.urls["login"]["url"] + urllib.urlencode(form)
                HttpUtil.getPage(url)
                self.isLoginSuccess = True
            dlg.Destroy()
            
        if self.thread == None or self.thread.isAlive() != True:
            #self.threadId = thread.start_new_thread(self._connect,())
            self.thread = threading.Thread(target=self._connect)
            self.thread.setDaemon(True)
            self.thread.setName("DCGVImageHandler")
            self.thread.start()
        
    def _connect(self):
        if (self.page < self.urls["start_page"]):
            self.page = self.urls["start_page"]
            raise PageNotFoundError, str(self.page) + "  ʴ  Դϴ."
        
        try:
            print "start.................................."
            self.getArticles()
            self.frame.setStatusText("Ľ Ϸ")
            self.page += 1
        except Exception, why:
            self.frame.showDialog("", why[0])
    
    def stop(self):
        self.keepGoing = False
        
    def getArticles(self):
        page_url = self.urls["page_url"].replace("##value##", str(self.page))
        res = HttpUtil.getPage(page_url)
        
        re_title = re.compile(self.urls["title_re"])
        titles = re_title.findall(res) # title Ʈ · ´.
        
        re_article = re.compile(self.urls["article_re"])
        articles = re_article.findall(res) # Artcle ȣ Ʈ · ´.
        print articles
        re_image = re.compile(self.urls["image_re"])
        self.keepGoing = True
        for article in articles:
            try:
                if self.keepGoing == False:
                    return
                    
                self.frame.setStatusText("page[" + str(self.page) + "] article[" + article + "] м")
                article_url = self.urls["article_url"].replace("##value##", article)
                res = HttpUtil.getPage(article_url)
                ma = re_image.findall(res)
                for img in ma:
                    if img[0:7] != 'http://':
                        if img[0] == '/':
                            img = article_url[0:article_url.find('/', 7)] + img
                        else:
                            img = article_url[0:article_url.rfind('/')] + '/' + img
                    print img
                    self.images.append(img)
                    self.titles.append(titles[articles.index(article)])
                self.frame.setStatusText(repr(len(self.images)), 1)
            except Exception, why:
                continue
        
    def getNext(self):
        if self.currentImage == None:
           self.currentImage = self.images[0];
        
        idx = self.images.index(self.currentImage)
        if idx == 0:
            raise DataNotFoundError, "   ̹Դϴ."
        
        idx = idx - 1    
        image = self.images[idx]
        tle = self.titles[idx]
        # ̺Ʈ ߻
        event = UpdateEvent(index = idx, total = len(self.images), title = tle)
        wx.PostEvent(self.frame, event)
        self.currentImage = image
        return tle, image
        
    def getPrevious(self):
        if self.currentImage == None:
           self.currentImage = self.images[0];
           
        idx = self.images.index(self.currentImage)
        if idx >= (len(self.images) - 10): # 10
            self.connect()
        
        if idx == len(self.images) - 1:
            raise DataNotFoundError, " ̹ غ  Ͽϴ. ø ٷ ֽʽÿ."
        
        idx += 1
        image = self.images[idx]
        tle = self.titles[idx]
        # ̺Ʈ ߻
        event = UpdateEvent(index = idx, total = len(self.images), title = tle)
        wx.PostEvent(self.frame, event)
        self.currentImage = image
        return tle, image
    
    def getImageURL(self):
        if self.currentImage <> None:
            return self.currentImage
        else:
            return ""
            
    def saveImage(self, filename):
        if self.currentImage <> None and len(self.images) > 0:
            img = self.getImage(self.currentImage)
            img.SaveFile(filename, wx.BITMAP_TYPE_JPEG)
        else:
            return ""
    
    def getImage(self, imgurl):
        data = HttpUtil.getPage(imgurl)
        stream = cStringIO.StringIO(data)
        img = wx.ImageFromStream(stream)
        return img

import urllib 
import urllib2 
import ClientCookie

class HttpUtil:
    def getPage(url):
        if not url.startswith("http://"):
            raise IOError("http://   ʾҽϴ.")
        p = url.find('/', 7)
        if p == -1:
            return ''
        else:
            request = urllib2.Request(url)
            response = ClientCookie.urlopen(request) 
            return response.read() 
        
    getPage = staticmethod(getPage) # static method 


class HttpUtil2:
    def getPage(url):
        if not url.startswith("http://"):
            raise IOError("http://   ʾҽϴ.")
        p = url.find('/', 7)
        if p == -1:
            return ''
        else:
            host = url[7:p]
            suburl = url[p:]

            con = httplib.HTTP(host)
            con.putrequest('GET', suburl)
            con.putheader('Host', host)
            con.putheader('Accept', 'application/x-shockwave-flash,text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,video/x-mng,image/png,image/jpeg,image/gif;q=0.2,*/*;q=0.1')
            con.putheader('Cache-Control', 'no-cache')
            con.endheaders()
            errcode, errmsg, headers = con.getreply()
            f = con.getfile()
            res = f.read()
            f.close()
            con.close()

            return res
    getPage = staticmethod(getPage) # static method 

class MyApp(wx.App):
    def OnInit(self):
        self.frame = MainFrame(None, -1)
        self.frame.Show()
        self.SetTopWindow(self.frame)
        return True

if __name__ == '__main__':
    app = MyApp(0)
    app.MainLoop()
