"""
YahooView.py by ddt<ddt@mirstyle.org>
license: GPL
"""
import os
import urllib
import HTMLParser
import re
import threading
import Queue

import gtk

import YahooDict
import DictResult
from Utils import ConnectException

class YahooView(HTMLParser.HTMLParser, threading.Thread):
    replace_list = ((re.compile("rgb\(00,80,00\)", re.I),'#008000'),
                    (re.compile(r"\n"),""),
                    (re.compile("<br>"),"\n"),
                    (re.compile("</?table[^>]*>"), ""),
                    (re.compile("</?td[^>]*>"), ""),
                    (re.compile("</?tr[^>]*>"), ""),
                    (re.compile("</?span[^>]*>"), ""),
                    (re.compile("</?p[^>]*>"), "\n"),
                    (re.compile("(&#[0-9]{1,5});?"), "\g<1>;")
                    )
    
    del_js_p = re.compile("\'([^']+)\'")
    
    def __init__(self, app, word, lang):
        self.app = app
        self.word = word
        self.lang = lang
        self.view = app.xml.get_widget("textview")
        self.buffer = self.view.get_buffer()
        self.font_tree = []
        self.link = ''
        self.on_b = False
        self.bold = self.buffer.create_tag()
        self.bold.set_property('weight',700)
        
        h = os.getenv('HOME')
        self.home = h+'/.gdick/'
        if not os.path.exists(self.home):
            os.mkdir(self.home)

        HTMLParser.HTMLParser.__init__(self)
        threading.Thread.__init__(self)

    def run(self):
        gtk.threads_enter()
        self.app.status_update("searching......")
        self.app.cursor_change(self.app.WAIT_CURSOR)
        gtk.threads_leave()
        try:
            r = YahooDict.YahooDict().search(self.word, self.lang)
        except ConnectException:
            gtk.threads_enter()
            self.app.status_update("connection error. try again")
            self.app.cursor_change(self.app.DEFAULT_CURSOR)
            gtk.threads_leave()
        else:
            gtk.threads_enter()
            self.show(r)
            self.app.status_update("done")
            self.app.cursor_change(self.app.DEFAULT_CURSOR)
            gtk.threads_leave()
    
    def show(self, result):
        model = self.app.treeview.get_model()
        
        gtk.threads_enter()
        model.clear()
        gtk.threads_leave()
        
        html_data = result.getResult()
        sameWords = result.getSameWords()
        for p, s in self.replace_list:
            html_data = p.sub(s, html_data)
        html_data= unicode(html_data, 'euc-kr','ignore')
        
        gtk.threads_enter()
        start = self.buffer.get_start_iter()
        self.buffer.insert(start, '\n') # margin
        try:
            self.feed(html_data)
            self.close()
        except HTMLParser.HTMLParseError:
            pass
        size = self.app.win.get_size()
        if len(sameWords) > 0:
            self.showSameWords(sameWords)
            self.app.paned.set_position(size[0]-100)
            self.app.sameWordsShow = True
        else:
            self.app.paned.set_position(size[0])
            self.app.sameWordsShow = False
        gtk.threads_leave()

    def showSameWords(self, words):
        model = self.app.treeview.get_model()
        for word in words:
            iter = model.append()
            gtk.threads_enter()
            model.set_value(iter, 0, word)
            gtk.threads_leave()
    
    def download(self,url):
        name = self.home + os.path.basename(url)
        if not os.path.exists(name):
            f = open(name,'w')
            data = urllib.urlopen(url).read()
            f.write(data)
            f.close()
            os.system("convert -draw 'matte 0,0 replace' " + name + " "+ name)
        pixbuf = gtk.gdk.pixbuf_new_from_file(name)
        end = self.buffer.get_end_iter()
        self.buffer.insert_pixbuf(end, pixbuf)

    # HTMLParse methods
    def handle_starttag(self, name, attrs):
        if name == 'font':
            tag = self.buffer.create_tag()
            for attr, value in attrs:
                if attr == 'color':
                    tag.set_property('foreground',value)
            self.font_tree.append(tag)
        elif name == 'b':
            self.on_b = True
        else:
            for attr, value in attrs:
                if attr == 'href':
                    m = self.del_js_p.findall(value)
                    if m:
                        self.link = m[-1]
                    break
                elif attr == 'src':
                    self.download(value)
                    break

    def handle_endtag(self, tag):
        if tag == 'a':
            self.link = ''
        elif tag == 'font':
            try:
                del self.font_tree[-1]
            except IndexError: # malformed html :(
                pass
        elif tag == 'b':
            self.on_b = False

    def handle_data(self, data):
        end = self.buffer.get_end_iter()
        if self.link:
            tag = self.buffer.create_tag()
            tag.set_data("url", self.link)
            self.buffer.insert_with_tags(end, data, tag)
        elif self.font_tree != []:
            tag = self.font_tree[-1]
            self.buffer.insert_with_tags(end, data, tag)
        elif self.on_b:
            self.buffer.insert_with_tags(end, data, self.bold)
        else:
            self.buffer.insert(end, data)

    def handle_charref(self, name):
        end = self.buffer.get_end_iter()
        self.buffer.insert(end, unichr(int(name)))

    def handle_entityref(self, name):
        end = self.buffer.get_end_iter()
        if name == 'nbsp':
            self.buffer.insert(end, ' ')
