/*
 * Decompiled with CFR 0.152.
 */
package iiixzu.help.web;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;

public class Request
implements Serializable {
    private static final long serialVersionUID = 4334241447452522460L;
    private String contentType;
    private String method;
    private String servletPath;
    private String queryString;
    private String remoteHost;
    private String remoteAddr;
    private int remotePort;
    private Map parameterMap;
    private Map queryStringMap;
    private Map fileMap;

    public Request(HttpServletRequest request) throws Exception {
        this.contentType = request.getContentType();
        if (this.contentType != null) {
            this.contentType = this.contentType.toLowerCase();
        }
        this.method = request.getMethod();
        this.servletPath = "";
        this.queryString = "";
        this.parameterMap = new HashMap();
        this.queryStringMap = new HashMap();
        this.fileMap = new HashMap();
        if (this.contentType != null && this.contentType.startsWith("multipart")) {
            DiskFileUpload fileUpload = new DiskFileUpload();
            List list = fileUpload.parseRequest(request);
            FileItem formField = null;
            int i = 0;
            while (i < list.size()) {
                formField = (FileItem)list.get(i);
                if (formField.isFormField()) {
                    this.parameterMap.put(formField.getFieldName(), formField.getString());
                } else {
                    this.fileMap.put(formField.getName(), formField.get());
                }
                ++i;
            }
            this.servletPath = request.getServletPath();
            this.queryString = request.getQueryString();
            this.remotePort = request.getLocalPort();
            this.remoteHost = request.getRemoteHost();
            this.remoteAddr = request.getRemoteAddr();
        } else if (this.method.equals("POST")) {
            this.servletPath = request.getServletPath();
            this.queryString = request.getQueryString();
            this.remotePort = request.getRemotePort();
            this.remoteHost = request.getRemoteHost();
            this.remoteAddr = request.getRemoteAddr();
            this.parameterMap = new HashMap();
            Enumeration e = request.getParameterNames();
            String key = null;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                this.parameterMap.put(key, request.getParameter(key));
            }
        } else if (this.method.equals("GET")) {
            this.servletPath = request.getServletPath();
            this.queryString = request.getQueryString();
            this.remotePort = request.getRemotePort();
            this.remoteHost = request.getRemoteHost();
            this.remoteAddr = request.getRemoteAddr();
        }
        String string = this.queryString = this.queryString == null ? "" : this.queryString;
        if (!this.queryString.equals("")) {
            String[] temp = this.queryString.split("&");
            String[] temp2 = null;
            int i = 0;
            while (i < temp.length) {
                temp2 = temp[i].split("=");
                if (temp2.length == 1) {
                    this.queryStringMap.put(temp2[0], "");
                } else {
                    this.queryStringMap.put(temp2[0], temp2[1]);
                }
                ++i;
            }
        }
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getQuerystring() {
        return this.queryString;
    }

    public Map getParameterMap() {
        HashMap temp = new HashMap();
        temp.putAll(this.parameterMap);
        temp.putAll(this.queryStringMap);
        return temp;
    }

    public String getParameter(String s) {
        String returnValue = null;
        returnValue = (String)this.parameterMap.get(s);
        if (returnValue == null) {
            return (String)this.queryStringMap.get(s);
        }
        return returnValue;
    }

    public Map getFileMap() {
        return this.fileMap;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getMethod() {
        return this.method;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setContentType(String s) {
        this.contentType = s;
    }

    public void setMethod(String s) {
        this.method = s;
    }

    public void setServletPath(String s) {
        this.servletPath = s;
    }

    public void addParameter(String key, String value) {
        this.parameterMap.put(key, value);
    }

    public void addQueryString(String key, String value) {
        this.queryStringMap.put(key, value);
    }

    public void addFile(String fileName, byte[] file) {
        this.fileMap.put(fileName, file);
    }
}

