/*
    sayclubaccount.h - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef SAYCLUBACCOUNT_H
#define SAYCLUBACCOUNT_H

#include <cstring>

#include <qmap.h>

#include <kopetepasswordedaccount.h>

#include "sayclubutilities.h"

#define REMOVEREQ(i) m_server->m_objectList.remove( i ); \
m_server->m_signalList.remove( i );

#define SERVERADDR "chatd.sayclub.com"

using namespace std;

class PHPObject;
class PHPMapObject;

class KActionMenu;
namespace Kopete {
	class Contact;
	class Group;
	class MetaContact;
	class OnlineStatus;
}

class SayclubContact;
class SayclubProtocol;
class SayclubServer;

class QTextCodec;

class SayclubAccount : public Kopete::PasswordedAccount
{
	Q_OBJECT
public:
	SayclubAccount( SayclubProtocol *parent, const QString& accountID, const char *name = 0 );
	~SayclubAccount();
	
	enum ErrorType { ErrorNormal, ErrorInternal, ErrorInformation, ErrorSorry };
	
	virtual KActionMenu* actionMenu();
	virtual bool createContact(const QString& contactId, Kopete::MetaContact* parentContact);
	SayclubServer* server();
	
	QTextCodec* getCodec() { return m_krcodec; }
	
	QMap<QString, Kopete::Group*> m_groupList;
	
signals:
	void errorMessage( int id, const QString &msg );
	void closeSocket();
	void statusChanged( const Kopete::OnlineStatus &o );
	
public slots:
	virtual void setOnlineStatus(const Kopete::OnlineStatus &status , const QString &reason = QString::null);
	virtual void connectWithPassword( const QString &password );
	virtual void disconnect();
	//virtual void setAway( bool isAway, const QString &awayMessage = QString::null );
	void slotErrorMessageReceived( int type, const QString &msg );
	void slotChangeStatus( const Kopete::OnlineStatus &o );
	void slotChangeAllStatus( const Kopete::OnlineStatus &o );
	void slotChangeContactLoginStatus( PHPMapObject &m );
	void slotChangeContactStatus( PHPMapObject &m );
	void slotIncomingMemo( PHPMapObject &m );
	void slotDisposeRequest( int rq );
	
protected:
	void updateContactStatus();
	SayclubServer* m_server;
	Kopete::OnlineStatus m_connectstatus;
	
protected slots:
	
private:
	int getErrorCode( const PHPObject &o );
	SayclubContact* getContactByMsrl( QString msrl );
	void requestAddFriend( QString id, QString desc, QString group );
	string statusToId( Kopete::OnlineStatus &status );
	
	bool m_connected;
	bool m_away;
	Kopete::OnlineStatus m_oldStatus;
	QString m_id;
	QString m_password;
	QString m_key;
	int m_keyno;
	QString m_uuid;
	QString m_ipaddr;
	QString m_macaddr;
	
	QTextCodec *m_krcodec;
	
private slots:
	// authentication
	void slotNegotiate();
	void slotAuthenticate();
	void slotParseAuthenticationResult( int rq );
	void slotFetchBuddyList( int rq );
	
	// session
	void slotSyncAddGroup( Kopete::Group *g );
	void slotSyncAddGroupResponse( int rq );
	void slotRequestAddFriendResponse( int rq );
	void slotSendMessage( int rq );
};

#endif
