/*
    sayclubprotocol.h - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef SAYCLUBPROTOCOL_H
#define SAYCLUBPROTOCOL_H

#include <kopeteprotocol.h>
#include <kopetecontactproperty.h>


class SayclubProtocol : public Kopete::Protocol
{
	Q_OBJECT
public:
	SayclubProtocol(QObject *parent, const char *name, const QStringList &args);
    ~SayclubProtocol();
	virtual Kopete::Contact *deserializeContact(Kopete::MetaContact *metaContact, const QMap< QString, QString > & serializedData, const QMap< QString, QString > & addressBookData);
	virtual AddContactPage * createAddContactWidget( QWidget *parent, Kopete::Account *account );
	virtual KopeteEditAccountWidget * createEditAccountWidget( Kopete::Account *account, QWidget *parent );
	virtual Kopete::Account * createNewAccount( const QString &accountId );
	static SayclubProtocol *protocol();
	
	const Kopete::OnlineStatus sayclubOnline;
	const Kopete::OnlineStatus sayclubAway;
	const Kopete::OnlineStatus sayclubBusy;
	const Kopete::OnlineStatus sayclubOffline;
	const Kopete::OnlineStatus statConnecting;
	
	const Kopete::ContactPropertyTmpl propMsrl;
	const Kopete::ContactPropertyTmpl propMyDesc;
	const Kopete::ContactPropertyTmpl propPersonalMessage;
	
protected:
	static SayclubProtocol *s_protocol;
};

#endif
