/*
 * TokigunStudio Gaea Library: Union
 * Copyright (c) 2005-2006, Kang Seonghoon (Tokigun).
 * This library can be distributed under the terms of the GNU LGPL.
 */

/*
 * TokigunStudio Gaea Library: Union
 * Copyright (c) 2005-2006, Kang Seonghoon (Tokigun).
 * This library can be distributed under the terms of the GNU LGPL.
 */

#ifndef _GAEA_UNION_H_
#define _GAEA_UNION_H_

#include <iostream>

namespace _union_detail {
	class UnionDummy {
		public:
			friend std::ostream& operator<<(std::ostream& out, const UnionDummy& /*other*/)
			{
				return out;
			}
	};

	class UnionDummy1: public UnionDummy {};
	class UnionDummy2: public UnionDummy {};
	class UnionDummy3: public UnionDummy {};
	class UnionDummy4: public UnionDummy {};
	class UnionDummy5: public UnionDummy {};
}

#define PARENT Union<A,B,C,D,E>
#define TEMPLATE template <class A, class B, class C, class D, class E>
template <
	class A = _union_detail::UnionDummy1,
	class B = _union_detail::UnionDummy2,
	class C = _union_detail::UnionDummy3,
	class D = _union_detail::UnionDummy4,
	class E = _union_detail::UnionDummy5
			>
			class Union
{
	public:
		Union(): type_(0) {}
		Union(const PARENT& other);
		~Union() { clear(); }

		explicit Union(const A& other): type_(1), value_(other) {}
		explicit Union(const B& other): type_(2), value_(other) {}
		explicit Union(const C& other): type_(3), value_(other) {}
		explicit Union(const D& other): type_(4), value_(other) {}
		explicit Union(const E& other): type_(5), value_(other) {}

		void clear();

		int getType() const { return type_; }

		const void *getPointer() const { return value_.a; }

		operator A() const { if (type_ != 1) throw std::bad_cast(); return (A)value_; }
		operator B() const { if (type_ != 2) throw std::bad_cast(); return (B)value_; }
		operator C() const { if (type_ != 3) throw std::bad_cast(); return (C)value_; }
		operator D() const { if (type_ != 4) throw std::bad_cast(); return (D)value_; }
		operator E() const { if (type_ != 5) throw std::bad_cast(); return (E)value_; }

	private:
		template <class T, int typeN>
				const PARENT& _imp_operator_eq(const T& other);

	public:
		const PARENT& operator=(const A& other) { return _imp_operator_eq<A,1>(other); }
		const PARENT& operator=(const B& other) { return _imp_operator_eq<B,2>(other); }
		const PARENT& operator=(const C& other) { return _imp_operator_eq<C,3>(other); }
		const PARENT& operator=(const D& other) { return _imp_operator_eq<D,4>(other); }
		const PARENT& operator=(const E& other) { return _imp_operator_eq<E,5>(other); }
		const PARENT& operator=(const PARENT& other);

		friend std::ostream& operator<<(std::ostream& out, const PARENT& other)
		{
			switch (other.type_) {
				case 1: return (out << (A)other.value_);
				case 2: return (out << (B)other.value_);
				case 3: return (out << (C)other.value_);
				case 4: return (out << (D)other.value_);
				case 5: return (out << (E)other.value_);
				default: return (out << "(null)");
			}
		}

	private:
		unsigned int type_;
		union value_t
		{
			value_t() {}

			value_t(const A& other) { new (reinterpret_cast<A*>(a)) A(other); }
			value_t(const B& other) { new (reinterpret_cast<B*>(b)) B(other); }
			value_t(const C& other) { new (reinterpret_cast<C*>(c)) C(other); }
			value_t(const D& other) { new (reinterpret_cast<D*>(d)) D(other); }
			value_t(const E& other) { new (reinterpret_cast<E*>(e)) E(other); }

			operator A() const { return *(A*)a; }
			operator B() const { return *(B*)b; }
			operator C() const { return *(C*)c; }
			operator D() const { return *(D*)d; }
			operator E() const { return *(E*)e; }

			char a[sizeof(A) + !sizeof(A)];
			char b[sizeof(B) + !sizeof(B)];
			char c[sizeof(C) + !sizeof(C)];
			char d[sizeof(D) + !sizeof(D)];
			char e[sizeof(E) + !sizeof(E)];
		} value_;
};

TEMPLATE PARENT::Union(const PARENT& other): type_(other.type_)
{
	switch (type_) {
		case 1: new (&value_) value_t(*(A*)other.value_.a); break;
		case 2: new (&value_) value_t(*(B*)other.value_.b); break;
		case 3: new (&value_) value_t(*(C*)other.value_.c); break;
		case 4: new (&value_) value_t(*(D*)other.value_.d); break;
		case 5: new (&value_) value_t(*(E*)other.value_.e); break;
	}
}

TEMPLATE void PARENT::clear()
{
	switch (type_) {
		case 1: reinterpret_cast<A*>(value_.a)->~A(); break;
		case 2: reinterpret_cast<B*>(value_.b)->~B(); break;
		case 3: reinterpret_cast<C*>(value_.c)->~C(); break;
		case 4: reinterpret_cast<D*>(value_.d)->~D(); break;
		case 5: reinterpret_cast<E*>(value_.e)->~E(); break;
	}
	type_ = 0;
}

TEMPLATE template <class T, int typeN>
		const PARENT& PARENT::_imp_operator_eq(const T& other)
{
	if (type_ == typeN) {
		*(T*)&value_ = other;
	} else {
		clear();
		type_ = typeN;
		new (&value_) value_t(other);
	}
	return *this;
}

TEMPLATE const PARENT& PARENT::operator=(const PARENT& other)
{
	if (&other != this) {
		if (type_ == other.type_) {
			switch (type_) {
				case 1: *(A*)value_.a = *(A*)other.value_.a; break;
				case 2: *(B*)value_.b = *(B*)other.value_.b; break;
				case 3: *(C*)value_.c = *(C*)other.value_.c; break;
				case 4: *(D*)value_.d = *(D*)other.value_.d; break;
				case 5: *(E*)value_.e = *(E*)other.value_.e; break;
			}
		} else {
			clear();
			switch (type_ = other.type_) {
				case 1: new (&value_) A(*(A*)other.value_.a); break;
				case 2: new (&value_) B(*(B*)other.value_.b); break;
				case 3: new (&value_) C(*(C*)other.value_.c); break;
				case 4: new (&value_) D(*(D*)other.value_.d); break;
				case 5: new (&value_) E(*(E*)other.value_.e); break;
			}
		}
	}
	return *this;
}
#undef PARENT

#endif /* !_GAEA_UNION_H_ */
