/*
    sayclubserver.h - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef SAYCLUBSERVER_H
#define SAYCLUBSERVER_H

#include <qobject.h>
#include <qdatastream.h>
#include <qptrlist.h>
#include <qvaluelist.h>
#include <qintdict.h>

#include <kopeteonlinestatus.h>
#include <kopeteaccount.h>

#define HAS_KEY(o, k) (o.find(k)!=o.end())

namespace KNetwork {
	class KBufferedSocket;
}
namespace Kopete {
	class Contact;
	class Message;
}

class QSignal;

class SayclubAccount;
class PHPObject;
class PHPMapObject;

class SayclubServer : public QObject
{
	Q_OBJECT
	
public:
	SayclubServer( SayclubAccount *account, QObject *parent = 0L );
	~SayclubServer();
	
	void readBlock( uint len );
	void write( QCString str );
	
	int sendCmd( QCString cmdname, PHPObject &array, QObject *receiver=NULL, const char *member=NULL );
	
	bool isValid() { return m_valid; }
	
	enum OnlineStatus { Connecting, Connected, Disconnecting, Disconnected };
	enum ErrorType { ErrorNormal, ErrorInternal, ErrorInformation, ErrorSorry };
	OnlineStatus onlineStatus() { return m_onlineStatus; }
	
	void setOnlineStatus( OnlineStatus status );
	
	QIntDict<QCString> m_requestQueue;
	QIntDict<PHPObject> m_objectList;
	QIntDict<QSignal> m_signalList;
	QIntDict<Kopete::Contact> m_contactList;
	QIntDict<Kopete::Message> m_messageList;
	
	QString m_p_myip;
	uint m_p_myport;
	uint m_p_udpport;
	uint m_p_svrtime;
	
	virtual void bytesReceived( const QByteArray & );
	
public slots:
	void incomingMessage( QString message );
	
	void connect( const QString &server, uint port );
	void disconnect();
	void slotReadyWrite();
	
signals:
	void messageReceived( const QString &message );
	void blockRead( const QByteArray &block );
	void onlineStatusChanged( SayclubServer::OnlineStatus status );
	void connectionFailed();
	void socketClosed();
	void errorMessage( int id, const QString &msg );
	void receivedHello();
	void endNegotiation();
	void closeSocket();
	void changeAllContacts( const Kopete::OnlineStatus &o );
	void accountClosed( Kopete::Account::DisconnectReason reason );
	
	void changeContactLoginStatus( PHPMapObject &m );
	void changeContactStatus( PHPMapObject &m );
	void incomingMemo( PHPMapObject &m );
	
private slots:
	// sockets
	void slotDataReceived();
	void slotSocketError( int error );
	void slotConnectionSuccess();
	void slotHostFound();
	void slotReadLine();
	void slotSocketClosed();
	void slotSocketClose();
	
private:
	Kopete::OnlineStatus m_newstatus;
	SayclubAccount *m_account;
	
	void invalidate() { m_valid = false; }
	
	bool pollReadBlock();
	void parseLine( const QString &str );
	void parseNotification( const PHPObject &o );
	
	KNetwork::KBufferedSocket *m_socket;
	OnlineStatus m_onlineStatus;
	QString m_server;
	uint m_port;
	
	uint m_waitBlockSize;
	QValueList<QByteArray> m_sendQueue;
	
	bool m_valid;
	bool m_peerswitched;
	
	class Buffer : public QByteArray
	{
	public:
		Buffer( unsigned size = 0 );
		~Buffer();
		void add( char *str, unsigned size );
		QByteArray take( unsigned size );
	};
	Buffer m_buffer;
};

#endif
