package unisql.itrack;

import com.oreilly.servlet.multipart.*;
import java.io.File;

public class ITrackFileRenamePolicy implements FileRenamePolicy {

/*=======================================================================
 |      PRIVATE VARIABLES
 =======================================================================*/

private String prefix;

/*=======================================================================
 |      CONSTRUCTOR
 =======================================================================*/

public ITrackFileRenamePolicy(String dir, String userid)
{ 
  prefix = dir + "/" + userid;
}

/*=======================================================================
 |      PUBLIC METHODS
 =======================================================================*/

public File rename(File f)
{
  String filename;
  filename = prefix + "." + System.currentTimeMillis() + "." + f.getName() + ".tmp";
  return (new File(filename));
}

}
