package unisql.itrack;

import java.io.*;

public class ITrackSearchForm {

/*=======================================================================
 |      PRIVATE VARIABLES
 =======================================================================*/

private final static int currentFormatVersion = 1;

private Integer formatVersion;

/*=======================================================================
 |      PACKAGE ACCESS VARIABLES
 =======================================================================*/

String[]  selectList;
String[][] whereCondition;
String[][]  orderbyList;

/*=======================================================================
 |      CONSTRUCTOR
 =======================================================================*/

public ITrackSearchForm(String[] selectList, String[][] whereCondition, String[][] orderbyList)
{
  this.formatVersion = new Integer(currentFormatVersion);
  this.selectList = selectList;
  this.whereCondition = whereCondition;
  this.orderbyList = orderbyList;
}

/*=======================================================================
 |      PACKAGE ACCESS METHODS
 =======================================================================*/

boolean isSelectField(String name)
{
  if (selectList == null)
    return false;

  for (int i=0 ; i < selectList.length ; i++) {
    if (selectList[i].equals(name))
      return true;
  }

  return false;
}

int getWhereConditionCount()
{
  if (whereCondition == null)
    return 0;

  return whereCondition.length;
}

int getOrderbyCount()
{
  if (orderbyList == null)
    return 0;
  return orderbyList.length;
}

String getOrderbyAttr(int index)
{
  if (orderbyList == null || index >= orderbyList.length)
    return null;
  return orderbyList[index][0];
}

String getOrderbyAsc(int index)
{
  if (orderbyList == null || index >= orderbyList.length)
    return null;
  return orderbyList[index][1];
}

String getWhereCondConj(int index)
{
  if (whereCondition == null || index >= whereCondition.length)
    return null;
  return whereCondition[index][0];
}

String getWhereCondAttr(int index)
{
  if (whereCondition == null || index >= whereCondition.length)
    return null;
  return whereCondition[index][1];
}

String getWhereCondOp(int index)
{
  if (whereCondition == null || index >= whereCondition.length)
    return null;
  return whereCondition[index][2];
}

String getWhereCondValue(int index)
{
  if (whereCondition == null || index >= whereCondition.length ||
      whereCondition[index][3] == null)
    return "";

  return whereCondition[index][3];
}

void save(String filename)
        throws IOException
{
  FileOutputStream fo = new FileOutputStream(filename);
  ObjectOutputStream oo = new ObjectOutputStream(fo);

  oo.writeObject(formatVersion);
  oo.writeObject(selectList);
  oo.writeObject(whereCondition);
  oo.writeObject(orderbyList);

  oo.close();
  fo.close();
}

static ITrackSearchForm load(String filename)
        throws IOException, ClassNotFoundException
{
  File f = new File(filename);
  if (!f.exists())
    return null;

  FileInputStream fi = new FileInputStream(filename);
  ObjectInputStream oi = new ObjectInputStream(fi);

  Integer version = (Integer) oi.readObject();
  if (version.intValue() != currentFormatVersion) {
    throw new ITrackException("   ϴ");
  }
  String[] select = (String[]) oi.readObject();
  String[][] where = (String[][]) oi.readObject();
  String[][] orderby = (String[][]) oi.readObject();

  oi.close();
  fi.close();

  return (new ITrackSearchForm(select, where, orderby));
}

/*=======================================================================
 |      PRIVATE METHODS
 =======================================================================*/

}
