<%@ page contentType="text/html;charset=euc-kr" session="true" %>
<%@ page import="java.sql.*" %>
<%@ page import="java.net.*" %>
<%@ page import="unisql.itrack.*" %>
<%@ page import="com.oreilly.servlet.MultipartRequest" %>
<% request.setCharacterEncoding("euc-kr"); %>
<% response.setHeader("Cache-Control","No-cache");
%>

<% ITrackHTML.Head(out, "ITrack");  %>

<BODY>

<%
  String working_table = (String) session.getAttribute(ITrackJsp.SESSION_KEY_WORKING_TABLE);
  String userid = (String) session.getAttribute(ITrackJsp.SESSION_KEY_USERID);
  String username = (String) session.getAttribute(ITrackJsp.SESSION_KEY_USERNAME);
  String info_table = (String) session.getAttribute(ITrackJsp.SESSION_KEY_INFO_TABLE); 
  if (userid == null) {
    ITrackHTML.writeErrorMsg(out, ITrackMsg.session_invalid);
    return;
  } 
  ITrackIssueInfo[] issueInfoArr = ITrackIssueInfo.getIssueInfoArray(info_table);

  String[] idArr;
  String tmpDir = ITrackFile.getFileUploadTmpDir();
  MultipartRequest mReq = new MultipartRequest(request, tmpDir, request.getContentLength(), "euc-kr", new ITrackFileRenamePolicy(tmpDir, userid));

  try {
    idArr = ITrackJsp.remakeIdArr(mReq.getParameterValues("id"));
    if (idArr == null || idArr.length == 0) {
      ITrackHTML.writeErrorMsg(out, ITrackMsg.invalid_url);
      return;
    }

    String msg;
    String opcode = mReq.getParameter("opcode");
    if (opcode == null)
      opcode = "";

    int action;
    if (opcode.equals("reopen")) {
      msg = "̰";
      action = ITrackJsp.ITRACK_REOPEN;
    }
    else if (opcode.equals("resolve")) {
      msg = "ذ";
      action = ITrackJsp.ITRACK_RESOLVE;
    }
    else if (opcode.equals("close")) {
      msg = "";
      action = ITrackJsp.ITRACK_CLOSE;
    }
    else {
      msg = "";
      action = ITrackJsp.ITRACK_NONE;
    }

    if (idArr.length > 1)
      msg = "׷ " + msg;

    String mailto;

    try {
      mailto = ITrackIssueInfo.updateIssue(issueInfoArr, mReq, username, working_table, idArr, msg, action);
    } catch (ITrackException e) {
      ITrackHTML.writeErrorMsg(out, e.getMessage());
      return;
    }

    String emailaddr = ITrackDB.getMailAddress(mailto);
    StringBuffer mailContent = new StringBuffer("");
    String ids = ITrackDB.appendMailContent(mailContent, working_table, idArr);
    ITrackJsp.sendMail(username, emailaddr, "[ITrack] " + ids + "̽  : " + mReq.getParameter("title"), mailContent.toString());
  } finally {
    ITrackJsp.deleteTmpUploadFiles(mReq);
  }

  ITrackJsp.redirect(response, ITrackJsp.makeDetailViewURL(idArr));
%>  

