/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jmassmailer.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import net.kldp.jmassmailer.data.DbHandler;
import net.kldp.jmassmailer.data.Importer;
import net.kldp.jmassmailer.data.PeopleList;
import net.kldp.jmassmailer.data.PeopleListObserver;

public class ExcelImporterView {
    private DbHandler db;
    private Importer controller;
    private JFrame root;
    private JDialog importerDialog;
    private JComboBox tablesForNameCombo;
    private JComboBox tablesForEmailCombo;
    private JComboBox columnsForNameCombo;
    private JComboBox columnsForEmailCombo;
    private ArrayList peopleListObservers;
    private PeopleList people;

    public ExcelImporterView(DbHandler db, Importer controller, JFrame root) {
        this.db = db;
        this.controller = controller;
        this.peopleListObservers = new ArrayList();
    }

    public void createView() {
        this.importerDialog = new JDialog((Frame)this.root, "\uc5d1\uc140 \ud30c\uc77c\ub85c\ubd80\ud130 \ub370\uc774\ud130 \ubd88\ub7ec\uc624\uae30");
        this.importerDialog.setSize(400, 250);
        Dimension dim = this.importerDialog.getToolkit().getScreenSize();
        this.importerDialog.setLocation(dim.width / 2 - this.importerDialog.getWidth() / 2, dim.height / 2 - this.importerDialog.getHeight() / 2);
        String[] tables = null;
        try {
            tables = this.db.getTables();
            this.tablesForNameCombo = new JComboBox<String>(tables);
            this.tablesForNameCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox source = (JComboBox)e.getSource();
                    ExcelImporterView.this.comboStateChanged(ExcelImporterView.this.columnsForNameCombo, (String)source.getSelectedItem());
                }
            });
            this.tablesForEmailCombo = new JComboBox<String>(tables);
            this.tablesForEmailCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox source = (JComboBox)e.getSource();
                    ExcelImporterView.this.comboStateChanged(ExcelImporterView.this.columnsForEmailCombo, (String)source.getSelectedItem());
                }
            });
            this.columnsForNameCombo = new JComboBox<String>(this.db.getHeaderColumns(tables[0]));
            this.columnsForEmailCombo = new JComboBox<String>(this.db.getHeaderColumns(tables[0]));
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this.importerDialog, e.getMessage(), "Error", 0);
        }
        this.importerDialog.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        JTextArea descLabel = new JTextArea("\uc120\ud0dd\ub41c \uc5d1\uc140 \ud30c\uc77c\uc5d0\ub294 \ub2e4\uc74c\uacfc \uac19\uc740 \uc6cc\ud06c\uc2dc\ud2b8\uc640 \uac01 \uc6cc\ud06c\uc2dc\ud2b8\uc758 \uccab \ud589\uc774 \uc788\uc2b5\ub2c8\ub2e4. \uba54\uc77c\uc744 \ubc1b\uc744 \uc0ac\ub78c\ub4e4\uc758 \uc774\ub984\uacfc \uc774\uba54\uc77c \uc8fc\uc18c\ub97c \ub098\ud0c0\ub0b4\ub294 \uc5f4\uc744 \uac01\uac01 \uc62c\ubc14\ub974\uac8c \uc9c0\uc815\ud574 \uc8fc\uc2ed\uc2dc\uc624.\n\n\ub370\uc774\ud130\ub97c \uc77d\uc5b4\ub4e4\uc77c \ub54c \uac01 \uc5f4\uc758 \uccab \ud589\uc740 \uc5f4\uc758 \uc81c\ubaa9\uc744 \ub098\ud0c0\ub0b4\ub294 \uac83\uc73c\ub85c \uac00\uc815\ud558\uc5ec \ubb34\uc2dc\ud569\ub2c8\ub2e4. \ub370\uc774\ud130\ub294 \ub458\uc9f8 \ud589\ubd80\ud130 \uc77d\uc5b4\ub4e4\uc5ec\uc9d1\ub2c8\ub2e4.");
        descLabel.setEditable(false);
        descLabel.setLineWrap(true);
        descLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        mainPanel.add(descLabel);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 2));
        JPanel namePanel = new JPanel();
        JLabel nameLabel = new JLabel("\uc774\ub984");
        namePanel.add(nameLabel);
        namePanel.add(this.tablesForNameCombo);
        namePanel.add(this.columnsForNameCombo);
        contentPanel.add(namePanel);
        contentPanel.add(new JSeparator(1));
        JPanel emailPanel = new JPanel();
        JLabel emailLabel = new JLabel("\uc774\uba54\uc77c \uc8fc\uc18c");
        emailPanel.add(emailLabel);
        emailPanel.add(this.tablesForEmailCombo);
        emailPanel.add(this.columnsForEmailCombo);
        contentPanel.add(emailPanel);
        contentPanel.setBorder(new EtchedBorder());
        mainPanel.add(contentPanel);
        this.importerDialog.add((Component)mainPanel, "Center");
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 2));
        JButton btnOk = new JButton("\ud655\uc778");
        btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg) {
                ExcelImporterView.this.okActionPerformed();
            }
        });
        JButton btnCancel = new JButton("\ucde8\uc18c");
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg) {
                ExcelImporterView.this.cancelActionPerformed();
            }
        });
        btnPanel.add(Box.createHorizontalGlue());
        btnPanel.add(btnOk);
        btnPanel.add(btnCancel);
        this.importerDialog.add((Component)btnPanel, "South");
        this.importerDialog.setVisible(true);
    }

    public void comboStateChanged(JComboBox combo, String item) {
        combo.removeAllItems();
        try {
            String[] header = this.db.getHeaderColumns(item);
            int i = 0;
            while (i < header.length) {
                combo.addItem(header[i]);
                ++i;
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this.importerDialog, e.getMessage(), "Error", 0);
        }
    }

    public void okActionPerformed() {
        String nameTable = (String)this.tablesForNameCombo.getSelectedItem();
        String nameColumn = (String)this.columnsForNameCombo.getSelectedItem();
        String emailTable = (String)this.tablesForEmailCombo.getSelectedItem();
        String emailColumn = (String)this.columnsForEmailCombo.getSelectedItem();
        this.db.setNameColumn(nameTable, nameColumn);
        this.db.setEmailColumn(emailTable, emailColumn);
        try {
            this.people = this.db.getPeopleList();
            this.notifyPeopleListObservers();
        }
        catch (MessagingException e) {
            JOptionPane.showMessageDialog(this.importerDialog, e.getMessage(), "Error", 0);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this.importerDialog, e.getMessage(), "Error", 0);
        }
        this.importerDialog.dispose();
    }

    public void cancelActionPerformed() {
        this.importerDialog.dispose();
    }

    public void registerObserver(PeopleListObserver o) {
        this.peopleListObservers.add(o);
    }

    public void removeObserver(PeopleListObserver o) {
        this.peopleListObservers.remove(o);
    }

    public void notifyPeopleListObservers() throws MessagingException {
        int i = 0;
        while (i < this.peopleListObservers.size()) {
            PeopleListObserver o = (PeopleListObserver)this.peopleListObservers.get(i);
            o.updatePeopleList(this.people);
            ++i;
        }
    }
}

