/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jmassmailer.mail;

import com.sun.mail.smtp.SMTPMessage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import net.kldp.jmassmailer.data.PeopleList;
import net.kldp.jmassmailer.data.Person;
import net.kldp.jmassmailer.mail.AuthenticatorImpl;
import net.kldp.jmassmailer.mail.SessionHandlerInterface;
import net.kldp.jmassmailer.mail.SessionValueReader;
import net.kldp.jmassmailer.mail.TransferObserver;

public class SessionHandler
implements SessionHandlerInterface,
SessionValueReader,
Runnable {
    private Session session;
    private PeopleList people;
    private String encoding = "ks_c_5601-1987";
    private String contentType = "text/html";
    private String subject;
    private String text;
    private String username;
    private String password;
    private Address[] replyto;
    private Address[] from;
    private boolean sessionSet;
    private boolean peopleListSet;
    private ArrayList transferObservers = new ArrayList();

    public SessionHandler() {
    }

    public SessionHandler(String username, String password, Properties properties) {
        this();
        this.username = username;
        this.password = password;
        this.createSession(username, password, properties);
    }

    public void createSession(String username, String password, Properties properties) {
        this.username = username;
        this.password = password;
        this.sessionSet = true;
        this.session = Session.getInstance((Properties)properties, (Authenticator)new AuthenticatorImpl(username, password));
    }

    public void createSession(Properties properties) {
        this.session = Session.getInstance((Properties)properties);
    }

    public void setPeopleList(PeopleList people) {
        this.people = people;
        this.peopleListSet = true;
    }

    public void setReplyTo(String replyto) throws AddressException {
        this.replyto = new Address[1];
        try {
            this.replyto[0] = new InternetAddress(replyto);
        }
        catch (AddressException e) {
            throw new AddressException("\ud68c\uc2e0\ud560 \uc774\uba54\uc77c \uc8fc\uc18c\uc758 \ud615\uc2dd\uc774 \uc54c\ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
    }

    public void setFrom(String email) throws AddressException {
        if (email == null) {
            throw new AddressException("\ubcf4\ub0b4\ub294 \uc0ac\ub78c\uc758 \uc774\uba54\uc77c \uc8fc\uc18c\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        this.from = new Address[1];
        this.from[0] = new InternetAddress(email);
    }

    public void setFrom(String email, String name) throws AddressException {
        if (email == null || name == null) {
            throw new AddressException("\ubcf4\ub0b4\ub294 \uc0ac\ub78c\uc758 \uc774\uba54\uc77c \uc8fc\uc18c\uac00 \uc785\ub825\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        this.from = new Address[1];
        String emailWithName = null;
        try {
            emailWithName = String.valueOf(MimeUtility.encodeText((String)name, (String)this.encoding, (String)"B")) + " <" + email + ">";
        }
        catch (UnsupportedEncodingException e1) {
            emailWithName = email;
        }
        this.from[0] = new InternetAddress(emailWithName);
    }

    public void setMessage(String subject, String text) {
        this.subject = subject;
        this.text = text;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private Message generateMessage(Person person) throws MessagingException {
        String emailWithName;
        SMTPMessage message = null;
        message = new SMTPMessage(this.session);
        String personalizedContent = Person.personalizeText(this.text, person);
        String personalizedSubject = Person.personalizeText(this.subject, person);
        try {
            emailWithName = String.valueOf(MimeUtility.encodeText((String)person.getName(), (String)this.encoding, (String)"B")) + " <" + person.getEmail() + ">";
        }
        catch (UnsupportedEncodingException e1) {
            emailWithName = person.getEmail();
        }
        try {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(emailWithName));
            message.addFrom(this.from);
            if (this.replyto != null) {
                message.setReplyTo(this.replyto);
            }
        }
        catch (MessagingException e) {
            throw new MessagingException("\uc774\uba54\uc77c \uc8fc\uc18c\uac00 \uc54c\ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4 : " + person.getEmail() + " (" + person.getName() + ")");
        }
        try {
            message.setSubject(personalizedSubject, this.encoding);
            message.setContent((Object)personalizedContent, String.valueOf(this.contentType) + "; charset=\"" + this.encoding + "\"");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return message;
    }

    public void transfer() throws NoSuchProviderException, AuthenticationFailedException, MessagingException {
        if (!this.isSessionSet()) {
            throw new NoSuchProviderException("SMTP \ud638\uc2a4\ud2b8\uc640 \uc138\uc158 \uc5f0\uacb0\uc774 \uc774\ub8e8\uc5b4\uc9c0\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        if (!this.isPeopleListSet()) {
            throw new MessagingException("\uc804\uc1a1 \ub300\uc0c1\uc774 \uc9c0\uc815\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        Thread doTransfer = new Thread((Runnable)this, "MessageTransfer");
        doTransfer.checkAccess();
        doTransfer.setPriority(1);
        doTransfer.setDaemon(true);
        doTransfer.start();
    }

    public void registerObserver(TransferObserver o) {
        this.transferObservers.add(o);
    }

    public void removeObserver(TransferObserver o) {
        int i = this.transferObservers.indexOf(o);
        if (i >= 0) {
            this.transferObservers.remove(i);
        }
    }

    public void notifyMessageSend(int count) {
        int i = 0;
        while (i < this.transferObservers.size()) {
            TransferObserver o = (TransferObserver)this.transferObservers.get(i);
            o.updateMessageSend(count);
            ++i;
        }
    }

    public void notifyMessageSendFinished(PeopleList failedPeople) {
        int i = 0;
        while (i < this.transferObservers.size()) {
            TransferObserver o = (TransferObserver)this.transferObservers.get(i);
            o.updateMessageSendFinished(failedPeople);
            ++i;
        }
    }

    public void run() {
        try {
            Iterator i = this.people.iterator();
            int counter = 0;
            PeopleList failedMessages = new PeopleList();
            Message message = null;
            Person person = null;
            while (i.hasNext()) {
                person = (Person)i.next();
                message = this.generateMessage(person);
                ++counter;
                int idx = 0;
                while (idx < 10000) {
                    System.out.println("Output");
                    ++idx;
                }
                this.notifyMessageSend(counter);
            }
            this.notifyMessageSendFinished(failedMessages);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (AuthenticationFailedException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public String getHost() {
        return this.session.getProperties().getProperty("mail.host");
    }

    public String getPort() {
        return this.session.getProperties().getProperty("mail.smtp.port");
    }

    public boolean getNeedAuth() {
        String auth = this.session.getProperties().getProperty("mail.smtp.auth");
        return auth.equals("true");
    }

    public boolean getNeedTls() {
        String tls = this.session.getProperties().getProperty("mail.smtp.starttls.enable");
        return tls.equals("true");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFrom() {
        if (this.from != null) {
            return ((InternetAddress)this.from[0]).getAddress();
        }
        return String.valueOf(this.username) + "@" + this.session.getProperties().getProperty("mail.host");
    }

    public String getName() {
        String retVal = null;
        if (this.from != null) {
            retVal = ((InternetAddress)this.from[0]).getPersonal();
        }
        if (retVal == null) {
            return this.getFrom();
        }
        return retVal;
    }

    public String getReplyTo() {
        if (this.replyto != null) {
            return ((InternetAddress)this.replyto[0]).getAddress();
        }
        return this.getFrom();
    }

    public boolean isSessionSet() {
        return this.sessionSet;
    }

    public boolean isPeopleListSet() {
        return this.peopleListSet;
    }
}

