/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jmassmailer.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.kldp.jmassmailer.data.PeopleList;
import net.kldp.jmassmailer.data.Person;
import net.kldp.jmassmailer.mail.SessionHandlerController;
import net.kldp.jmassmailer.ui.JMyDialog;

public class MailerMainWindow
extends JFrame {
    private static final long serialVersionUID = -8747224830643289621L;
    protected SessionHandlerController shc;
    protected PeopleList people;
    private JPanel contentPanel;
    private JPanel mainButtonPanel;
    private CardLayout contentLayout;

    public MailerMainWindow() {
        super("jmassmailer");
        this.setDefaultCloseOperation(3);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Can't load system Look and Feel.\nDefault Look and Feel would be used.");
        }
        this.setSize(700, 500);
        Dimension dim = this.getToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getWidth() / 2, dim.height / 2 - this.getHeight() / 2);
        this.setLayout(new BorderLayout());
        JMenuBar menubar = this.createMenu();
        this.setJMenuBar(menubar);
        this.mainButtonPanel = this.createMainButtonPanel();
        this.getContentPane().add((Component)this.mainButtonPanel, "West");
        this.contentPanel = new JPanel();
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentLayout = new CardLayout();
        this.contentPanel.setLayout(this.contentLayout);
        this.people = new PeopleList();
        this.people = new PeopleList();
        this.people.add(new Person("Jeong Soo, Park", "toracle@teramail.com"));
        this.people.add(new Person("Jeong Soo, Park", "toracle@gmail.com"));
        this.setVisible(true);
    }

    private JMyDialog loadConfigureFile(String filename) {
        JMyDialog dialog = null;
        File dialogFile = new File(filename);
        if (dialogFile.isFile()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(dialogFile));
                dialog = (JMyDialog)in.readObject();
            }
            catch (FileNotFoundException e1) {
                System.err.println("Previous setting file; " + filename + " is not found.\nWould use default (null) values.");
            }
            catch (IOException e1) {
                System.err.println("Error occurs during reading previous setting; " + filename + "\nWould use default (null) values.");
            }
            catch (ClassNotFoundException e) {
                System.err.println("Configuration file " + filename + "is might be currupted.\nWould use default (null) values.");
            }
        }
        return dialog;
    }

    private void saveConfigureFile(String filename, Object object) {
        File objectFile = new File(filename);
        ObjectOutputStream out = null;
        try {
            objectFile.createNewFile();
        }
        catch (IOException e) {
            System.err.println("Configuration file creation error" + e.getMessage());
        }
        try {
            out = new ObjectOutputStream(new FileOutputStream(objectFile));
        }
        catch (IOException e) {
            System.err.println("Configuration file input streen open error" + e.getMessage());
        }
        try {
            out.writeObject(object);
        }
        catch (IOException e) {
            System.err.println("An Error occurs during saving configuration file.\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    private JPanel createMainButtonPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel viewPanel = new JPanel();
        viewPanel.setBorder(new TitledBorder(new EtchedBorder(), "View"));
        viewPanel.setLayout(new GridLayout(15, 1));
        JButton btnMailingList = new JButton("Mailing List");
        btnMailingList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MailerMainWindow.this.contentLayout.show(MailerMainWindow.this.contentPanel, "MailingList");
            }
        });
        viewPanel.add(btnMailingList);
        JButton btnComposeMessage = new JButton("Message");
        btnComposeMessage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MailerMainWindow.this.contentLayout.show(MailerMainWindow.this.contentPanel, "Message");
            }
        });
        viewPanel.add(btnComposeMessage);
        mainPanel.add((Component)viewPanel, "Center");
        JButton btnSend = new JButton("Send");
        btnSend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MailerMainWindow.this.sendMessages();
            }
        });
        mainPanel.add((Component)btnSend, "South");
        return mainPanel;
    }

    private JMenuBar createMenu() {
        JMenuBar menubar = new JMenuBar();
        JMenu configureMenu = new JMenu("Configuration");
        configureMenu.setMnemonic('c');
        menubar.add(configureMenu);
        configureMenu.addSeparator();
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('h');
        menubar.add(helpMenu);
        return menubar;
    }

    private void sendMessages() {
    }
}

