/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jmassmailer.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import jxl.read.biff.BiffException;
import net.kldp.jmassmailer.Configurator;
import net.kldp.jmassmailer.data.ExcelHandler;
import net.kldp.jmassmailer.data.ExcelImporter;
import net.kldp.jmassmailer.data.PeopleList;
import net.kldp.jmassmailer.data.PeopleListModel;
import net.kldp.jmassmailer.data.PeopleListObserver;
import net.kldp.jmassmailer.mail.SessionHandler;
import net.kldp.jmassmailer.mail.SessionHandlerControllerInterface;
import net.kldp.jmassmailer.mail.TransferObserver;
import net.kldp.jmassmailer.ui.ActionMenu;
import net.kldp.jmassmailer.ui.SmtpHostDialog;

public class MailerView
implements ActionListener,
TransferObserver,
PeopleListObserver,
WindowListener {
    private SessionHandler model;
    private PeopleListModel peopleModel;
    private SessionHandlerControllerInterface controller;
    private Configurator conf;
    private JFrame viewFrame;
    private JTable recipient;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JTextArea messageContent;
    private JTextField messageSubject;
    private JButton sendButton;
    private SmtpHostDialog smtpDialog;
    private JProgressBar transferProgress;
    private File lastOpened;

    public MailerView(SessionHandlerControllerInterface controller, SessionHandler model, Configurator conf) {
        this.controller = controller;
        this.model = model;
        this.conf = conf;
        model.registerObserver(this);
        this.peopleModel = new PeopleListModel(null);
        this.peopleModel.registerObserver(this);
    }

    public void createView() {
        this.viewFrame = new JFrame("JMassmailer");
        this.viewFrame.setSize(700, 500);
        Dimension dim = this.viewFrame.getToolkit().getScreenSize();
        this.viewFrame.setLocation(dim.width / 2 - this.viewFrame.getWidth() / 2, dim.height / 2 - this.viewFrame.getHeight() / 2);
        this.viewFrame.setDefaultCloseOperation(0);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.viewFrame, "Can't load system Look and Feel.\nDefault Look and Feel would be used.");
        }
        this.smtpDialog = new SmtpHostDialog(this.viewFrame, "SMTP \ud638\uc2a4\ud2b8 \uc124\uc815", true);
        this.smtpDialog.registerObserver(this.controller);
        this.smtpDialog.registerObserver(this.controller);
        this.viewFrame.setJMenuBar(this.createMenu());
        JSplitPane split = new JSplitPane();
        split.setDividerLocation(200);
        this.viewFrame.add(split);
        this.recipient = new JTable(this.peopleModel);
        this.recipient.setOpaque(true);
        JScrollPane scroll = new JScrollPane(this.recipient);
        split.setLeftComponent(scroll);
        JPanel messageComposePanel = new JPanel();
        messageComposePanel.setLayout(new BorderLayout());
        messageComposePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\uba54\uc138\uc9c0 \uc791\uc131"));
        this.messageSubject = new JTextField();
        this.messageContent = new JTextArea();
        this.messageContent.setBorder(new EtchedBorder());
        JPanel messageSubjectPanel = new JPanel();
        messageSubjectPanel.setLayout(new BoxLayout(messageSubjectPanel, 0));
        JLabel subjectLabel = new JLabel("\uc81c\ubaa9");
        subjectLabel.setLabelFor(this.messageSubject);
        messageSubjectPanel.add(subjectLabel);
        messageSubjectPanel.add(this.messageSubject);
        messageSubjectPanel.setBorder(BorderFactory.createEmptyBorder());
        messageComposePanel.add((Component)messageSubjectPanel, "North");
        JPanel messageContentPanel = new JPanel();
        messageContentPanel.setLayout(new BoxLayout(messageContentPanel, 0));
        JLabel contentLabel = new JLabel("\ubcf8\ubb38");
        messageContentPanel.add(contentLabel);
        JScrollPane messageContentScroll = new JScrollPane(this.messageContent);
        messageContentPanel.add(messageContentScroll);
        messageContentPanel.setBorder(BorderFactory.createEmptyBorder());
        messageComposePanel.add((Component)messageContentPanel, "Center");
        split.setRightComponent(messageComposePanel);
        JPanel sendPanel = new JPanel();
        sendPanel.setLayout(new BorderLayout());
        sendPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new CardLayout());
        this.statusLabel = new JLabel();
        this.statusPanel.add((Component)this.statusLabel, "label");
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusLabel.setVisible(true);
        this.transferProgress = new JProgressBar(0, 100);
        this.statusPanel.add((Component)this.transferProgress, "progress");
        this.transferProgress.setBorder(BorderFactory.createLoweredBevelBorder());
        this.transferProgress.setVisible(false);
        sendPanel.add(this.statusPanel);
        this.sendButton = new JButton("Send");
        this.sendButton.addActionListener(this);
        sendPanel.add((Component)this.sendButton, "East");
        this.viewFrame.getContentPane().add((Component)sendPanel, "South");
        this.smtpDialog = new SmtpHostDialog(this.viewFrame, "SMTP \ud638\uc2a4\ud2b8 \uc124\uc815", true);
        this.smtpDialog.registerObserver(this.controller);
        this.smtpDialog.registerObserver(this.controller);
        this.viewFrame.setVisible(true);
    }

    public JMenuBar createMenu() {
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("\ud30c\uc77c");
        fileMenu.setMnemonic('f');
        JMenu importMenu = new JMenu("\uc804\uc1a1 \ubaa9\ub85d \ubd88\ub7ec\uc624\uae30");
        fileMenu.add(importMenu);
        importMenu.add(new ActionMenu("\uc5d1\uc140 \ud30c\uc77c \ubd88\ub7ec\uc624\uae30", KeyStroke.getKeyStroke(69, 128)){
            private static final long serialVersionUID = -826678749957040808L;

            public void actionPerformed(ActionEvent arg) {
                JFileChooser chooser = null;
                chooser = MailerView.this.lastOpened == null ? new JFileChooser() : new JFileChooser(MailerView.this.lastOpened);
                File excelFile = null;
                int returnVal = chooser.showOpenDialog(MailerView.this.viewFrame);
                if (returnVal == 0) {
                    excelFile = chooser.getSelectedFile();
                    MailerView.this.lastOpened = chooser.getSelectedFile();
                    try {
                        ExcelHandler db = new ExcelHandler(excelFile);
                        ExcelImporter excelImporter = new ExcelImporter(db, MailerView.this.viewFrame);
                        excelImporter.registerObserver(MailerView.this.controller);
                        excelImporter.registerObserver(MailerView.this.peopleModel);
                    }
                    catch (BiffException e) {
                        JOptionPane.showMessageDialog(MailerView.this.viewFrame, e.getMessage(), "Error", 0);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(MailerView.this.viewFrame, e.getMessage(), "Error", 0);
                    }
                }
            }
        });
        fileMenu.add(new ActionMenu("\uba54\uc77c \ubcf4\ub0b4\uae30", KeyStroke.getKeyStroke(71, 128)){
            private static final long serialVersionUID = -6088653926170490086L;

            public void actionPerformed(ActionEvent arg) {
                MailerView.this.send();
            }
        });
        fileMenu.addSeparator();
        fileMenu.add(new ActionMenu("\uc885\ub8cc", KeyStroke.getKeyStroke(81, 128)){
            private static final long serialVersionUID = -3346498797060896026L;

            public void actionPerformed(ActionEvent arg0) {
                MailerView.this.finalizer();
            }
        });
        menubar.add(fileMenu);
        JMenu confMenu = new JMenu("\uc124\uc815");
        confMenu.setMnemonic('c');
        confMenu.add(new ActionMenu("SMTP \uc124\uc815", KeyStroke.getKeyStroke(80, 512)){
            private static final long serialVersionUID = 8820883031395027953L;

            public void actionPerformed(ActionEvent arg) {
                if (MailerView.this.model.isSessionSet()) {
                    MailerView.this.smtpDialog.setValues(MailerView.this.model);
                }
                MailerView.this.smtpDialog.setVisible(true);
            }
        });
        menubar.add(confMenu);
        return menubar;
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.sendButton) {
            this.send();
        }
    }

    public void send() {
        int value = JOptionPane.showConfirmDialog(this.viewFrame, "\uba54\uc77c\uc744 \ubcf4\ub0b4\uc2dc\uaca0\uc2b5\ub2c8\uae4c?", "\ud655\uc778", 0, 2);
        if (value == 0) {
            this.controller.setMessage(this.messageSubject.getText(), this.messageContent.getText());
            this.statusLabel.setVisible(false);
            this.transferProgress.setVisible(true);
            this.transferProgress.setValue(0);
            try {
                this.controller.sendMessages();
            }
            catch (NoSuchProviderException e) {
                JOptionPane.showMessageDialog(this.viewFrame, e.getMessage(), "Error", 0);
                this.statusLabel.setVisible(true);
                this.transferProgress.setVisible(false);
            }
            catch (AuthenticationFailedException e) {
                JOptionPane.showMessageDialog(this.viewFrame, e.getMessage(), "Error", 0);
                this.statusLabel.setVisible(true);
                this.transferProgress.setVisible(false);
            }
            catch (MessagingException e) {
                JOptionPane.showMessageDialog(this.viewFrame, e.getMessage(), "Error", 0);
                this.statusLabel.setVisible(true);
                this.transferProgress.setVisible(false);
            }
        }
    }

    public void finalizer() {
        int value = JOptionPane.showConfirmDialog(this.viewFrame, "\ud504\ub85c\uadf8\ub7a8\uc744 \uc885\ub8cc\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?", "\ud655\uc778", 0, 2);
        if (value == 0) {
            this.controller.finalizer();
            System.exit(0);
        }
    }

    public void updateMessageSend(int count) {
        this.transferProgress.setValue(count);
    }

    public void updateMessageSendFinished(PeopleList failedPeople) {
        JOptionPane.showMessageDialog(null, "\uc804\uc1a1\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", "\uc54c\ub9bc", 1);
        this.transferProgress.setValue(0);
        this.statusLabel.setVisible(true);
        this.transferProgress.setVisible(false);
        this.statusLabel.setText("\uc804\uc1a1\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
    }

    public void windowOpened(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.finalizer();
    }

    public void windowClosed(WindowEvent arg0) {
        this.finalizer();
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void updatePeopleList(PeopleList people) throws MessagingException {
        this.recipient.revalidate();
        this.transferProgress.setMaximum(people.size());
        this.statusLabel.setText("\uc804\uc1a1 \ubaa9\ub85d\uc744 \ubd88\ub7ec\ub4e4\uc600\uc2b5\ub2c8\ub2e4.");
    }
}

