/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.uuid;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.axis.components.uuid.UUIDGen;

public class SimpleUUIDGen
implements UUIDGen {
    private static final BigInteger countStart = new BigInteger("-12219292800000");
    private static final int clock_sequence = new Random().nextInt(16384);

    public String nextUUID() {
        int i;
        String clockSeqLow;
        String clockSeqHiAndReserved;
        String timeHiAndVersion;
        String timeMid;
        int i2;
        int i3;
        BigInteger current = BigInteger.valueOf(System.currentTimeMillis());
        BigInteger countMillis = current.subtract(countStart);
        BigInteger count = countMillis.multiply(BigInteger.valueOf(10000L));
        String bitString = count.toString(2);
        if (bitString.length() < 60) {
            int nbExtraZeros = 60 - bitString.length();
            String extraZeros = new String();
            i3 = 0;
            while (i3 < nbExtraZeros) {
                extraZeros = extraZeros.concat("0");
                ++i3;
            }
            bitString = extraZeros.concat(bitString);
        }
        byte[] bits = bitString.getBytes();
        byte[] time_low = new byte[32];
        i3 = 0;
        while (i3 < 32) {
            time_low[i3] = bits[bits.length - i3 - 1];
            ++i3;
        }
        byte[] time_mid = new byte[16];
        int i4 = 0;
        while (i4 < 16) {
            time_mid[i4] = bits[bits.length - 32 - i4 - 1];
            ++i4;
        }
        byte[] time_hi_and_version = new byte[16];
        int i5 = 0;
        while (i5 < 12) {
            time_hi_and_version[i5] = bits[bits.length - 48 - i5 - 1];
            ++i5;
        }
        time_hi_and_version[12] = new String("1").getBytes()[0];
        time_hi_and_version[13] = new String("0").getBytes()[0];
        time_hi_and_version[14] = new String("0").getBytes()[0];
        time_hi_and_version[15] = new String("0").getBytes()[0];
        BigInteger clockSequence = BigInteger.valueOf(clock_sequence);
        String clockString = clockSequence.toString(2);
        if (clockString.length() < 14) {
            int nbExtraZeros = 14 - bitString.length();
            String extraZeros = new String();
            i2 = 0;
            while (i2 < nbExtraZeros) {
                extraZeros = extraZeros.concat("0");
                ++i2;
            }
            clockString = extraZeros.concat(bitString);
        }
        byte[] clock_bits = clockString.getBytes();
        byte[] clock_seq_low = new byte[8];
        i2 = 0;
        while (i2 < 8) {
            clock_seq_low[i2] = clock_bits[clock_bits.length - i2 - 1];
            ++i2;
        }
        byte[] clock_seq_hi_and_reserved = new byte[8];
        int i6 = 0;
        while (i6 < 6) {
            clock_seq_hi_and_reserved[i6] = clock_bits[clock_bits.length - 8 - i6 - 1];
            ++i6;
        }
        clock_seq_hi_and_reserved[6] = new String("0").getBytes()[0];
        clock_seq_hi_and_reserved[7] = new String("1").getBytes()[0];
        String timeLow = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(time_low)), 2).longValue());
        if (timeLow.length() < 8) {
            int nbExtraZeros = 8 - timeLow.length();
            String extraZeros = new String();
            int i7 = 0;
            while (i7 < nbExtraZeros) {
                extraZeros = extraZeros.concat("0");
                ++i7;
            }
            timeLow = extraZeros.concat(timeLow);
        }
        if ((timeMid = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(time_mid)), 2).longValue())).length() < 4) {
            int nbExtraZeros = 4 - timeMid.length();
            String extraZeros = new String();
            int i8 = 0;
            while (i8 < nbExtraZeros) {
                extraZeros = extraZeros.concat("0");
                ++i8;
            }
            timeMid = extraZeros.concat(timeMid);
        }
        if ((timeHiAndVersion = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(time_hi_and_version)), 2).longValue())).length() < 4) {
            int nbExtraZeros = 4 - timeHiAndVersion.length();
            String extraZeros = new String();
            int i9 = 0;
            while (i9 < nbExtraZeros) {
                extraZeros = extraZeros.concat("0");
                ++i9;
            }
            timeHiAndVersion = extraZeros.concat(timeHiAndVersion);
        }
        if ((clockSeqHiAndReserved = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(clock_seq_hi_and_reserved)), 2).longValue())).length() < 2) {
            int nbExtraZeros = 2 - clockSeqHiAndReserved.length();
            String extraZeros = new String();
            int i10 = 0;
            while (i10 < nbExtraZeros) {
                extraZeros = extraZeros.concat("0");
                ++i10;
            }
            clockSeqHiAndReserved = extraZeros.concat(clockSeqHiAndReserved);
        }
        if ((clockSeqLow = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(clock_seq_low)), 2).longValue())).length() < 2) {
            int nbExtraZeros = 2 - clockSeqLow.length();
            String extraZeros = new String();
            int i11 = 0;
            while (i11 < nbExtraZeros) {
                extraZeros = extraZeros.concat("0");
                ++i11;
            }
            clockSeqLow = extraZeros.concat(clockSeqLow);
        }
        Random secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (Exception e) {
            secureRandom = new Random();
        }
        long nodeValue = secureRandom.nextLong();
        nodeValue = Math.abs(nodeValue);
        while (nodeValue > 0x800000000000L) {
            nodeValue = secureRandom.nextLong();
            nodeValue = Math.abs(nodeValue);
        }
        BigInteger nodeInt = BigInteger.valueOf(nodeValue);
        String nodeString = nodeInt.toString(2);
        if (nodeString.length() < 47) {
            int nbExtraZeros = 47 - nodeString.length();
            String extraZeros = new String();
            i = 0;
            while (i < nbExtraZeros) {
                extraZeros = extraZeros.concat("0");
                ++i;
            }
            nodeString = extraZeros.concat(nodeString);
        }
        byte[] node_bits = nodeString.getBytes();
        byte[] node = new byte[48];
        i = 0;
        while (i < 47) {
            node[i] = node_bits[node_bits.length - i - 1];
            ++i;
        }
        node[47] = new String("1").getBytes()[0];
        String theNode = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(node)), 2).longValue());
        if (theNode.length() < 12) {
            int nbExtraZeros = 12 - theNode.length();
            String extraZeros = new String();
            int i12 = 0;
            while (i12 < nbExtraZeros) {
                extraZeros = extraZeros.concat("0");
                ++i12;
            }
            theNode = extraZeros.concat(theNode);
        }
        String result = timeLow + "-" + timeMid + "-" + timeHiAndVersion + "-" + clockSeqHiAndReserved + clockSeqLow + "-" + theNode;
        return result.toUpperCase();
    }

    private static byte[] reverseArray(byte[] bits) {
        byte[] result = new byte[bits.length];
        int i = 0;
        while (i < result.length) {
            result[i] = bits[result.length - 1 - i];
            ++i;
        }
        return result;
    }

    public void destroy() {
    }

    public void init() {
    }
}

