/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CharsetMapping;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SingleByteCharsetConverter {
    private static byte[] unknownCharsMap = new byte[65536];
    private static final int BYTE_RANGE = 256;
    private static final Map CONVERTER_MAP;
    private static byte[] allBytes;
    private char[] byteToChars = new char[256];
    private byte[] charToByteMap = new byte[65536];

    private SingleByteCharsetConverter(String encodingName) throws UnsupportedEncodingException {
        String allBytesString = new String(allBytes, 0, 256, encodingName);
        int allBytesLen = allBytesString.length();
        System.arraycopy(unknownCharsMap, 0, this.charToByteMap, 0, this.charToByteMap.length);
        int i = 0;
        while (i < 256 && i < allBytesLen) {
            char c;
            this.byteToChars[i] = c = allBytesString.charAt(i);
            this.charToByteMap[c] = allBytes[i];
            ++i;
        }
    }

    public static synchronized SingleByteCharsetConverter getInstance(String encodingName) throws UnsupportedEncodingException {
        SingleByteCharsetConverter instance = (SingleByteCharsetConverter)CONVERTER_MAP.get(encodingName);
        if (instance == null) {
            instance = SingleByteCharsetConverter.initCharset(encodingName);
        }
        return instance;
    }

    public static SingleByteCharsetConverter initCharset(String javaEncodingName) throws UnsupportedEncodingException {
        String mysqlEncodingName = (String)CharsetMapping.JAVA_TO_MYSQL_CHARSET_MAP.get(javaEncodingName);
        if (mysqlEncodingName == null) {
            return null;
        }
        if (CharsetMapping.MULTIBYTE_CHARSETS.containsKey(mysqlEncodingName)) {
            return null;
        }
        SingleByteCharsetConverter converter = new SingleByteCharsetConverter(javaEncodingName);
        CONVERTER_MAP.put(javaEncodingName, converter);
        return converter;
    }

    public static String toStringDefaultEncoding(byte[] buffer, int startPos, int length) {
        return new String(buffer, startPos, length);
    }

    public final byte[] toBytes(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            bytes[i] = this.charToByteMap[c];
            ++i;
        }
        return bytes;
    }

    public final String toString(byte[] buffer) {
        return this.toString(buffer, 0, buffer.length);
    }

    public final String toString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        int i = 0;
        while (i < length) {
            charArray[i] = this.byteToChars[buffer[readpoint] - -128];
            ++readpoint;
            ++i;
        }
        return new String(charArray);
    }

    static {
        BYTE_RANGE = 256;
        CONVERTER_MAP = new HashMap();
        allBytes = new byte[256];
        int i = -128;
        while (i <= 127) {
            SingleByteCharsetConverter.allBytes[i - -128] = (byte)i;
            ++i;
        }
        int i2 = 0;
        while (i2 < unknownCharsMap.length) {
            SingleByteCharsetConverter.unknownCharsMap[i2] = 63;
            ++i2;
        }
    }
}

