/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import net.sf.cglib.MethodFilter;
import net.sf.cglib.ReflectUtils;

public class VisibilityFilter
implements MethodFilter {
    private String pkg;

    public VisibilityFilter(Class source) {
        this.pkg = ReflectUtils.getPackageName(source);
    }

    public boolean accept(Member member) {
        int mod = member.getModifiers();
        if (Modifier.isStatic(mod) || Modifier.isPrivate(mod)) {
            return false;
        }
        if (Modifier.isProtected(mod) || Modifier.isPublic(mod)) {
            return true;
        }
        return this.pkg.equals(ReflectUtils.getPackageName(member.getDeclaringClass()));
    }

    public int hashCode() {
        return this.pkg.hashCode();
    }

    public boolean equals(Object obj) {
        return this.pkg.equals(((VisibilityFilter)obj).pkg);
    }
}

