/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.db.sqlmap.MappedStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.sql.DataSource;

public class PaginatedDataList
implements PaginatedList {
    private MappedStatement mappedStatement;
    private Object parameterObject;
    private int pageSize;
    private int index;
    private List prevPageList;
    private List currentPageList;
    private List nextPageList;

    public PaginatedDataList(MappedStatement mappedStatement, Object object, int n) throws SQLException {
        this.mappedStatement = mappedStatement;
        this.parameterObject = object;
        this.pageSize = n;
        this.index = 0;
        this.pageTo(0);
    }

    private void pageForward() {
        try {
            this.prevPageList = this.currentPageList;
            this.currentPageList = this.nextPageList;
            this.nextPageList = this.getList(this.index + 1, this.pageSize);
        }
        catch (SQLException sQLException) {
            throw new NestedRuntimeException("Unexpected error while repaginating paged list.  Cause: " + sQLException, sQLException);
        }
    }

    private void pageBack() {
        try {
            this.nextPageList = this.currentPageList;
            this.currentPageList = this.prevPageList;
            this.prevPageList = this.index > 0 ? this.getList(this.index - 1, this.pageSize) : new ArrayList();
        }
        catch (SQLException sQLException) {
            throw new NestedRuntimeException("Unexpected error while repaginating paged list.  Cause: " + sQLException, sQLException);
        }
    }

    private void safePageTo(int n) {
        try {
            this.pageTo(n);
        }
        catch (SQLException sQLException) {
            throw new NestedRuntimeException("Unexpected error while repaginating paged list.  Cause: " + sQLException, sQLException);
        }
    }

    public void pageTo(int n) throws SQLException {
        this.index = n;
        List list = n < 1 ? this.getList(n, this.pageSize * 2) : this.getList(n - 1, this.pageSize * 3);
        if (list.size() < 1) {
            this.prevPageList = new ArrayList(0);
            this.currentPageList = new ArrayList(0);
            this.nextPageList = new ArrayList(0);
        } else if (n < 1) {
            this.prevPageList = new ArrayList(0);
            if (list.size() <= this.pageSize) {
                this.currentPageList = list.subList(0, list.size());
                this.nextPageList = new ArrayList(0);
            } else {
                this.currentPageList = list.subList(0, this.pageSize);
                this.nextPageList = list.subList(this.pageSize, list.size());
            }
        } else if (list.size() <= this.pageSize) {
            this.prevPageList = list.subList(0, list.size());
            this.currentPageList = new ArrayList(0);
            this.nextPageList = new ArrayList(0);
        } else if (list.size() <= this.pageSize * 2) {
            this.prevPageList = list.subList(0, this.pageSize);
            this.currentPageList = list.subList(this.pageSize, list.size());
            this.nextPageList = new ArrayList(0);
        } else {
            this.prevPageList = list.subList(0, this.pageSize);
            this.currentPageList = list.subList(this.pageSize, this.pageSize * 2);
            this.nextPageList = list.subList(this.pageSize * 2, list.size());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getList(int n, int n2) throws SQLException {
        List list;
        boolean bl = true;
        boolean bl2 = !this.mappedStatement.getSqlMap().isUseGlobalTransaction();
        DataSource dataSource = this.mappedStatement.getSqlMap().getCurrentDataSource();
        Connection connection = this.mappedStatement.getSqlMap().getCurrentLocalConnection();
        if (connection == null) {
            bl = false;
            connection = dataSource.getConnection();
            if (bl2 != connection.getAutoCommit()) {
                connection.setAutoCommit(bl2);
            }
        }
        try {
            list = this.mappedStatement.executeQueryForList(connection, this.parameterObject, n * this.pageSize, n2);
            Object var9_8 = null;
            if (bl) return list;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
        return list;
    }

    public void nextPage() {
        if (this.isNextPageAvailable()) {
            ++this.index;
            this.pageForward();
        }
    }

    public void previousPage() {
        if (this.isPreviousPageAvailable()) {
            --this.index;
            this.pageBack();
        }
    }

    public void gotoPage(int n) {
        this.safePageTo(n);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isFirstPage() {
        return this.index == 0;
    }

    public boolean isMiddlePage() {
        return !this.isFirstPage() && !this.isLastPage();
    }

    public boolean isLastPage() {
        return this.nextPageList.size() < 1;
    }

    public boolean isNextPageAvailable() {
        return this.nextPageList.size() > 0;
    }

    public boolean isPreviousPageAvailable() {
        return this.prevPageList.size() > 0;
    }

    public int size() {
        return this.currentPageList.size();
    }

    public boolean isEmpty() {
        return this.currentPageList.isEmpty();
    }

    public boolean contains(Object object) {
        return this.currentPageList.contains(object);
    }

    public Iterator iterator() {
        return this.currentPageList.iterator();
    }

    public Object[] toArray() {
        return this.currentPageList.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.currentPageList.toArray(objectArray);
    }

    public boolean containsAll(Collection collection) {
        return this.currentPageList.containsAll(collection);
    }

    public Object get(int n) {
        return this.currentPageList.get(n);
    }

    public int indexOf(Object object) {
        return this.currentPageList.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.currentPageList.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.currentPageList.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.currentPageList.listIterator(n);
    }

    public List subList(int n, int n2) {
        return this.currentPageList.subList(n, n2);
    }

    public boolean add(Object object) {
        return this.currentPageList.add(object);
    }

    public boolean remove(Object object) {
        return this.currentPageList.remove(object);
    }

    public boolean addAll(Collection collection) {
        return this.currentPageList.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.currentPageList.addAll(n, collection);
    }

    public boolean removeAll(Collection collection) {
        return this.currentPageList.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.currentPageList.retainAll(collection);
    }

    public void clear() {
        this.currentPageList.clear();
    }

    public Object set(int n, Object object) {
        return this.currentPageList.set(n, object);
    }

    public void add(int n, Object object) {
        this.currentPageList.add(n, object);
    }

    public Object remove(int n) {
        return this.currentPageList.remove(n);
    }

    public int getPageIndex() {
        return this.index;
    }
}

