/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.common.util.Throttle;
import com.ibatis.db.jta.JtaTransaction;
import com.ibatis.db.jta.JtaTransactionException;
import com.ibatis.db.sqlmap.Cache;
import com.ibatis.db.sqlmap.ExecuteListener;
import com.ibatis.db.sqlmap.MappedStatement;
import com.ibatis.db.sqlmap.ParameterMap;
import com.ibatis.db.sqlmap.ResultMap;
import com.ibatis.db.sqlmap.RowHandler;
import com.ibatis.db.sqlmap.SqlMapException;
import com.ibatis.db.sqlmap.StatementFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class SqlMap {
    private Map mappedStatements = new HashMap();
    private Map resultMaps = new HashMap();
    private Map parameterMaps = new HashMap();
    private Map dataSourceMap = new HashMap();
    private String currentDataSourceName;
    private StatementFactory statementFactory = new StatementFactory();
    private boolean useGlobalTransaction = false;
    private boolean useFullyQualifiedStatementNames = false;
    private boolean driverHintsEnabled = false;
    private boolean cacheModelsEnabled = true;
    private String userTransactionJndiName;
    private JtaTransaction userTransaction;
    private PrintWriter logWriter = null;
    private ThreadLocal localTransaction = new ThreadLocal();
    private ThreadLocal localBatch = new ThreadLocal();
    private HashMap cacheMap = new HashMap();
    private Throttle executePerConnThrottle;
    private Throttle executeThrottle;
    private Throttle transactionThrottle;

    public SqlMap() {
        Cache cache = new Cache();
        cache.setName("STRONG");
        cache.setReferenceType("STRONG");
        this.addCache(cache);
        Cache cache2 = new Cache();
        cache2.setName("SOFT");
        cache2.setReferenceType("SOFT");
        this.addCache(cache2);
        Cache cache3 = new Cache();
        cache3.setName("WEAK");
        cache3.setReferenceType("WEAK");
        this.addCache(cache3);
    }

    public void setMaxExecutePerConnection(int n) {
        this.executePerConnThrottle = n > 0 ? new Throttle(n) : null;
    }

    public void setMaxExecute(int n) {
        this.executeThrottle = n > 0 ? new Throttle(n) : null;
    }

    public void setMaxTransactions(int n) {
        this.transactionThrottle = n > 0 ? new Throttle(n) : null;
    }

    public String getUserTransactionJndiName() {
        return this.userTransactionJndiName;
    }

    public void setUserTransactionJndiName(String string) {
        try {
            InitialContext initialContext = new InitialContext();
            UserTransaction userTransaction = (UserTransaction)initialContext.lookup(string);
            this.userTransaction = new JtaTransaction(userTransaction);
            this.userTransactionJndiName = string;
        }
        catch (NamingException namingException) {
            throw new NestedRuntimeException("Error setting userTransactionJndiName.  Cause: " + namingException, namingException);
        }
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void log(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
            this.logWriter.flush();
        }
    }

    public boolean isCacheModelsEnabled() {
        return this.cacheModelsEnabled;
    }

    public void setCacheModelsEnabled(boolean bl) {
        this.cacheModelsEnabled = bl;
    }

    public boolean isDriverHintsEnabled() {
        return this.driverHintsEnabled;
    }

    public void setDriverHintsEnabled(boolean bl) {
        this.driverHintsEnabled = bl;
    }

    public boolean isUseGlobalTransaction() {
        return this.useGlobalTransaction;
    }

    public void setUseGlobalTransaction(boolean bl) {
        this.useGlobalTransaction = bl;
    }

    public boolean isUseFullyQualifiedStatementNames() {
        return this.useFullyQualifiedStatementNames;
    }

    public void setUseFullyQualifiedStatementNames(boolean bl) {
        this.useFullyQualifiedStatementNames = bl;
    }

    public boolean isCachePreparedStatement() {
        return this.getStatementCacheSize() > 0;
    }

    public void setCachePreparedStatement(boolean bl) {
        if (!bl) {
            this.setStatementCacheSize(0);
        }
    }

    public int getStatementCacheSize() {
        return this.statementFactory.getMaxTotalCachedStatements();
    }

    public void setStatementCacheSize(int n) {
        this.statementFactory.setMaxTotalCachedStatements(n);
    }

    public String getDataCacheStats() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.mappedStatements.keySet().iterator();
        while (iterator.hasNext()) {
            MappedStatement mappedStatement = (MappedStatement)this.mappedStatements.get(iterator.next());
            stringBuffer.append(mappedStatement.getName());
            stringBuffer.append(": ");
            Double d = mappedStatement.getDataCacheHitRatio();
            if (d != null) {
                stringBuffer.append(Math.round(d * 100.0));
                stringBuffer.append("%");
            } else {
                stringBuffer.append("No Cache.");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Double getStatementCacheHitRatio() {
        return this.statementFactory.getCacheHitRatio();
    }

    public void flushCache() {
        Iterator iterator = this.cacheMap.keySet().iterator();
        while (iterator.hasNext()) {
            ((Cache)iterator.next()).flush();
        }
    }

    public void addExecuteListener(ExecuteListener executeListener) {
        Iterator iterator = this.mappedStatements.values().iterator();
        while (iterator.hasNext()) {
            MappedStatement mappedStatement = (MappedStatement)iterator.next();
            mappedStatement.addExecuteListener(executeListener);
        }
    }

    public void addDataSource(String string, DataSource dataSource) {
        this.dataSourceMap.put(string, dataSource);
    }

    public DataSource getDataSource(String string) {
        return (DataSource)this.dataSourceMap.get(string);
    }

    public DataSource getCurrentDataSource() {
        return (DataSource)this.dataSourceMap.get(this.currentDataSourceName);
    }

    public StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public MappedStatement getMappedStatement(String string) {
        if (!this.mappedStatements.containsKey(string)) {
            throw new SqlMapException("This SQL map does not contain an MappedStatement named " + string);
        }
        return (MappedStatement)this.mappedStatements.get(string);
    }

    public Iterator getMappedStatementNames() {
        return this.mappedStatements.keySet().iterator();
    }

    public void addMappedStatement(MappedStatement mappedStatement) {
        if (this.mappedStatements.containsKey(mappedStatement.getName())) {
            throw new SqlMapException("This SQL map already contains an MappedStatement named " + mappedStatement.getName());
        }
        this.mappedStatements.put(mappedStatement.getName(), mappedStatement);
    }

    public Cache getCache(String string) {
        if (!this.cacheMap.containsKey(string)) {
            throw new SqlMapException("This SQL map does not contain an Cache named " + string);
        }
        return (Cache)this.cacheMap.get(string);
    }

    public void addCache(Cache cache) {
        if (this.cacheMap.containsKey(cache.getName())) {
            throw new SqlMapException("This SQL map already contains an Cache named " + cache.getName());
        }
        this.cacheMap.put(cache.getName(), cache);
    }

    public Iterator getCaches() {
        return this.cacheMap.values().iterator();
    }

    public ParameterMap getParameterMap(String string) {
        if (!this.parameterMaps.containsKey(string)) {
            String string2 = "This SQL map does not contain an ParameterMap named " + string + ".  ";
            if (string != null && string.endsWith(".inline")) {
                string2 = string2 + "The name 'inline' is no longer supported for inline parameters.  Use inline-parameters=\"true\" instead (or don't specify use default of true).";
            }
            throw new SqlMapException(string2);
        }
        return (ParameterMap)this.parameterMaps.get(string);
    }

    public void addParameterMap(ParameterMap parameterMap) {
        if (this.parameterMaps.containsKey(parameterMap.getName())) {
            throw new SqlMapException("This SQL map already contains an ParameterMap named " + parameterMap.getName());
        }
        this.parameterMaps.put(parameterMap.getName(), parameterMap);
    }

    public ResultMap getResultMap(String string) {
        if (!this.resultMaps.containsKey(string)) {
            throw new SqlMapException("This SQL map does not contain an ResultMap named " + string);
        }
        return (ResultMap)this.resultMaps.get(string);
    }

    public void addResultMap(ResultMap resultMap) {
        if (this.resultMaps.containsKey(resultMap.getName())) {
            throw new SqlMapException("This SQL map already contains an ResultMap named " + resultMap.getName());
        }
        this.resultMaps.put(resultMap.getName(), resultMap);
    }

    public String getCurrentDataSourceName() {
        return this.currentDataSourceName;
    }

    public void setCurrentDataSourceName(String string) {
        if (!this.dataSourceMap.containsKey(string)) {
            throw new SqlMapException("Could not set current DataSource.  Invalid name '" + string + "'.  ");
        }
        this.currentDataSourceName = string;
    }

    private Connection getConnectionFromCurrentDataSource() throws SQLException {
        DataSource dataSource = this.getCurrentDataSource();
        if (dataSource == null) {
            throw new SQLException("Current DataSource was null (Use setCurrentDataSource())).");
        }
        Connection connection = dataSource.getConnection();
        return connection;
    }

    private void closeConnection(Connection connection) throws SQLException {
        if (connection != null && !connection.isClosed()) {
            connection.close();
        }
    }

    private void setCurrentLocalConnection(Connection connection) {
        this.localTransaction.set(connection);
    }

    public Connection getCurrentLocalConnection() {
        return (Connection)this.localTransaction.get();
    }

    private Connection removeCurrentLocalConnection() {
        Connection connection = (Connection)this.localTransaction.get();
        this.localTransaction.set(null);
        return connection;
    }

    public void startTransaction() throws SQLException {
        if (this.getCurrentLocalConnection() != null) {
            throw new SQLException("A transaction has already been started.  Call commit() or rollback() before starting a new one.");
        }
        try {
            Connection connection;
            this.incrementTransactionThrottle();
            if (this.useGlobalTransaction && this.userTransaction != null) {
                this.userTransaction.begin();
            }
            if ((connection = this.getConnectionFromCurrentDataSource()).getAutoCommit()) {
                connection.setAutoCommit(false);
            }
            this.setCurrentLocalConnection(connection);
        }
        catch (JtaTransactionException jtaTransactionException) {
            try {
                this.userTransaction.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.removeCurrentLocalConnection();
            this.decrementTransactionThrottle();
            throw new SQLException("An error occurred while trying to START the GLOBAL transaction.  Cause: " + jtaTransactionException);
        }
        catch (SQLException sQLException) {
            try {
                this.userTransaction.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.removeCurrentLocalConnection();
            this.decrementTransactionThrottle();
            throw sQLException;
        }
    }

    public void commitTransaction() throws SQLException {
        Connection connection = this.getCurrentLocalConnection();
        if (connection == null) {
            throw new SQLException("Could not commit transaction.  No transaction was started.  Call startTransaction() first.");
        }
        try {
            if (this.useGlobalTransaction) {
                if (this.userTransaction != null) {
                    try {
                        this.userTransaction.commit();
                    }
                    catch (Exception exception) {
                        try {
                            this.userTransaction.rollback();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw new SQLException("An error occurred while trying to COMMIT the GLOBAL transaction.  Cause: " + exception);
                    }
                }
                this.closeConnection(connection);
            } else {
                connection.commit();
                this.closeConnection(connection);
            }
            Object var5_4 = null;
            this.removeCurrentLocalConnection();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.removeCurrentLocalConnection();
            this.decrementTransactionThrottle();
            throw throwable;
        }
        this.decrementTransactionThrottle();
    }

    public void rollbackTransaction() throws SQLException {
        try {
            Connection connection = this.getCurrentLocalConnection();
            if (connection != null) {
                if (this.useGlobalTransaction) {
                    if (this.userTransaction != null) {
                        try {
                            this.userTransaction.rollback();
                        }
                        catch (Exception exception) {
                            throw new SQLException("An error occurred while trying to ROLLBACK the GLOBAL transaction.  Cause: " + exception);
                        }
                    }
                    this.closeConnection(connection);
                } else {
                    connection.rollback();
                    this.closeConnection(connection);
                }
            }
            Object var4_3 = null;
            this.removeCurrentLocalConnection();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.removeCurrentLocalConnection();
            this.decrementTransactionThrottle();
            throw throwable;
        }
        this.decrementTransactionThrottle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate(String string, Object object) throws SQLException {
        int n;
        boolean bl = true;
        boolean bl2 = !this.useGlobalTransaction;
        Connection connection = this.getCurrentLocalConnection();
        if (connection == null) {
            bl = false;
            connection = this.getConnectionFromCurrentDataSource();
            if (bl2 != connection.getAutoCommit()) {
                connection.setAutoCommit(bl2);
            }
        }
        MappedStatement mappedStatement = this.getMappedStatement(string);
        try {
            n = mappedStatement.executeUpdate(connection, object);
            Object var9_8 = null;
            if (bl) return n;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl) throw throwable;
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object executeQueryForObject(String string, Object object) throws SQLException {
        Object object2;
        boolean bl = true;
        boolean bl2 = !this.useGlobalTransaction;
        Connection connection = this.getCurrentLocalConnection();
        if (connection == null) {
            bl = false;
            connection = this.getConnectionFromCurrentDataSource();
            if (bl2 != connection.getAutoCommit()) {
                connection.setAutoCommit(bl2);
            }
        }
        MappedStatement mappedStatement = this.getMappedStatement(string);
        try {
            object2 = mappedStatement.executeQueryForObject(connection, object);
            Object var9_8 = null;
            if (bl) return object2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl) throw throwable;
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object executeQueryForObject(String string, Object object, Object object2) throws SQLException {
        Object object3;
        boolean bl = true;
        boolean bl2 = !this.useGlobalTransaction;
        Connection connection = this.getCurrentLocalConnection();
        if (connection == null) {
            bl = false;
            connection = this.getConnectionFromCurrentDataSource();
            if (bl2 != connection.getAutoCommit()) {
                connection.setAutoCommit(bl2);
            }
        }
        MappedStatement mappedStatement = this.getMappedStatement(string);
        try {
            object3 = mappedStatement.executeQueryForObject(connection, object, object2);
            Object var10_9 = null;
            if (bl) return object3;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (bl) throw throwable;
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
        return object3;
    }

    public Map executeQueryForMap(String string, Object object, String string2) throws SQLException {
        return this.executeQueryForMap(string, object, string2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map executeQueryForMap(String string, Object object, String string2, String string3) throws SQLException {
        Map map;
        boolean bl = true;
        boolean bl2 = !this.useGlobalTransaction;
        Connection connection = this.getCurrentLocalConnection();
        if (connection == null) {
            bl = false;
            connection = this.getConnectionFromCurrentDataSource();
            if (bl2 != connection.getAutoCommit()) {
                connection.setAutoCommit(bl2);
            }
        }
        MappedStatement mappedStatement = this.getMappedStatement(string);
        try {
            map = mappedStatement.executeQueryForMap(connection, object, string2, string3);
            Object var11_10 = null;
            if (bl) return map;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (bl) throw throwable;
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List executeQueryForList(String string, Object object) throws SQLException {
        List list;
        boolean bl = true;
        boolean bl2 = !this.useGlobalTransaction;
        Connection connection = this.getCurrentLocalConnection();
        if (connection == null) {
            bl = false;
            connection = this.getConnectionFromCurrentDataSource();
            if (bl2 != connection.getAutoCommit()) {
                connection.setAutoCommit(bl2);
            }
        }
        MappedStatement mappedStatement = this.getMappedStatement(string);
        try {
            list = mappedStatement.executeQueryForList(connection, object);
            Object var9_8 = null;
            if (bl) return list;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl) throw throwable;
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List executeQueryForList(String string, Object object, int n, int n2) throws SQLException {
        List list;
        boolean bl = true;
        boolean bl2 = !this.useGlobalTransaction;
        Connection connection = this.getCurrentLocalConnection();
        if (connection == null) {
            bl = false;
            connection = this.getConnectionFromCurrentDataSource();
            if (bl2 != connection.getAutoCommit()) {
                connection.setAutoCommit(bl2);
            }
        }
        MappedStatement mappedStatement = this.getMappedStatement(string);
        try {
            list = mappedStatement.executeQueryForList(connection, object, n, n2);
            Object var11_10 = null;
            if (bl) return list;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (bl) throw throwable;
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
        return list;
    }

    public PaginatedList executeQueryForPaginatedList(String string, Object object, int n) throws SQLException {
        MappedStatement mappedStatement = this.getMappedStatement(string);
        PaginatedList paginatedList = mappedStatement.executeQueryForPaginatedList(object, n);
        return paginatedList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeQueryWithRowHandler(String string, Object object, RowHandler rowHandler) throws SQLException {
        boolean bl = true;
        boolean bl2 = !this.useGlobalTransaction;
        Connection connection = this.getCurrentLocalConnection();
        if (connection == null) {
            bl = false;
            connection = this.getConnectionFromCurrentDataSource();
            if (bl2 != connection.getAutoCommit()) {
                connection.setAutoCommit(bl2);
            }
        }
        MappedStatement mappedStatement = this.getMappedStatement(string);
        try {
            mappedStatement.executeQueryWithRowHandler(connection, object, rowHandler);
            Object var9_8 = null;
            if (bl) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl) throw throwable;
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
    }

    public void startBatch() throws SQLException {
        this.localBatch.set(new HashMap());
    }

    public void endBatch() throws SQLException {
        HashMap hashMap = (HashMap)this.localBatch.get();
        this.localBatch.set(null);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object var5_4;
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = (PreparedStatement)hashMap.get(iterator.next());
                preparedStatement.executeBatch();
                var5_4 = null;
                if (preparedStatement == null) continue;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            preparedStatement.close();
            {
            }
        }
    }

    public boolean isInsideBatch() {
        return this.localBatch.get() != null;
    }

    private void incrementTransactionThrottle() {
        if (this.transactionThrottle != null) {
            this.transactionThrottle.increment(this);
        }
    }

    private void decrementTransactionThrottle() {
        if (this.transactionThrottle != null) {
            this.transactionThrottle.decrement(this);
        }
    }

    void registerStatementWithBatch(MappedStatement mappedStatement, PreparedStatement preparedStatement) {
        HashMap hashMap = (HashMap)this.localBatch.get();
        hashMap.put(mappedStatement, preparedStatement);
    }

    PreparedStatement getStatementFromBatch(MappedStatement mappedStatement) {
        HashMap hashMap = (HashMap)this.localBatch.get();
        return (PreparedStatement)hashMap.get(mappedStatement);
    }

    void incrementExecutionThrottle(Connection connection) {
        if (this.executePerConnThrottle != null) {
            this.executePerConnThrottle.increment(connection);
        }
        if (this.executeThrottle != null) {
            this.executeThrottle.increment(this);
        }
    }

    void decrementExecutionThrottle(Connection connection) {
        if (this.executePerConnThrottle != null) {
            this.executePerConnThrottle.decrement(connection);
        }
        if (this.executeThrottle != null) {
            this.executeThrottle.decrement(this);
        }
    }
}

