/**
 * User: Clinton Begin
 * Date: Jul 13, 2003
 * Time: 7:24:04 PM
 */
package com.ibatis.jpetstore.persistence.dao.sqlmapdao;

import com.ibatis.db.dao.*;
import com.ibatis.db.dao.jdbc.*;
import com.ibatis.db.sqlmap.*;
import com.ibatis.common.util.*;

import java.util.*;
import java.sql.*;

public class BaseSqlMapDao implements Dao {

  protected static final int PAGE_SIZE = 4;

  /**
   * Looks up the parent DaoManager, gets the local transaction
   * (which should be a SqlMapDaoTransaction) and returns the
   * SqlMap associated with this DAO.
   * @return The SqlMap instance for this DAO.
   * @throws DaoException
   */
  protected SqlMap getLocalSqlMap ()
      throws DaoException {
    DaoManager daoManager = DaoManager.getInstance(this);
    SqlMapDaoTransaction trans = (SqlMapDaoTransaction) daoManager.getLocalTransaction();
    return trans.getSqlMap();
  }

  /**
   * Simple convenience method to wrap the SqlMap method of the same name.
   * Wraps the exception with a DaoException to isolate the SqlMap framework.
   * @param statementName
   * @param parameterObject
   * @return
   * @throws DaoException
   */
  protected List executeQueryForList(String statementName, Object parameterObject)
      throws DaoException {
    SqlMap sqlMap = getLocalSqlMap();
    try {
      return sqlMap.executeQueryForList(statementName, parameterObject);
    } catch (SQLException e) {
      throw new DaoException ("Error executing query for list.  Cause: " + e, e);
    }
  }

  /**
   * Simple convenience method to wrap the SqlMap method of the same name.
   * Wraps the exception with a DaoException to isolate the SqlMap framework.
   * @param statementName
   * @param parameterObject
   * @return
   * @throws DaoException
   */
  protected List executeQueryForList(String statementName, Object parameterObject, int skipResults, int maxResults)
      throws DaoException {
    SqlMap sqlMap = getLocalSqlMap();
    try {
      return sqlMap.executeQueryForList(statementName, parameterObject, skipResults, maxResults);
    } catch (SQLException e) {
      throw new DaoException ("Error executing query for list.  Cause: " + e, e);
    }
  }

  /**
   * Simple convenience method to wrap the SqlMap method of the same name.
   * Wraps the exception with a DaoException to isolate the SqlMap framework.
   * @param statementName
   * @param parameterObject
   * @return
   * @throws DaoException
   */
  protected PaginatedList executeQueryForPaginatedList(String statementName, Object parameterObject, int pageSize)
      throws DaoException {
    SqlMap sqlMap = getLocalSqlMap();
    try {
      return sqlMap.executeQueryForPaginatedList(statementName, parameterObject, pageSize);
    } catch (SQLException e) {
      throw new DaoException ("Error executing query for paginated list.  Cause: " + e, e);
    }
  }

  /**
   * Simple convenience method to wrap the SqlMap method of the same name.
   * Wraps the exception with a DaoException to isolate the SqlMap framework.
   * @param statementName
   * @param parameterObject
   * @return
   * @throws DaoException
   */
  protected Object executeQueryForObject(String statementName, Object parameterObject)
      throws DaoException {
    SqlMap sqlMap = getLocalSqlMap();
    try {
      return sqlMap.executeQueryForObject(statementName, parameterObject);
    } catch (SQLException e) {
      throw new DaoException ("Error executing query for object.  Cause: " + e, e);
    }
  }

  /**
   * Simple convenience method to wrap the SqlMap method of the same name.
   * Wraps the exception with a DaoException to isolate the SqlMap framework.
   * @param statementName
   * @param parameterObject
   * @return
   * @throws DaoException
   */
  protected int executeUpdate(String statementName, Object parameterObject)
      throws DaoException {
    SqlMap sqlMap = getLocalSqlMap();
    try {
      return sqlMap.executeUpdate(statementName, parameterObject);
    } catch (SQLException e) {
      throw new DaoException ("Error executing update.  Cause: " + e, e);
    }
  }




}
