/**
 * User: Clinton Begin
 * Date: Jul 13, 2003
 * Time: 7:21:08 PM
 */
package com.ibatis.jpetstore.persistence.dao.sqlmapdao;

import com.ibatis.db.dao.*;
import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.persistence.dao.iface.*;
import com.ibatis.common.util.*;

import java.util.*;

public class ItemSqlMapDao extends BaseSqlMapDao implements ItemDao {

  public void updateQuantity(Order order)
      throws DaoException {
    for (int i = 0; i < order.getLineItems().size(); i++) {
      LineItem lineItem = (LineItem) order.getLineItems().get(i);
      String itemId = lineItem.getItemId();
      Integer increment = new Integer(lineItem.getQuantity());
      Map param = new HashMap(2);
      param.put("itemId", itemId);
      param.put("increment", increment);
      executeUpdate("updateInventoryQuantity", param);
    }
  }

  public boolean isItemInStock(String itemId)
      throws DaoException {
    Integer i = (Integer) executeQueryForObject("getInventoryQuantity", itemId);
    return (i != null && i.intValue() > 0);
  }

  public PaginatedList getItemListByProduct(String productId)
      throws DaoException {
    return executeQueryForPaginatedList("getItemListByProduct", productId, PAGE_SIZE);
  }

  public Item getItem(String itemId)
      throws DaoException {
    Integer i = (Integer) executeQueryForObject("getInventoryQuantity", itemId);
    Item item = (Item) executeQueryForObject("getItem", itemId);
    item.setQuantity(i.intValue());
    return item;
  }

}
