/**
 * User: Clinton Begin
 * Date: Jul 13, 2003
 * Time: 7:20:54 PM
 */
package com.ibatis.jpetstore.persistence.dao.sqlmapdao;

import com.ibatis.db.dao.*;
import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.persistence.dao.iface.*;
import com.ibatis.common.util.*;

import java.util.*;

public class ProductSqlMapDao extends BaseSqlMapDao implements ProductDao {

  public PaginatedList getProductListByCategory(String categoryId)
      throws DaoException {
    return executeQueryForPaginatedList("getProductListByCategory", categoryId, PAGE_SIZE);
  }

  public Product getProduct(String productId) throws DaoException {
    return (Product) executeQueryForObject("getProduct", productId);
  }

  public PaginatedList searchProductList(String keywords)
      throws DaoException {
    Object parameterObject = new ProductSearch(keywords);
    return executeQueryForPaginatedList("searchProductList", parameterObject, PAGE_SIZE);
  }

  /* Inner Classes */

  public static class ProductSearch {
    private List keywordList = new ArrayList();

    public ProductSearch(String keywords) {
      StringTokenizer splitter = new StringTokenizer(keywords, " ", false);
      while (splitter.hasMoreTokens()) {
        keywordList.add("%" + splitter.nextToken() + "%");
      }
    }

    public List getKeywordList() {
      return keywordList;
    }
  }

}
