package com.ibatis.jpetstore.presentation.action;

import com.ibatis.jpetstore.domain.logic.*;
import org.apache.struts.action.*;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

public abstract class BaseAction extends Action {

  /* Constants */

  protected static final PetStoreLogic petStore = PetStoreLogic.getInstance();

  /* Public Methods */

  public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    try {
      return doPerform(mapping, form, request, response);
    } catch (Exception e) {
      request.setAttribute("message", "Unhandled Exception: " + e.toString());
      return mapping.findForward("unknown-error");
    }
  }

  public abstract ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception;

}
