package com.ibatis.jpetstore.presentation.action;

import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.presentation.form.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;

public class EditAccountAction extends SecureBaseAction {

  /* Public Methods */

  public ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

    AccountForm acctForm = (AccountForm) form;

    try {

      if (AccountForm.VALIDATE_EDIT_ACCOUNT.equals(acctForm.getValidate())) {
        acctForm.getAccount().setListOption(request.getParameter("account.listOption") != null);
        acctForm.getAccount().setBannerOption(request.getParameter("account.bannerOption") != null);

        Account account = acctForm.getAccount();


        petStore.updateAccount(account);
        acctForm.setAccount(petStore.getAccount(account.getUsername()));

        acctForm.setMyList(petStore.getProductListByCategory(account.getFavouriteCategoryId()));

        request.getSession().setAttribute("accountForm", acctForm);
        request.getSession().removeAttribute("workingAccountForm");

        return mapping.findForward("success");
      } else {
        request.setAttribute("message", "Your account was not updated because the submitted information was not validated.");
        return mapping.findForward("failure");
      }
    } catch (Exception e) {
      request.setAttribute("message", "There was a problem updating your Account Information.  Cause: " + e);
      return mapping.findForward("unknown-error");
    }

  }


}
