package com.ibatis.jpetstore.presentation.action;

import com.ibatis.jpetstore.domain.*;
import com.ibatis.jpetstore.presentation.form.*;
import org.apache.struts.action.*;

import javax.servlet.http.*;
import java.util.*;

public class EditAccountFormAction extends SecureBaseAction {

  /* Public Methods */

  public ActionForward doPerform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
    AccountForm workingAcctForm = (AccountForm) form;

    AccountForm acctForm = (AccountForm) request.getSession().getAttribute("accountForm");
    String username = acctForm.getAccount().getUsername();

    if (workingAcctForm.getAccount() == null) {
      Account account = petStore.getAccount(username);
      workingAcctForm.setAccount(account);
    }

    if (workingAcctForm.getCategories() == null) {
      List categories = petStore.getCategoryList();
      workingAcctForm.setCategories(categories);
    }

    return mapping.findForward("success");
  }


}
